package com.ejianc.business.sub.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.vo.SubContractDetailVO;
import com.ejianc.business.sub.vo.SubSqlParam;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Mapper
public interface SubContractMapper extends BaseCrudMapper<SubContractEntity> {
    List<Map<String, Object>> payMnyWarn(@Param(value = "sqlParamList") List<SubSqlParam> sqlParamList);

    List<Map<String, Object>> prePayMnyWarn(@Param(value = "sqlParamList") List<SubSqlParam> sqlParamList);

    List<Map<String, Object>> finishMnyWarn(@Param(value = "sqlParamList") List<SubSqlParam> sqlParamList);

    List<Map<String, Object>> invoicePayMnyWarn(@Param(value = "sqlParamList") List<SubSqlParam> sqlParamList);

    List<Map<String, Object>> invoiceContractMnyWarn(@Param(value = "sqlParamList") List<SubSqlParam> sqlParamList);

    List<SubWarnVo> subProjectOutMny(@Param(value = "tenantIds") List<Long> tenantIds);

    List<SubProjectReportVo> getMonthSubMny(@Param(value = "projectId") Long projectId, @Param(value = "lastDay") Integer lastDay);

    BigDecimal getSubContract(@Param(value = "projectId") Long projectId);

    List<SubProjectSettleNumVO> getSubSettleNum(@Param(value = "projectIds") List<Long> projectIds);

    List<SubContractDetailVO> queryContractDetailList(Map<String, Object> map);

    BigDecimal fetchSjzcje(@Param(value = "projectId") Long projectId,
                           @Param(value = "id") Long id,
                           @Param(value = "contractId") Long contractId);

    List<SubContractDetailVO> queryApplySubCount(IPage pages, @Param(Constants.WRAPPER) QueryWrapper qw);
}
