package com.ejianc.business.bidprice.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 材料定标-租赁清单
 * 
 * @author generator
 * 
 */
@ApiModel("材料定标-租赁清单")
public class MaterialPicketageRentDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表id")
    private Long picketageId;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物资分类id")
    private Long materialCategoryId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("参考价")
    private BigDecimal referPrice;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("金额")
    private BigDecimal mny;
    @ApiModelProperty("报价区间")
    private String quoteArea;
    @ApiModelProperty("租赁方式")
    private String rentMode;
    @ApiModelProperty("租期")
    private BigDecimal rentTerm;
    @ApiModelProperty("来源id")
    private String sourceId; // 来源id
    @ApiModelProperty("来源物资来源类型：1-物料档案，2-用料申请,3-新增")
    private String sourceType; // 物资来源类型：1-物料档案，2-用料申请,3-新增
    @ApiModelProperty("材料定标-供应商")
    private List<MaterialPicketageSupplierVO> materialPicketageSupplierList = new ArrayList<>();

    /**
     * 主表id
     */
    public Long getPicketageId() {
        return picketageId;
    }

    /**
     * 主表id
     */
    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 参考价
     */
    public BigDecimal getReferPrice() {
        return referPrice;
    }

    /**
     * 参考价
     */
    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 金额
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 金额
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 报价区间
     */
    public String getQuoteArea() {
        return quoteArea;
    }

    /**
     * 报价区间
     */
    public void setQuoteArea(String quoteArea) {
        this.quoteArea = quoteArea;
    }
    /**
     * 租赁方式
     */
    public String getRentMode() {
        return rentMode;
    }

    /**
     * 租赁方式
     */
    public void setRentMode(String rentMode) {
        this.rentMode = rentMode;
    }

    public BigDecimal getRentTerm() {
        return rentTerm;
    }

    public void setRentTerm(BigDecimal rentTerm) {
        this.rentTerm = rentTerm;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public List<MaterialPicketageSupplierVO> getMaterialPicketageSupplierList() {
        return materialPicketageSupplierList;
    }

    public void setMaterialPicketageSupplierList(List<MaterialPicketageSupplierVO> materialPicketageSupplierList) {
        this.materialPicketageSupplierList = materialPicketageSupplierList;
    }
}
