package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.*;
import com.ejianc.business.income.history.ChangeHistoryVo;
import com.ejianc.business.income.mapper.ChangeMapper;
import com.ejianc.business.income.mapper.ContractMapper;
import com.ejianc.business.income.service.*;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.*;
import com.ejianc.business.income.vo.comparator.ContractDetailComparatorVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * <p>
 * 施工合同变更表 服务实现类
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@Service("ChangeService")
public class ChangeServiceImpl extends BaseServiceImpl<ChangeMapper, ChangeEntity> implements IChangeService {
    private static final String CHANGE_BILL_CODE = "INCOME_CHANGE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IChangeDetailService changeDetailService;
    @Autowired
    private IChangeClauseService changeClauseService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ChangeMapper changeMapper;
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private IContractDetailService detailsService;
    @Autowired
    private IContractClauseService clauseService;

    @Override
    public CommonResponse<ChangeVo> saveOrUpdate(ChangeVo changeVo) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        ChangeEntity entity = null;
        String operateType = null;
        if (StringUtils.isBlank(changeVo.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(CHANGE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                changeVo.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (changeVo.getId() != null && changeVo.getId() > 0&& null!=changeService.getById(changeVo.getId())) { //修改
            entity = BeanMapper.map(changeVo, ChangeEntity.class);
            operateType = "edit";
        } else {
            if (null == changeVo.getChangeVersion() || changeVo.getChangeVersion() == 0) {
                changeVo.setChangeVersion(1);//第一次变更
            } else {
                changeVo.setChangeVersion(changeVo.getChangeVersion() + 1);//版本号+1
            }
            if(2==changeVo.getChangeStatus()){
                throw new BusinessException("合同存在变更中单据，不允许保存!");
            }
            entity = BeanMapper.map(changeVo, ChangeEntity.class);

            operateType = "add";
        }
        if (changeVo.getId() != null && changeVo.getId() > 0 && changeService.getById(changeVo.getId())!=null) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<ChangeEntity> lambda = Wrappers.<ChangeEntity>lambdaQuery();
            lambda.eq(ChangeEntity::getBillCode, changeVo.getBillCode());
            lambda.eq(ChangeEntity::getDr, 0);
            lambda.eq(ChangeEntity::getTenantId, tenantId);
            lambda.ne(ChangeEntity::getId, changeVo.getId());
            lambda.ne(ChangeEntity::getContractId, changeVo.getContractId());
            List<ChangeEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<ChangeEntity> lambda = Wrappers.<ChangeEntity>lambdaQuery();
            lambda.eq(ChangeEntity::getTenantId, tenantId);
            lambda.eq(ChangeEntity::getDr, 0);
            lambda.eq(ChangeEntity::getBillCode, changeVo.getBillCode());
            lambda.ne(ChangeEntity::getContractId, changeVo.getContractId());
            List<ChangeEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, changeVo.getBillCode()));
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, changeVo.getContractId()));
        List<ContractEntity> entitiesc = contractService.queryList(queryParam, false);
        if (entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        super.saveOrUpdate(entity);

        List<ChangeDetailVo> detailsVos = changeVo.getCheckList();
        List<ChangeDetailEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();

        if (operateType.equals("add")) {
            for (ChangeDetailVo detailsVo : detailsVos) {
                ChangeDetailEntity detailslist = BeanMapper.map(detailsVo, ChangeDetailEntity.class);
                detailslist.setChangeId(entity.getId());
                detailslist.setContractId(entity.getContractId());
                detailslist.setContractDetailId(detailsVo.getId());
                detailslist.setId(null);
                detailslist.setBeforeChangeMny(detailsVo.getMny());
                detailslist.setBeforeChangePrice(detailsVo.getPrice());
                detailslist.setBeforeChangeNum(detailsVo.getNum());
                saveOrUpldates.add(detailslist);
            }
        } else {
            for (ChangeDetailVo detailsVo : detailsVos) {
                if ("add".equals(detailsVo.getRowState())) {
                    ChangeDetailEntity detailslist = BeanMapper.map(detailsVo, ChangeDetailEntity.class);
                    detailslist.setChangeId(entity.getId());
                    detailslist.setContractId(entity.getContractId());
                    detailslist.setContractDetailId(detailsVo.getId());
                    detailslist.setId(null);
                    saveOrUpldates.add(detailslist);
                } else if ("edit".equals(detailsVo.getRowState())) {
                    ChangeDetailEntity detailslist = BeanMapper.map(detailsVo, ChangeDetailEntity.class);
                    saveOrUpldates.add(detailslist);
                } else if ("del".equals(detailsVo.getRowState())) {
                    deleteIds.add(detailsVo.getId());
                }
            }
        }

        if (saveOrUpldates.size() > 0) {
            changeDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (ChangeDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ChangeDetailEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            changeDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            changeDetailService.removeByIds(deleteIds, false);
        }


        List<ChangeClauseVo> clauseVos = changeVo.getClauseList();
        List<ChangeClauseEntity> clauseList = new ArrayList<>();
        List<Long> deleteClauseIds = new ArrayList<>();
        for(ChangeClauseVo clauseVo:clauseVos) {
            if("add".equals(clauseVo.getRowState())) {
                ChangeClauseEntity detailslist = BeanMapper.map(clauseVo, ChangeClauseEntity.class);
                detailslist.setChangeId(entity.getId());
                detailslist.setContractId(entity.getContractId());
                detailslist.setId(null);
                clauseList.add(detailslist);
            }else if("edit".equals(clauseVo.getRowState())) {
                ChangeClauseEntity detailslist = BeanMapper.map(clauseVo, ChangeClauseEntity.class);
                clauseList.add(detailslist);
            } else if("del".equals(clauseVo.getRowState())) {
                deleteClauseIds.add(clauseVo.getId());
            }
        }
        if(clauseList.size() > 0) {
            changeClauseService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if(deleteClauseIds.size() > 0) {
            changeClauseService.removeByIds(deleteClauseIds, false);
        }

        //回写主表
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getChangingTaxMny,changeVo.getContractTaxMny());
        updateWrapper.set(ContractEntity::getChangingMny,changeVo.getContractMny());
        updateWrapper.set(ContractEntity::getChangeId,entity.getId());
        updateWrapper.set(ContractEntity::getChangeStatus,2);
        updateWrapper.set(ContractEntity::getChangeCode,entity.getBillCode());
        updateWrapper.eq(ContractEntity::getId,entity.getContractId());
        contractService.update(updateWrapper);

        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public ChangeVo queryDetail(Long id) {
        ChangeEntity entity = super.selectById(id);
        ChangeVo changeVo = BeanMapper.map(entity, ChangeVo.class);
        List<ChangeDetailVo> checkList = changeVo.getCheckList();
        if (checkList != null && checkList.size() > 0) {
            for (ChangeDetailVo cdEntity : checkList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            changeVo.setCheckList(TreeNodeBUtil.buildTree(checkList));
        }
        return changeVo;
    }

    @Override
    public void deleteChange(List<ChangeVo> vos) {
        for (ChangeVo vo : vos) {
            ChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(ContractEntity::getChangingTaxMny,BigDecimal.ZERO);
            updateWrapper.set(ContractEntity::getChangingMny,BigDecimal.ZERO);
            if(changeEntity.getChangeVersion() == 1){
                updateWrapper.set(ContractEntity::getChangeStatus,1);
            }else {
                updateWrapper.set(ContractEntity::getChangeStatus,3);
            }
            updateWrapper.eq(ContractEntity::getId,changeEntity.getContractId());
            contractService.update(updateWrapper);
            super.removeById(vo, false);
        }
    }

    @Override
    public ChangeHistoryVo queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<ChangeEntity> changeEntities = changeMapper.selectList(new QueryWrapper<ChangeEntity>()
                .eq("contract_id", id)
                .in("bill_state", billStatus).orderByDesc("used_time"));
        ContractEntity contractEntity = contractService.selectById(id);
        ChangeHistoryVo vo = new ChangeHistoryVo();
        vo.setContractId(id);
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setBaseTaxMoney(contractEntity.getBaseTaxMoney()== null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney());
        BigDecimal changeMny = vo.getContractTaxMny().subtract(vo.getBaseTaxMoney());
        vo.setSumChangeMny(changeMny);
        BigDecimal sumChangeRate = BigDecimal.ZERO;
        if (vo.getBaseTaxMoney().compareTo(BigDecimal.ZERO) != 0) {
            sumChangeRate = changeMny.divide(vo.getBaseTaxMoney(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
        }
        vo.setSumScale(sumChangeRate);
        if (null != changeEntities && changeEntities.size() > 0) {
            List<ChangeVo> changeVos = BeanMapper.mapList(changeEntities, ChangeVo.class);
            for (ChangeVo cvo : changeVos) {
                String changeTime = new SimpleDateFormat("yyyyMMdd").format(cvo.getChangeTime());
                String historyBillCode = cvo.getBeforeContractName() + "-" + changeTime + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
                BigDecimal subtract = cvo.getContractTaxMny().subtract(cvo.getBeforeChangeTaxMny());
                BigDecimal changeRate = BigDecimal.ZERO;
                if (cvo.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO) != 0) {
                    changeRate = subtract.divide(cvo.getBeforeChangeTaxMny(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                }
                cvo.setScale(changeRate);
                cvo.setbChangeMny(subtract);
            }
            vo.setChangeRecord(changeVos);
        }
        return vo;
    }

    @Override
    public ContractVo queryDetailChange(Long id) {
        ContractEntity entity = contractMapper.selectById(id);
        if(entity != null) {
            ContractVo contractVo = BeanMapper.map(entity, ContractVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractVo.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<ContractDetailEntity> purchaseDetailss = detailsService.queryList(queryParam, false);
            if(purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for(ContractDetailEntity cdEntity:purchaseDetailss){
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                    cdEntity.setRowState("edit");
                }
                List<ContractDetailVo> resultMapList = BeanMapper.mapList(purchaseDetailss, ContractDetailVo.class);
                //实现排序
                Collections.sort(resultMapList,new ContractDetailComparatorVo());
                contractVo.setCheckList(TreeNodeBUtil.buildTree(resultMapList));
            }

            QueryParam query = new QueryParam();
            query.getParams().put("contractId", new Parameter(QueryParam.EQ, contractVo.getId()));
            query.getOrderMap().put("createTime", "desc");
            List<ContractClauseEntity> clauses = clauseService.queryList(query, false);
            if(clauses != null && clauses.size() > 0) {
                List<ContractClauseVo> clauseVoList = BeanMapper.mapList(clauses, ContractClauseVo.class);
                for(ContractClauseVo ccv:clauseVoList){
                    ccv.setRowState("add");
                }
                contractVo.setClauseList(clauseVoList);
            }
            contractVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            contractVo.setChangeReason(null);
            contractVo.setId(IdWorker.getId());
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id),"BT200528000000002","incomeContractBill", String.valueOf(contractVo.getId()), "BT200605000000002","incomeContractBill");
            return contractVo;
        }
        return null;
    }
}
