package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.asset.bean.AssetDisposeDetailEntity;
import com.ejianc.business.asset.bean.AssetDisposeEntity;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetDisposeService;
import com.ejianc.business.asset.service.IAssetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("assetDispose") 
public class AssetDisposeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IAssetDisposeService disposeService;
	@Autowired
	private IAssetService assetService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		AssetDisposeEntity assetDisposeEntity = disposeService.selectById(billId);
		List<Long> assetIdList = assetDisposeEntity.getDetailList().stream().map(AssetDisposeDetailEntity::getAssetId).collect(Collectors.toList());
		logger.info("获取需要修改的固定资产id-{}", JSONObject.toJSONString(assetIdList));
		UpdateWrapper<AssetEntity> assetEntityUpdateWrapper = new UpdateWrapper<>();
		assetEntityUpdateWrapper.in("id", assetIdList)
				.set("equipment_state", 2)
				.set("dispose_mny", assetDisposeEntity.getDisposeMny());
		assetService.update(assetEntityUpdateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		AssetDisposeEntity assetDisposeEntity = disposeService.selectById(billId);
		List<Long> assetIdList = assetDisposeEntity.getDetailList().stream().map(AssetDisposeDetailEntity::getAssetId).collect(Collectors.toList());
		logger.info("获取需要修改的固定资产id-{}", JSONObject.toJSONString(assetIdList));
		assetService.update(new UpdateWrapper<AssetEntity>().eq("id", assetIdList).set("equipment_state", 1).set("dispose_mny", null));
		return CommonResponse.success();
	}

}
