package com.ejianc.business.bidprice.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料定标结果
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_bidprice_material_result")
public class MaterialResultEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="quote_time")
    private Date quoteTime; // 报价时间
    @TableField(value="inquiry_id")
    private Long inquiryId; // 询价单id
    @TableField(value="picketage_id")
    private Long picketageId; // 定标单id
    @TableField(value="picketage_self_flag")
    private Integer picketageSelfFlag; // 定标单自制标识1自制0参照
    @TableField(value="quote_id")
    private Long quoteId; // 供应商报价Id
    @TableField(value="supplier_id")
    private Long supplierId; // 中标供应商Id
    @TableField(value="supplier_name")
    private String supplierName; // 中标供应商名称
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 纳税人识别号
    @TableField(value="legal")
    private String legal; // 联系人
    @TableField(value="telephone")
    private String telephone; // 联系电话
    @TableField(value="total_mny")
    private BigDecimal totalMny; // 报价总金额
    @TableField(value="quote_memo")
    private String quoteMemo; // 报价备注
    @TableField(value="bid_flag")
    private Integer bidFlag; // 是否中标 0-未定标，1-已定标
    @TableField(value="bid_mny")
    private BigDecimal bidMny; // 中标金额
    @TableField(value="bid_memo")
    private String bidMemo; // 中标说明
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织id
    @TableField(value="purchase_subject")
    private String purchaseSubject; // 采购主题
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式：1-项目自采；2-集中采购
    @TableField(value="purchase_type_name")
    private String purchaseTypeName; // 采购方式名称
    @TableField(value="pricing_type")
    private Integer pricingType; // 计价方式：1-采购；2-租赁
    @TableField(value="pricing_type_name")
    private String pricingTypeName; // 计价方式名称
    @TableField(value="inquiry_mny")
    private BigDecimal inquiryMny; // 询价金额
    @TableField(value="handle_date")
    private Date handleDate; // 办理日期

    @TableField(value="contract_sign")
    private Integer contractSign; //合同签订

    @TableField(value="contract_sign_mny")
    private BigDecimal contractSignMny; //合同签金额
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="materialResultPurchaseDetailService")
    private List<MaterialResultPurchaseDetailEntity> materialResultPurchaseDetailList = new ArrayList<>(); // 材料定标结果-采购清单
    @TableField(exist=false)
    @SubEntity(serviceName="materialResultRentDetailService")
    private List<MaterialResultRentDetailEntity> materialResultRentDetailList = new ArrayList<>(); // 材料定标结果-租赁清单


    public Integer getPicketageSelfFlag() {
        return picketageSelfFlag;
    }

    public void setPicketageSelfFlag(Integer picketageSelfFlag) {
        this.picketageSelfFlag = picketageSelfFlag;
    }

    public Integer getContractSign() {
        return contractSign;
    }

    public void setContractSign(Integer contractSign) {
        this.contractSign = contractSign;
    }

    public BigDecimal getContractSignMny() {
        return contractSignMny;
    }

    public void setContractSignMny(BigDecimal contractSignMny) {
        this.contractSignMny = contractSignMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getQuoteTime() {
        return quoteTime;
    }

    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }
    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public Long getPicketageId() {
        return picketageId;
    }

    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }
    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public String getQuoteMemo() {
        return quoteMemo;
    }

    public void setQuoteMemo(String quoteMemo) {
        this.quoteMemo = quoteMemo;
    }
    public Integer getBidFlag() {
        return bidFlag;
    }

    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public String getBidMemo() {
        return bidMemo;
    }

    public void setBidMemo(String bidMemo) {
        this.bidMemo = bidMemo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getPurchaseSubject() {
        return purchaseSubject;
    }

    public void setPurchaseSubject(String purchaseSubject) {
        this.purchaseSubject = purchaseSubject;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }
    public Integer getPricingType() {
        return pricingType;
    }

    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }
    public String getPricingTypeName() {
        return pricingTypeName;
    }

    public void setPricingTypeName(String pricingTypeName) {
        this.pricingTypeName = pricingTypeName;
    }
    public BigDecimal getInquiryMny() {
        return inquiryMny;
    }

    public void setInquiryMny(BigDecimal inquiryMny) {
        this.inquiryMny = inquiryMny;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    

    public List<MaterialResultPurchaseDetailEntity> getMaterialResultPurchaseDetailList() {
        return materialResultPurchaseDetailList;
    }

    public void setMaterialResultPurchaseDetailList(List<MaterialResultPurchaseDetailEntity> materialResultPurchaseDetailList) {
        this.materialResultPurchaseDetailList = materialResultPurchaseDetailList;
    }

    public List<MaterialResultRentDetailEntity> getMaterialResultRentDetailList() {
        return materialResultRentDetailList;
    }

    public void setMaterialResultRentDetailList(List<MaterialResultRentDetailEntity> materialResultRentDetailList) {
        this.materialResultRentDetailList = materialResultRentDetailList;
    }
}
