package com.ejianc.business.material.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.vo.InstoreAccountSumVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.*;

@Mapper
public interface InstoreMaterialMapper extends BaseCrudMapper<InstoreMaterialEntity> {

    Long queryStoreCanUseNumPageDataCount(@Param("searchText") String searchText,
                                          @Param("outDate") String outDate,
                                          @Param("storeId") Long storeId,
                                          @Param("materialTypeName")  String materialTypeName, @Param("materialName") String materialName, @Param("materialSpec") String materialSpec,  @Param("materialUnit") String materialUnit
                                          );

    InstoreMaterialVO censusStorematerial(@Param("storeId") Long storeId);

    List<InstoreMaterialVO> queryStoreCanUseNumPageData(@Param("searchText") String searchText,
                                                        @Param("outDate") String outDate,
                                                        @Param("storeId") Long storeId,
                                                        @Param("startLine") Integer startLine,
                                                        @Param("pageSize") Integer pageSize,
                                                        @Param("materialTypeName")  String materialTypeName, @Param("materialName") String materialName, @Param("materialSpec") String materialSpec,  @Param("materialUnit") String materialUnit);

    Long countStorematerialList(@Param("storeId") Long storeId, @Param("searchText") String searchText);

    List<InstoreMaterialVO> storematerialList(@Param("storeId") Long storeId, @Param("searchText") String searchText,
                                              @Param("startLine") Integer startLine, @Param("pageSize") Integer pageSize);

    BigDecimal countAmount(@Param(Constants.WRAPPER) QueryWrapper<InstoreEntity> queryWrapper);

    Long queryUsableSubMaterialCount(@Param("searchText") String searchText,
                                     @Param("outDate") String outDate,
                                     @Param("storeId") Long storeId,
                                     @Param("materialIds") List<Long> materialIds,@Param("map") HashMap<String, String> map);

    List<InstoreMaterialVO> queryUsableSubMaterialPageList(@Param("searchText") String searchText,
                                                           @Param("outDate") String outDate,
                                                           @Param("storeId") Long storeId,
                                                           @Param("startLine") Integer startLine,
                                                           @Param("pageSize") Integer pageSize,
                                                           @Param("materialIds") List<Long> materialIds,@Param("map") HashMap<String, String> map);

    List<InstoreMaterialVO> querySubMaterialStoreInfo(@Param("storeId") Long storeId, @Param("outDate") Date outDate,
                                                      @Param("materialId") Long materialId, @Param("inventory") double inventory);

    Map<String, BigDecimal> queryStoreLeftMoneyAndMaterialTypeNumByProjectId(@Param("projectId") Long projectId);

    /**
     * @param projectId
     * @param materialIds
     *
     * @description: 根据项目查询已经生效的入库数量
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-27
     */
    List<MaterialPriceVO> queryMaterialInstoreCount(@Param(value = "id") Long id, @Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);

    List<InstoreMaterialVO> instoreNumCount(Map<String, Object> queryParam);

    List<InstoreAccountSumVO> amountSum(@Param("projectIds") List<Long> projectIds);

    /**
     * 历史累计收料入库表体【金额】合计值
     *
     * @param instoreType 入库类型
     * @param projectId   项目id
     * @param instoreId   入库id(主表主键)
     *
     * @return {@link BigDecimal}
     */
    BigDecimal fetchLastTotalAmount(@Param(value = "projectId") Long projectId,
                                    @Param(value = "instoreId") Long instoreId);


    /**
     * 统计历史累计工程量和金额，入库类型：收料入库和直入直出
     *
     * @param instoreId   入库id
     * @param projectId   项目id
     * @param materialIds 物资档案ids
     *
     * @return {@link Map}<{@link Long}, {@link MaterialPriceVO}>
     */
    @MapKey(value = "materialId")
    Map<Long, MaterialPriceVO> sumLastTotalNumAndTotalAmount(@Param(value = "instoreId") Long instoreId,
                                                             @Param(value = "projectId") Long projectId,
                                                             @Param(value = "materialIds") Set<Long> materialIds);


    /**
     * @description: 库存量：该材料在该项目下所有仓库中的现存量合计值 + 该项目本上级所有公司仓的现存量合计值。
     *
     * @return {@link List<com.ejianc.business.material.vo.InstoreMaterialVO>}
     * @author songlx
     * @date: 2024/2/18
     */
    List<InstoreMaterialVO> storeNumCount(@Param("storeIds") List<Long> storeIds, @Param(value = "materialIds") List<Long> materialIds);

}
