package com.ejianc.business.othprice.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 材料定标-采购清单
 * 
 * @author generator
 * 
 */
@ApiModel("材料定标-采购清单")
public class PicketageDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表id")
    private Long picketageId;
    private String detailCode; // 编码
    private String detailName; // 名称
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("参考价")
    private BigDecimal referPrice;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("金额")
    private BigDecimal mny;
    @ApiModelProperty("价格最小值")
    private BigDecimal minPrice;
    @ApiModelProperty("价格最大值")
    private BigDecimal maxPrice;
    @ApiModelProperty("价格区间")
    private String priceArea;
    @ApiModelProperty("报价区间")
    private String quoteArea;
    @ApiModelProperty("来源id")
    private String sourceId; // 来源id
    @ApiModelProperty("来源物资来源类型：1-物料档案，2-用料申请,3-新增")
    private String sourceType; // 物资来源类型：1-物料档案，2-用料申请,3-新增
    @ApiModelProperty("材料定标-供应商")
    private List<PicketageSupplierVO> picketageSupplierList = new ArrayList<>();
    private Long materialId; // 物资id

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    /**
     * 主表id
     */
    public Long getPicketageId() {
        return picketageId;
    }

    /**
     * 主表id
     */
    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 参考价
     */
    public BigDecimal getReferPrice() {
        return referPrice;
    }

    /**
     * 参考价
     */
    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 金额
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 金额
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public BigDecimal getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    public String getPriceArea() {
        return priceArea;
    }

    public void setPriceArea(String priceArea) {
        this.priceArea = priceArea;
    }

    /**
     * 报价区间
     */
    public String getQuoteArea() {
        return quoteArea;
    }

    /**
     * 报价区间
     */
    public void setQuoteArea(String quoteArea) {
        this.quoteArea = quoteArea;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public List<PicketageSupplierVO> getPicketageSupplierList() {
        return picketageSupplierList;
    }

    public void setPicketageSupplierList(List<PicketageSupplierVO> picketageSupplierList) {
        this.picketageSupplierList = picketageSupplierList;
    }
}
