/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageService;
import com.ejianc.business.bidprice.material.service.IMaterialResultService;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/materialPicketage"})
public class ImaterialPicketageApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialPicketageService service;
    @Autowired
    private IMaterialResultService materialResultService;
    @Autowired
    private IMaterialInquiryService materialInquiryService;

    @RequestMapping(value={"/updateContractSignMny"}, method={RequestMethod.POST})
    public CommonResponse<String> updateContractSignMny(@RequestBody MaterialPicketageVO vo) {
        MaterialResultEntity materialResultEntity;
        Long resultId = vo.getId();
        if (resultId != null && (materialResultEntity = (MaterialResultEntity)((Object)this.materialResultService.getById(resultId))) != null) {
            materialResultEntity.setContractSign(vo.getContractSign());
            materialResultEntity.setContractSignMny(vo.getContractSignMny());
            boolean b = this.materialResultService.updateById((Object)materialResultEntity);
            this.logger.info("------\u5b9a\u6807\u7ed3\u679cid:{}, \u5408\u540c\u7b7e\u8ba2\u6570\u91cf:{}" + resultId, (Object)vo.getContractSign());
            if (b) {
                Long picketageId = materialResultEntity.getPicketageId();
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.select(new String[]{"IFNULL(sum(contract_sign),0) as num, IFNULL(sum(contract_sign_mny),0) as money"}).eq((Object)"picketage_id", (Object)picketageId);
                Map map = this.materialResultService.getMap((Wrapper)queryWrapper);
                Integer num = map.get("num") != null ? Integer.valueOf(map.get("num").toString()) : 0;
                BigDecimal money = ComputeUtil.toBigDecimal(map.get("money"));
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)picketageId);
                updateWrapper.set(MaterialPicketageEntity::getContractSign, (Object)num);
                updateWrapper.set(MaterialPicketageEntity::getContractSignMny, (Object)money);
                this.service.update((Wrapper)updateWrapper);
                this.logger.info("------\u5b9a\u6807id:{}, \u5408\u540c\u7b7e\u8ba2\u6570\u91cf:{}" + picketageId, (Object)num);
                LambdaUpdateWrapper inquiryUpdateWrapper = new LambdaUpdateWrapper();
                inquiryUpdateWrapper.eq(BaseEntity::getId, (Object)materialResultEntity.getInquiryId());
                this.logger.info("------\u8be2\u4ef7\u7533\u8bf7id:{}, \u5408\u540c\u7b7e\u8ba2\u6570\u91cf:{}" + materialResultEntity.getInquiryId(), (Object)num);
                if (num > 0) {
                    inquiryUpdateWrapper.set(MaterialInquiryEntity::getInquiryState, (Object)InquiryStateEnum.SIGN_STATE.getCode());
                } else {
                    inquiryUpdateWrapper.set(MaterialInquiryEntity::getInquiryState, (Object)InquiryStateEnum.WIN_STATE.getCode());
                }
                this.materialInquiryService.update((Wrapper)inquiryUpdateWrapper);
            }
        }
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u7b7e\u8ba2\u6570\u6210\u529f\uff01");
    }
}

