/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.ProjectTargetcostDetailEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostEntity;
import com.ejianc.business.cost.mapper.ProjectTargetcostMapper;
import com.ejianc.business.cost.service.IProjectTargetcostDetailService;
import com.ejianc.business.cost.service.IProjectTargetcostService;
import com.ejianc.business.cost.vo.ProjectTargetcostDetailVO;
import com.ejianc.business.cost.vo.ProjectTargetcostVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectTargetcostService")
public class ProjectTargetcostServiceImpl
extends BaseServiceImpl<ProjectTargetcostMapper, ProjectTargetcostEntity>
implements IProjectTargetcostService {
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IProjectTargetcostDetailService detailService;

    @Override
    public JSONObject queryDataByProjectId(Long projectId) {
        JSONObject json = new JSONObject();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        CommonResponse listResponse = this.projectApi.queryProjectByPid(projectId);
        if (listResponse.isSuccess() && listResponse.getData() != null && ((List)listResponse.getData()).size() > 0) {
            for (ProjectRegisterVO vo : (List)listResponse.getData()) {
                projectIds.add(vo.getId());
            }
        } else {
            projectIds.add(projectId);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"project_id", projectIds);
        List list = this.list((Wrapper)wrapper);
        List data = new ArrayList();
        List<ProjectTargetcostDetailVO> detailList = new ArrayList<ProjectTargetcostDetailVO>();
        if (list != null && list.size() > 0) {
            data = BeanMapper.mapList((Iterable)list, ProjectTargetcostVO.class);
            HashMap<Long, List> detailMap = new HashMap<Long, List>();
            ArrayList<ProjectTargetcostDetailVO> allList = new ArrayList<ProjectTargetcostDetailVO>();
            ArrayList<Long> pids = new ArrayList<Long>();
            HashMap<Long, Long> idMap = new HashMap<Long, Long>();
            HashMap<Long, Long> subjectIdMap = new HashMap<Long, Long>();
            HashMap subjectMap = new HashMap();
            for (ProjectTargetcostEntity entity : list) {
                QueryWrapper w = new QueryWrapper();
                w.eq((Object)"targetcost_id", (Object)entity.getId());
                List dList = this.detailService.list((Wrapper)w);
                if (dList == null || dList.size() <= 0) continue;
                detailMap.put(entity.getId(), dList);
                for (Object de : dList) {
                    List<ProjectTargetcostDetailVO> a;
                    idMap.put(de.getId(), IdWorker.getId());
                    ProjectTargetcostDetailVO vo = (ProjectTargetcostDetailVO)((Object)BeanMapper.map((Object)de, ProjectTargetcostDetailVO.class));
                    vo.setProjectId(entity.getProjectId());
                    vo.setProjectName(entity.getProjectName());
                    allList.add(vo);
                    if (((ProjectTargetcostDetailEntity)((Object)de)).getPid() != null && !pids.contains(((ProjectTargetcostDetailEntity)((Object)de)).getPid())) {
                        pids.add(((ProjectTargetcostDetailEntity)((Object)de)).getPid());
                    }
                    if (((ProjectTargetcostDetailEntity)((Object)de)).getAddState() != null && ((ProjectTargetcostDetailEntity)((Object)de)).getAddState().booleanValue()) {
                        detailList.add(vo);
                        continue;
                    }
                    subjectIdMap.put(((ProjectTargetcostDetailEntity)((Object)de)).getSubjectId(), IdWorker.getId());
                    if (subjectMap.get(((ProjectTargetcostDetailEntity)((Object)de)).getSubjectId()) != null) {
                        a = (List)subjectMap.get(((ProjectTargetcostDetailEntity)((Object)de)).getSubjectId());
                        a.add(vo);
                        subjectMap.put(((ProjectTargetcostDetailEntity)((Object)de)).getSubjectId(), a);
                        continue;
                    }
                    a = new ArrayList<ProjectTargetcostDetailVO>();
                    a.add(vo);
                    subjectMap.put(((ProjectTargetcostDetailEntity)((Object)de)).getSubjectId(), a);
                }
            }
            for (ProjectTargetcostDetailVO en : allList) {
                if (en.getSubjectId() == null) continue;
                idMap.put(en.getId(), (Long)subjectIdMap.get(en.getSubjectId()));
            }
            for (Long key : subjectMap.keySet()) {
                List subjectList = (List)subjectMap.get(key);
                if (subjectList == null || subjectList.size() <= 0) continue;
                if (subjectList.size() > 1) {
                    Boolean isParent = false;
                    String projectName = "";
                    for (ProjectTargetcostDetailVO entity : subjectList) {
                        projectName = projectName.length() > 0 ? projectName + "," + entity.getProjectName() : projectName + entity.getProjectName();
                        if (!pids.contains(entity.getId())) continue;
                        isParent = true;
                    }
                    if (isParent.booleanValue()) {
                        ProjectTargetcostDetailVO vo = (ProjectTargetcostDetailVO)((Object)BeanMapper.map(subjectList.get(0), ProjectTargetcostDetailVO.class));
                        vo.setProjectName(projectName);
                        vo.setId((Long)idMap.get(vo.getId()));
                        if (vo.getPid() != null) {
                            vo.setPid((Long)idMap.get(vo.getId()));
                        }
                        detailList.add(vo);
                        continue;
                    }
                    ProjectTargetcostDetailVO vo1 = (ProjectTargetcostDetailVO)((Object)BeanMapper.map(subjectList.get(0), ProjectTargetcostDetailVO.class));
                    Long id = IdWorker.getId();
                    ProjectTargetcostDetailVO d = new ProjectTargetcostDetailVO();
                    d.setAddState(vo1.getAddState());
                    d.setFeeType(vo1.getFeeType());
                    d.setSubjectCode(vo1.getSubjectCode());
                    d.setSubjectId(vo1.getSubjectId());
                    d.setSubjectName(vo1.getSubjectName());
                    d.setSubjectInnerCode(vo1.getSubjectInnerCode());
                    d.setParentInnerCode(vo1.getParentInnerCode());
                    d.setProjectName(projectName);
                    d.setPid((Long)idMap.get(vo1.getPid()));
                    d.setId(id);
                    detailList.add(d);
                    for (ProjectTargetcostDetailVO entity : subjectList) {
                        ProjectTargetcostDetailVO vo = (ProjectTargetcostDetailVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectTargetcostDetailVO.class));
                        vo.setPid(id);
                        vo.setId(IdWorker.getId());
                        detailList.add(vo);
                    }
                    continue;
                }
                ProjectTargetcostDetailVO vo = (ProjectTargetcostDetailVO)((Object)BeanMapper.map(subjectList.get(0), ProjectTargetcostDetailVO.class));
                if (vo.getPid() != null) {
                    vo.setPid((Long)idMap.get(vo.getPid()));
                }
                vo.setId((Long)idMap.get(vo.getId()));
                detailList.add(vo);
            }
            if (CollectionUtils.isNotEmpty(detailList)) {
                detailList.sort(Comparator.comparing(ProjectTargetcostDetailVO::getSubjectInnerCode, Comparator.nullsLast(String::compareTo)).thenComparing(ProjectTargetcostDetailVO::getProjectId, Comparator.nullsLast(Long::compare)).thenComparing(BaseVO::getId, Comparator.nullsLast(Long::compare)));
                detailList = this.createTreeData1(detailList);
                for (int i = 0; i < detailList.size(); ++i) {
                    ProjectTargetcostDetailVO vo = detailList.get(i);
                    String code = String.valueOf(i + 1);
                    vo.setCode(code);
                    BigDecimal camount = this.addAllAmount(vo, code);
                    vo.setAmount(camount);
                }
            }
        }
        json.put("projectList", data);
        json.put("detailList", detailList);
        return json;
    }

    public List<ProjectTargetcostDetailVO> createTreeData1(List<ProjectTargetcostDetailVO> list) {
        ArrayList<ProjectTargetcostDetailVO> resp = new ArrayList<ProjectTargetcostDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ProjectTargetcostDetailVO> listMap = new HashMap<String, ProjectTargetcostDetailVO>();
        for (ProjectTargetcostDetailVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ProjectTargetcostDetailVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            ProjectTargetcostDetailVO parent = (ProjectTargetcostDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ProjectTargetcostDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ProjectTargetcostDetailVO> children = new ArrayList<ProjectTargetcostDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((ProjectTargetcostDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private BigDecimal addAllAmount(ProjectTargetcostDetailVO vo, String pcode) {
        BigDecimal amount;
        BigDecimal bigDecimal = amount = vo.getAmount() != null ? vo.getAmount() : new BigDecimal(0);
        if (vo.getChildren() != null && vo.getChildren().size() > 0) {
            vo.setProjectId(null);
            amount = new BigDecimal(0);
            for (int i = 0; i < vo.getChildren().size(); ++i) {
                ProjectTargetcostDetailVO c = vo.getChildren().get(i);
                String code = null;
                code = StringUtils.isNotBlank((CharSequence)pcode) ? pcode + "." + (i + 1) : String.valueOf(i + 1);
                c.setCode(code);
                BigDecimal camount = this.addAllAmount(c, code);
                amount = amount.add(camount);
            }
            vo.setAmount(amount);
        }
        return amount;
    }
}

