/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.vo.ProductionDetailVo;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.business.income.vo.report.ProductionReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/production"})
public class ProductionController {
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/init"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> init() {
        long startTime = System.currentTimeMillis();
        List list = this.productionService.list();
        for (Object p : list) {
            BigDecimal contractTaxMny = ((ProductionEntity)((Object)p)).getContractTaxMny();
            BigDecimal sumProductionTaxMny = ((ProductionEntity)((Object)p)).getSumProductionTaxMny();
            BigDecimal sumProductionMny = ((ProductionEntity)((Object)p)).getSumProductionMny();
            BigDecimal finishTaxMny = ((ProductionEntity)((Object)p)).getFinishTaxMny();
            BigDecimal finishMny = ((ProductionEntity)((Object)p)).getFinishMny();
            BigDecimal newSumProTaxMny = ComputeUtil.safeAdd(sumProductionTaxMny, finishTaxMny);
            BigDecimal newSumProMny = ComputeUtil.safeAdd(sumProductionMny, finishMny);
            BigDecimal percent = ComputeUtil.bigDecimalPercent(newSumProTaxMny, contractTaxMny, 2);
            ((ProductionEntity)((Object)p)).setSumProductionTaxMny(newSumProTaxMny);
            ((ProductionEntity)((Object)p)).setSumProductionMny(newSumProMny);
            ((ProductionEntity)((Object)p)).setSumImageProgress(percent);
        }
        this.productionService.updateBatchById(list);
        List entityList = this.quoteService.list();
        for (QuoteEntity p : entityList) {
            BigDecimal contractTaxMny = p.getContractTaxMny();
            BigDecimal sumQuoteTaxMny = p.getSumQuoteTaxMny();
            BigDecimal sumQuoteMny = p.getSumQuoteMny();
            BigDecimal quoteTaxMny = p.getQuoteTaxMny();
            BigDecimal quoteMny = p.getQuoteMny();
            BigDecimal newSumProTaxMny = ComputeUtil.safeAdd(sumQuoteTaxMny, quoteTaxMny);
            BigDecimal newSumProMny = ComputeUtil.safeAdd(sumQuoteMny, quoteMny);
            BigDecimal percent = ComputeUtil.bigDecimalPercent(newSumProTaxMny, contractTaxMny, 8);
            p.setSumQuoteTaxMny(newSumProTaxMny);
            p.setSumQuoteMny(newSumProMny);
            p.setSumQuoteRate(percent);
        }
        this.quoteService.updateBatchById(entityList);
        long endTime = System.currentTimeMillis();
        String msg = "\u66f4\u65b0\u4ea7\u503c\u6570\u91cf\uff1a" + list.size() + "\uff0c\u66f4\u65b0\u7532\u65b9\u6570\u91cf\uff1a" + entityList.size() + "\uff0c\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms";
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProductionVo> saveOrUpdate(@RequestBody ProductionVo productionVo) {
        CommonResponse<ProductionVo> response = this.productionService.saveOrUpdate(productionVo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductionVo> queryDetail(@RequestParam Long id) {
        ProductionVo vo = this.productionService.queryDetail(id);
        return CommonResponse.success((Object)((Object)vo));
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"production-detail-import.xlsx", (String)"\u4ea7\u503c\u660e\u7ec6\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.productionService.excelImport(request, response);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductionEntity>> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.productionService.queryPage(param, false));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionVo> vos) {
        this.productionService.deleteProduction(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryProductionHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductionHistoryVo> queryProductionHistory(@RequestParam Long id) {
        ProductionHistoryVo vo = this.productionService.queryProductionHistory(id);
        return CommonResponse.success((Object)((Object)vo));
    }

    @RequestMapping(value={"/pageRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ProductionEntity>> pageRef(@RequestParam(value="contractId") String contractId, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="productionDate", required=false) String productionDate) {
        QueryParam queryParam = new QueryParam();
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("quoteFlag", new Parameter("eq", (Object)0));
        if (null != productionDate && productionDate.length() > 0) {
            queryParam.getParams().put("productionDate", new Parameter("le", (Object)productionDate));
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
        queryParam.getOrderMap().put("productionDate", "desc");
        queryParam.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u4ea7\u503c\u8fdb\u5ea6\u53c2\u7167\u6210\u529f\uff01", (Object)this.productionService.queryList(queryParam, false));
    }

    @RequestMapping(value={"/detailRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ProductionDetailVo>> detailRef(@RequestParam Long productionId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u4ea7\u503c\u8fdb\u5ea6\u660e\u7ec6\u6210\u529f\uff01", this.productionService.detailRef(productionId));
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.productionService.queryPage(param, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), ProductionVo.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("production-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryProductionDetailHistory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<Long, ProductionDetailVo>> queryProductionDetailHistory(@RequestBody ProductionDetailVo productionDetailVo) {
        Map<Long, ProductionDetailVo> page = this.productionService.queryProductionDetailHistory(productionDetailVo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", page);
    }

    @RequestMapping(value={"/queryInfoProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductionVo> queryInfoProjectId(Long projectId) {
        ProductionVo productionVo = this.productionService.queryInfoProjectId(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)((Object)productionVo));
    }

    @RequestMapping(value={"/queryProductionReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryProductionReport(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u4ea7\u503c\u7edf\u8ba1\u8868\u6210\u529f\uff01", (Object)this.productionService.queryProductionReport(param, Boolean.FALSE));
    }

    @RequestMapping(value={"/excelExportProductionReport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportProductionReport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<ProductionReportVO> records = this.productionService.excelExportProductionReport(queryParam);
        HashMap<String, List<ProductionReportVO>> beans = new HashMap<String, List<ProductionReportVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("production-report-export.xlsx", beans, response);
    }
}

