/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.bean.SubFinishDetailEntity;
import com.ejianc.business.sub.bean.SubFinishEntity;
import com.ejianc.business.sub.bean.SubSettleEntity;
import com.ejianc.business.sub.mapper.SubFinishMapper;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubFinishDetailService;
import com.ejianc.business.sub.service.ISubFinishService;
import com.ejianc.business.sub.service.ISubSettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.SubFinishDetailVO;
import com.ejianc.business.sub.vo.SubFinishRecordDetailVO;
import com.ejianc.business.sub.vo.SubFinishRecordVO;
import com.ejianc.business.sub.vo.SubFinishVO;
import com.ejianc.business.sub.vo.SubParamsCheckDsVO;
import com.ejianc.business.sub.vo.SubParamsCheckVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SubFinishServiceImpl")
public class SubFinishServiceImpl
extends BaseServiceImpl<SubFinishMapper, SubFinishEntity>
implements ISubFinishService {
    private static final String SUB_FINISH_BILL_CODE = "SUB_FINISH";
    private static final String SUB_FINISH = "SUB_FINISH";
    private static final String SUB_FINISH_COST = "SUB_FINISH_COST";
    private static final String CHECK_PARAM_CODE = "P-2452lK17";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISubFinishDetailService finishDetailService;
    @Autowired
    private ISubSettleService settleService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public SubFinishVO insertOrUpdate(SubFinishVO finishVO) {
        SubFinishEntity oldFinish;
        Long oldContractId;
        if (this.checkSameContract(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u505a\u8fc7\u5b8c\u5de5\u7ed3\u7b97\uff01");
        }
        if (this.checkUnEffectSettle(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0e\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u8fc7\u7a0b\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        if ((finishVO.getId() == null || finishVO.getId() <= 0L) && this.checkFinishContract(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b8c\u5de5\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)finishVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("SUB_FINISH", InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                finishVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (this.checkSameBillCode(finishVO).booleanValue()) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        finishVO.setRelationFlag("0");
        finishVO.setProportionFlag("0");
        SubFinishEntity finishEntity = (SubFinishEntity)((Object)BeanMapper.map((Object)((Object)finishVO), SubFinishEntity.class));
        List<SubFinishDetailEntity> beforeDetails = finishEntity.getFinishDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == finishEntity.getId()) {
            for (SubFinishDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        if (finishEntity.getId() != null && (oldContractId = (oldFinish = (SubFinishEntity)((Object)this.getById(finishEntity.getId()))).getContractId()) != null && !oldContractId.equals(finishEntity.getContractId())) {
            this.writeBackContractFinsishFlag(oldFinish, Boolean.FALSE);
        }
        super.saveOrUpdate((Object)finishEntity, false);
        List<SubFinishDetailEntity> finishDetailEntities = finishEntity.getFinishDetailList();
        if (CollectionUtils.isNotEmpty(finishDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (SubFinishDetailEntity cdEntity : finishDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (SubFinishDetailEntity cdEntity : finishDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.finishDetailService.saveOrUpdateBatch(finishDetailEntities, finishDetailEntities.size(), false);
        }
        this.writeBackContractFinsishFlag(finishEntity, Boolean.TRUE);
        return this.queryDetail(finishEntity.getId());
    }

    private Boolean checkSameBillCode(SubFinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SubFinishEntity::getBillCode, (Object)finishVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != finishVO.getId() && finishVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)finishVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkSameContract(SubFinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SubFinishEntity::getContractId, (Object)finishVO.getContractId());
        lambda.eq(SubFinishEntity::getOrgId, (Object)finishVO.getOrgId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != finishVO.getId() && finishVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)finishVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkUnEffectSettle(SubFinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SubSettleEntity::getContractId, (Object)finishVO.getContractId());
        lambda.eq(SubSettleEntity::getOrgId, (Object)finishVO.getOrgId());
        lambda.notIn(SubSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        return this.settleService.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkFinishContract(SubFinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getId, (Object)finishVO.getContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(SubContractEntity::getFinishFlag, (Object)true);
        return this.contractService.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public SubFinishVO queryDetail(Long id) {
        SubFinishEntity finishEntity = (SubFinishEntity)((Object)super.selectById((Serializable)id));
        SubFinishVO finishVO = (SubFinishVO)((Object)BeanMapper.map((Object)((Object)finishEntity), SubFinishVO.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("finishId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityList = this.finishDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (SubFinishDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, SubFinishDetailVO.class);
            SubFinishServiceImpl.sortIntMethod(resultMapList);
            List<SubFinishDetailVO> finishDetailVOS = TreeNodeBUtil.buildTree(resultMapList);
            finishVO.setFinishDetailList(finishDetailVOS);
        }
        finishVO.setUnPaidMoney(ComputeUtil.safeSub(finishEntity.getSettleTaxMny(), finishEntity.getPaidMoney()));
        return finishVO;
    }

    private static void sortIntMethod(List<SubFinishDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                SubFinishDetailVO o1Detail = (SubFinishDetailVO)objectMapper.convertValue(o1, SubFinishDetailVO.class);
                SubFinishDetailVO o2Detail = (SubFinishDetailVO)objectMapper.convertValue(o2, SubFinishDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getTreeIndex().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public CommonResponse<IPage<SubFinishVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("memo");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        boolean payApplyFlagHasFree = param.getParams().containsKey("payApplyFlagHasFree");
        param.getParams().remove("payApplyFlagHasFree");
        IPage page = this.queryPage(param, false);
        List finishVOList = BeanMapper.mapList((Iterable)page.getRecords(), SubFinishVO.class);
        Page finishVOIPage = new Page();
        finishVOIPage.setCurrent(page.getCurrent());
        finishVOIPage.setRecords(finishVOList);
        finishVOIPage.setSize(page.getSize());
        finishVOIPage.setTotal(page.getTotal());
        finishVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)finishVOIPage);
    }

    @Override
    public CommonResponse<String> deleteByIds(List<SubFinishVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List entityList = BeanMapper.mapList((Iterable)super.listByIds(ids), SubFinishEntity.class);
        for (SubFinishEntity finishEntity : entityList) {
            this.writeBackContractFinsishFlag(finishEntity, Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty(vos)) {
            this.removeByIds(ids, false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public SubFinishRecordVO queryDetailRecord(Long id) {
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.selectById(id));
        SubFinishRecordVO finishRecordVO = new SubFinishRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null || contractEntity.getFinishFlag() == false ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumScale = BigDecimalUtils.safeDiv(sumSettleTaxMny, contractTaxMny).multiply(new BigDecimal(100));
        finishRecordVO.setContractId(id);
        finishRecordVO.setFinishFlag(contractEntity.getFinishFlag());
        finishRecordVO.setContractStatus(Integer.valueOf(contractEntity.getContractStatus()));
        finishRecordVO.setPurchaseType(Integer.valueOf(contractEntity.getPurchaseType()));
        finishRecordVO.setContractName(contractEntity.getContractName());
        finishRecordVO.setSupplierName(contractEntity.getSupplierName());
        finishRecordVO.setContractTaxMny(contractTaxMny);
        finishRecordVO.setSumSettleTaxMny(sumSettleTaxMny);
        finishRecordVO.setSumScale(sumScale);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SubFinishEntity::getContractId, (Object)id);
        List entitiesAllState = super.list((Wrapper)lambda);
        lambda.in(SubFinishEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        List finishRecordDetailVOList = BeanMapper.mapList((Iterable)entities, SubFinishRecordDetailVO.class);
        if (CollectionUtils.isNotEmpty((Collection)finishRecordDetailVOList)) {
            finishRecordDetailVOList.forEach(entity -> {
                BigDecimal settleTaxMny = entity.getSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSettleTaxMny();
                BigDecimal scale = contractTaxMny == BigDecimal.ZERO ? BigDecimal.ZERO : ComputeUtil.safeDiv(settleTaxMny, contractTaxMny).multiply(new BigDecimal(100));
                entity.setSumScale(scale);
            });
        }
        finishRecordVO.setDetailList(BeanMapper.mapList((Iterable)entitiesAllState, SubFinishRecordDetailVO.class));
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(SubSettleEntity::getContractId, (Object)id);
        lambda2.in(SubSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List settleList = this.settleService.list((Wrapper)lambda2);
        BigDecimal settleTaxMny = new BigDecimal(0);
        for (SubSettleEntity settle : settleList) {
            settleTaxMny = settleTaxMny.add(settle.getSettleTaxMny() == null ? BigDecimal.ZERO : settle.getSettleTaxMny());
        }
        finishRecordVO.setSettleTaxMny(settleTaxMny);
        finishRecordVO.setSettleBalanceMny(sumSettleTaxMny.subtract(settleTaxMny));
        return finishRecordVO;
    }

    @Override
    public SubFinishVO queryDetailAdd(Long contractId) {
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.selectById(contractId));
        SubFinishVO finishVO = (SubFinishVO)((Object)BeanMapper.map((Object)((Object)contractEntity), SubFinishVO.class));
        finishVO.setBillCode(null);
        finishVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        finishVO.setEmployeeName(null);
        finishVO.setContractId(contractEntity.getId());
        finishVO.setBillState(null);
        finishVO.setCreateUserCode(null);
        finishVO.setCreateTime(null);
        finishVO.setUpdateUserCode(null);
        finishVO.setUpdateTime(null);
        finishVO.setId(null);
        finishVO.setVersion(null);
        finishVO.setTaxMny(null);
        finishVO.setSumInvoiceTaxMny(null);
        finishVO.setContractVersion(contractEntity.getVersion());
        return finishVO;
    }

    @Override
    public List<SubFinishVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = ((IPage)this.queryListVOs(param).getData()).getRecords();
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                SubFinishVO vo = (SubFinishVO)((Object)resVos.get(i));
                if (vo.getContractType() != null) {
                    if (vo.getContractType().equals(Long.valueOf("1270328729526124545"))) {
                        vo.setContractTypeName("\u4e13\u4e1a\u5206\u5305");
                    } else if (vo.getContractType().equals(Long.valueOf("1270328674299723778"))) {
                        vo.setContractTypeName("\u52b3\u52a1\u5206\u5305");
                    }
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public SubParamsCheckVO checkParams(Integer purchaseType, BigDecimal settleTaxMny, BigDecimal contractTaxMny, Long orgId) {
        Long curOrgId = Optional.ofNullable(orgId).orElse(InvocationInfoProxy.getOrgId());
        HashMap<String, List<SubParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<SubParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        SubParamsCheckVO paramsCheckVO = new SubParamsCheckVO();
        ArrayList<SubParamsCheckDsVO> checkDsVOS = new ArrayList<SubParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, curOrgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            for (BillParamVO datum : data) {
                BigDecimal roleValue = datum.getRoleValue();
                BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, 4));
                if (2 == purchaseType) {
                    paramsCheckVO.setWarnType(paramsArray[0]);
                    return paramsCheckVO;
                }
                paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                if (settleTaxMny.compareTo(comMny) <= 0) continue;
                SubParamsCheckDsVO paramsCheckDsVO = new SubParamsCheckDsVO();
                paramsCheckDsVO.setOrgName(datum.getOrgName());
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u5b8c\u5de5\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(settleTaxMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue.setScale(2, 4)).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(settleTaxMny.subtract(comMny).setScale(2, 4)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
                SubFinishServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        SubParamsCheckVO pc = new SubParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<SubParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, SubParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<SubParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<SubParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    private void writeBackContractFinsishFlag(SubFinishEntity finishEntity, Boolean finishFlag) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SubContractEntity::getContractStatus, (Object)(finishFlag != false ? "3" : "2"));
        updateWrapper.set(SubContractEntity::getFinishFlag, (Object)finishFlag);
        updateWrapper.eq(BaseEntity::getId, (Object)finishEntity.getContractId());
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.getById(finishEntity.getContractId()));
        this.contractService.update((Wrapper)updateWrapper);
    }
}

