/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sync.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.PreBidCostCalcDetailEntity;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.service.IPreBidCostCalcDetailService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.vo.PreBidCostCalcDetailVO;
import com.ejianc.business.cost.vo.PreBidCostCalcVO;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sync.service.ISyncService;
import com.ejianc.business.sync.vo.SyncContractVO;
import com.ejianc.business.sync.vo.SyncProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.supplier.api.ISupplierZYApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncService")
public class SyncServiceImpl
implements ISyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private IPreBidCostCalcDetailService preBidCostCalcDetailService;
    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private ISupplierZYApi supplierZYApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private com.ejianc.business.sub.service.IContractService subContractService;
    @Autowired
    private IOtherContractService otherContractService;
    @Autowired
    private IMaterialContractService materialContractService;

    @Override
    public void syncProject(SyncProjectVO projectVO) {
        List<PreBidCostCalcDetailVO> detailList;
        CommonResponse pro;
        this.logger.info("---------------------\u540c\u6b65\u9879\u76ee\u5f00\u59cb----------------------");
        QueryWrapper preBidCostCalcWrapper = new QueryWrapper();
        preBidCostCalcWrapper.eq((Object)"source_id", (Object)projectVO.getProjectId());
        PreBidCostCalcEntity preBidCostCalc = (PreBidCostCalcEntity)((Object)this.preBidCostCalcService.getOne((Wrapper)preBidCostCalcWrapper));
        if (preBidCostCalc == null) {
            preBidCostCalc = new PreBidCostCalcEntity();
            preBidCostCalc.setId(IdWorker.getId());
        }
        ContractEntity contract = null;
        if (StringUtils.isNotBlank((String)projectVO.getProjectContractCode())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"source_id", (Object)projectVO.getProjectContractCode());
            List contractList = this.contractService.list((Wrapper)wrapper);
            if (contractList != null && contractList.size() > 0) {
                contract = (ContractEntity)((Object)contractList.get(0));
                contract.setContractName(projectVO.getProjectContractName());
                contract.setSignDate(projectVO.getSignDate());
                contract.setContractMny(projectVO.getContractMny());
            } else {
                contract = new ContractEntity();
                contract.setId(IdWorker.getId());
                contract.setBillCode(projectVO.getProjectContractCode());
                contract.setContractName(projectVO.getProjectContractName());
                contract.setSignDate(projectVO.getSignDate());
                contract.setContractMny(projectVO.getContractMny());
                contract.setContractTaxMny(projectVO.getContractMny());
                contract.setSourceId(projectVO.getProjectContractCode());
                contract.setChangeStatus(1);
                contract.setContractStatus(2);
                contract.setBillState(0);
            }
        }
        CommonResponse defAssetTypeList = this.defdocApi.getDefDocByDefCode("zydx_project_type");
        HashMap<String, DefdocDetailVO> defdocMap = new HashMap<String, DefdocDetailVO>();
        if (defAssetTypeList.isSuccess() && defAssetTypeList.getData() != null && ((List)defAssetTypeList.getData()).size() > 0) {
            for (DefdocDetailVO datum : (List)defAssetTypeList.getData()) {
                defdocMap.put(datum.getName(), datum);
            }
        }
        CommonResponse orgResponse = this.iOrgApi.findBySourceId(projectVO.getProjectOrgId());
        OrgVO orgVO = null;
        if (!orgResponse.isSuccess() || orgResponse.getData() == null) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u5148\u786e\u8ba4\u7ec4\u7ec7\u662f\u5426\u540c\u6b65");
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u5148\u786e\u8ba4\u7ec4\u7ec7\u662f\u5426\u540c\u6b65");
        }
        orgVO = (OrgVO)orgResponse.getData();
        ProjectRegisterVO project = new ProjectRegisterVO();
        project.setSourceId(projectVO.getProjectId());
        project.setOrgId(orgVO.getId());
        project.setOrgName(orgVO.getName());
        project.setCode(projectVO.getProjectCode());
        project.setName(StringUtils.isNotBlank((String)projectVO.getProjectName()) ? projectVO.getProjectName() : projectVO.getProjectCode());
        project.setProjectType(defdocMap.get(projectVO.getProjectType()) != null ? ((DefdocDetailVO)defdocMap.get(projectVO.getProjectType())).getId() : null);
        project.setProjectTypeName(projectVO.getProjectType());
        project.setProjectSource(projectVO.getProjectSource());
        project.setInternalCooperationProject(projectVO.getInternalCooperationProject());
        project.setFirstBusiness(projectVO.getFirstBusiness());
        project.setSecondBusiness(projectVO.getSecondBusiness());
        project.setProjectOverview(projectVO.getProjectOverview());
        project.setAddress(projectVO.getProjectAddress());
        project.setIncomeArea(projectVO.getProjectAddress());
        project.setContractId(contract != null ? contract.getId() : null);
        project.setSignDate(projectVO.getSignDate());
        project.setContractMny(projectVO.getContractMny());
        project.setStatus(projectVO.getState() != null ? projectVO.getState().toString() : "1");
        project.setBillState(Integer.valueOf(0));
        CommonResponse taxTypeList = this.defdocApi.getDefDocByDefCode("tax_payer_type");
        HashMap<String, DefdocDetailVO> taxTypecMap = new HashMap<String, DefdocDetailVO>();
        if (taxTypeList.isSuccess() && taxTypeList.getData() != null && ((List)taxTypeList.getData()).size() > 0) {
            for (DefdocDetailVO datum : (List)taxTypeList.getData()) {
                taxTypecMap.put(datum.getName(), datum);
            }
        }
        CustomerVO customerVO = new CustomerVO();
        customerVO.setSourceId(projectVO.getCustomerId());
        customerVO.setCode(projectVO.getCustomerCode());
        customerVO.setName(projectVO.getCustomerName());
        customerVO.setCategoryId(Long.valueOf(1L));
        customerVO.setSocialCreditCode(projectVO.getSocialCreditCode());
        customerVO.setTaxPayerTypeName(projectVO.getTaxType());
        customerVO.setTaxPayerType(taxTypecMap.get(projectVO.getTaxType()) != null ? ((DefdocDetailVO)taxTypecMap.get(projectVO.getTaxType())).getId() : null);
        customerVO.setAddress(projectVO.getCustomerAddress());
        customerVO.setBankAccount(projectVO.getBankAccount());
        customerVO.setBankCode(projectVO.getBankCode());
        customerVO.setBankName(projectVO.getBankName());
        customerVO.setLegal(projectVO.getLinker());
        customerVO.setTelephone(projectVO.getCellphone());
        CommonResponse customerResponse = this.customerApi.syncCustomer(customerVO);
        if (customerResponse.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5ba2\u6237\u6570\u636e\u5b8c\u6210");
            customerVO = (CustomerVO)customerResponse.getData();
        } else {
            this.logger.info("\u540c\u6b65\u5ba2\u6237\u6570\u636e\u5931\u8d25\uff1a{}", (Object)customerResponse.getMsg());
        }
        project.setPubUnit(customerVO.getId());
        project.setPubUnitName(projectVO.getCustomerName());
        project.setBidCostId(preBidCostCalc.getId());
        if (contract != null) {
            contract.setContractorUnit(orgVO.getId());
            contract.setContractorUnitName(orgVO.getName());
            contract.setCustomerId(customerVO.getId());
            contract.setCustomerName(projectVO.getCustomerName());
        }
        if ((pro = this.projectApi.syncProject(project)).isSuccess()) {
            this.logger.info("\u540c\u6b65\u9879\u76ee\u6570\u636e\u5b8c\u6210");
            if (contract != null) {
                contract.setProjectId(((ProjectRegisterVO)pro.getData()).getId());
                contract.setProjectName(((ProjectRegisterVO)pro.getData()).getName());
                contract.setOrgId(((ProjectRegisterVO)pro.getData()).getProjectDepartmentId());
            }
        } else {
            this.logger.info("\u540c\u6b65\u9879\u76ee\u6570\u636e\u5931\u8d25\uff0c{}", (Object)pro.getMsg());
            throw new BusinessException(pro.getMsg());
        }
        preBidCostCalc.setProjectId(((ProjectRegisterVO)pro.getData()).getId());
        preBidCostCalc.setProjectDepartmentId(((ProjectRegisterVO)pro.getData()).getProjectDepartmentId());
        preBidCostCalc.setOrgId(((ProjectRegisterVO)pro.getData()).getOrgId());
        preBidCostCalc.setEstablishmentOrgId(((ProjectRegisterVO)pro.getData()).getOrgId());
        preBidCostCalc.setEstablishmentOrgName(orgVO.getName());
        if (contract != null) {
            this.contractService.saveOrUpdate((Object)contract, false);
            this.logger.info("\u540c\u6b65\u5408\u540c\u6570\u636e\u5b8c\u6210");
        }
        if (preBidCostCalc.getSourceId() == null) {
            preBidCostCalc.setProjectName(project.getName());
            preBidCostCalc.setPubUnitName(projectVO.getCustomerName());
            preBidCostCalc.setSourceId(projectVO.getProjectId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)"PreBidCostCalc", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)preBidCostCalc), PreBidCostCalcVO.class)));
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                preBidCostCalc.setBillCode((String)billCode.getData());
            }
            detailList = projectVO.getPreBidCostCalcDetailList();
            for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                preBidCostCalcDetailVO.setRowState("add");
            }
            preBidCostCalc.setPreBidCostCalcDetailList(BeanMapper.mapList(detailList, PreBidCostCalcDetailEntity.class));
        } else {
            QueryWrapper deWrapper = new QueryWrapper();
            deWrapper.eq((Object)"pid", (Object)preBidCostCalc.getId());
            List deList = this.preBidCostCalcDetailService.list((Wrapper)deWrapper);
            detailList = projectVO.getPreBidCostCalcDetailList();
            HashMap<String, PreBidCostCalcDetailVO> detailMap = new HashMap<String, PreBidCostCalcDetailVO>();
            for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                detailMap.put(preBidCostCalcDetailVO.getCostCode(), preBidCostCalcDetailVO);
            }
            if (deList != null && deList.size() > 0) {
                ArrayList<PreBidCostCalcDetailEntity> arrayList = new ArrayList<PreBidCostCalcDetailEntity>();
                ArrayList<String> codeList = new ArrayList<String>();
                for (PreBidCostCalcDetailEntity en : deList) {
                    if (StringUtils.isBlank((String)en.getCostCode())) {
                        en.setRowState("del");
                        arrayList.add(en);
                        continue;
                    }
                    if (detailMap.get(en.getCostCode()) != null) {
                        PreBidCostCalcDetailVO d = (PreBidCostCalcDetailVO)((Object)detailMap.get(en.getCostCode()));
                        en.setCostCode(d.getCostCode());
                        en.setMemo(d.getMemo());
                        en.setMny(d.getMny());
                        en.setCostStructure(d.getRevenueShare() != null ? d.getRevenueShare().toString() : null);
                        en.setCostType(d.getCostType());
                        en.setRevenueShare(d.getRevenueShare());
                        en.setRowState("edit");
                        codeList.add(d.getCostCode());
                        arrayList.add(en);
                        continue;
                    }
                    en.setRowState("del");
                    arrayList.add(en);
                }
                for (Object preBidCostCalcDetailVO : detailList) {
                    if (codeList.contains(preBidCostCalcDetailVO.getCostCode())) continue;
                    preBidCostCalcDetailVO.setRowState("add");
                    arrayList.add((PreBidCostCalcDetailEntity)((Object)BeanMapper.map((Object)preBidCostCalcDetailVO, PreBidCostCalcDetailEntity.class)));
                }
                preBidCostCalc.setPreBidCostCalcDetailList(arrayList);
            } else {
                for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                    preBidCostCalcDetailVO.setRowState("add");
                }
                preBidCostCalc.setPreBidCostCalcDetailList(BeanMapper.mapList(detailList, PreBidCostCalcDetailEntity.class));
            }
        }
        List<PreBidCostCalcDetailEntity> detailList2 = preBidCostCalc.getPreBidCostCalcDetailList();
        BigDecimal costNotaxTotal = new BigDecimal(0);
        BigDecimal costTaxTotal = new BigDecimal(0);
        BigDecimal dynamicCostTotal = new BigDecimal(0);
        BigDecimal bigDecimal = new BigDecimal(0);
        ArrayList<Long> delIds = new ArrayList<Long>();
        ArrayList<PreBidCostCalcDetailEntity> addList = new ArrayList<PreBidCostCalcDetailEntity>();
        for (PreBidCostCalcDetailEntity en : detailList2) {
            if (en.getPid() == null) {
                en.setPid(preBidCostCalc.getId());
            }
            if ("del".equals(en.getRowState())) {
                delIds.add(en.getId());
                continue;
            }
            addList.add(en);
            if ("\u76f4\u63a5\u4eba\u5de5\u8d39".equals(en.getCostType())) {
                preBidCostCalc.setLaborCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                continue;
            }
            if ("\u76f4\u63a5\u6750\u6599\u8d39".equals(en.getCostType())) {
                preBidCostCalc.setMaterialCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                continue;
            }
            if ("\u673a\u68b0\u4f7f\u7528\u8d39".equals(en.getCostType())) {
                preBidCostCalc.setEquipmentCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                continue;
            }
            if ("\u5176\u4ed6\u76f4\u63a5\u8d39".equals(en.getCostType())) {
                preBidCostCalc.setDirectCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                continue;
            }
            if ("\u5916\u534f\u6210\u672c".equals(en.getCostType()) || "\u534f\u4f5c\u8d39\u7528".equals(en.getCostType())) {
                en.setCostType("\u5916\u534f\u6210\u672c");
                preBidCostCalc.setCoalitionCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                continue;
            }
            if ("\u5176\u4ed6\u8d39\u7528\u652f\u51fa".equals(en.getCostType())) {
                preBidCostCalc.setOtherCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                continue;
            }
            if ("\u589e\u503c\u7a0e\u53ca\u9644\u52a0".equals(en.getCostType()) || "\u7a0e\u91d1\u53ca\u9644\u52a0".equals(en.getCostType())) {
                en.setCostType("\u589e\u503c\u7a0e\u53ca\u9644\u52a0");
                preBidCostCalc.setTaxCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                continue;
            }
            if ("\u4e0d\u542b\u7a0e\u6536\u5165".equals(en.getCostType())) {
                preBidCostCalc.setIncomeNotax(en.getMny());
                continue;
            }
            if (!"\u57ab\u8d44\u8d44\u91d1\u6210\u672c".equals(en.getCostType())) continue;
            preBidCostCalc.setCapitalCost(en.getMny());
            if (en.getMny() == null) continue;
            dynamicCostTotal = dynamicCostTotal.add(en.getMny());
        }
        if (preBidCostCalc.getIncomeNotax() == null) {
            preBidCostCalc.setIncomeNotax(new BigDecimal(0));
            preBidCostCalc.setProjectProfitRate(new BigDecimal(0));
        } else if (preBidCostCalc.getIncomeNotax().compareTo(new BigDecimal(0)) != 0) {
            MathContext mc = new MathContext(4, RoundingMode.HALF_UP);
            BigDecimal bigDecimal2 = preBidCostCalc.getIncomeNotax().subtract(dynamicCostTotal).subtract(preBidCostCalc.getTaxCost()).divide(preBidCostCalc.getIncomeNotax(), mc).multiply(new BigDecimal(100));
            preBidCostCalc.setProjectProfitRate(bigDecimal2);
        } else {
            preBidCostCalc.setProjectProfitRate(new BigDecimal(0));
        }
        if (addList != null && addList.size() > 0) {
            this.preBidCostCalcDetailService.saveOrUpdateBatch(addList, addList.size(), false);
        }
        if (delIds != null && delIds.size() > 0) {
            this.preBidCostCalcDetailService.removeByIds(delIds);
        }
        preBidCostCalc.setPreBidCostCalcDetailList(null);
        preBidCostCalc.setBillState(1);
        this.preBidCostCalcService.saveOrUpdate((Object)preBidCostCalc);
        this.logger.info("\u540c\u6b65\u6807\u7b7e\u6d4b\u7b97\u6570\u636e\u5b8c\u6210");
        this.logger.info("---------------------\u540c\u6b65\u9879\u76ee\u7ed3\u675f----------------------");
    }

    @Override
    public void syncContract(SyncContractVO contractVO) {
        this.logger.info("---------------------\u540c\u6b65\u5408\u540c\u5f00\u59cb----------------------");
        if (StringUtils.isBlank((String)contractVO.getContractCode())) {
            throw new BusinessException("\u7f3a\u5c11\u5408\u540c\u7f16\u7801\uff0c\u8bf7\u4f20\u53c2");
        }
        if (StringUtils.isBlank((String)contractVO.getContractName())) {
            throw new BusinessException("\u7f3a\u5c11\u5408\u540c\u540d\u79f0\uff0c\u8bf7\u4f20\u53c2");
        }
        if (StringUtils.isBlank((String)contractVO.getProjectId())) {
            throw new BusinessException("\u7f3a\u5c11\u9879\u76eeid\uff0c\u8bf7\u4f20\u53c2");
        }
        CommonResponse proResponse = this.projectApi.queryProjectBySourceId(contractVO.getProjectId());
        ProjectRegisterVO pro = null;
        if (proResponse.isSuccess()) {
            if (proResponse.getData() == null) {
                throw new BusinessException("\u7cfb\u7edf\u4e2d\u672a\u83b7\u53d6\u5230\u9879\u76ee\uff1a\u3010" + contractVO.getProjectName() + "\u3011\u6570\u636e\uff0c\u8bf7\u5148\u540c\u6b65\u9879\u76ee\u6570\u636e");
            }
        } else {
            throw new BusinessException(proResponse.getMsg());
        }
        pro = (ProjectRegisterVO)proResponse.getData();
        CommonResponse orgResponse = this.iOrgApi.findBySourceId(contractVO.getApplyOrgId());
        OrgVO orgVO = null;
        if (!orgResponse.isSuccess() || orgResponse.getData() == null) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u7533\u8bf7\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u5148\u786e\u8ba4\u7533\u8bf7\u5355\u4f4d\u662f\u5426\u540c\u6b65");
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u7533\u8bf7\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u5148\u786e\u8ba4\u7533\u8bf7\u5355\u4f4d\u662f\u5426\u540c\u6b65");
        }
        orgVO = (OrgVO)orgResponse.getData();
        CustomerVO customerVO = null;
        if (StringUtils.isNotBlank((String)contractVO.getApplyOrgId())) {
            customerVO = new CustomerVO();
            customerVO.setSourceId(contractVO.getApplyOrgId());
            customerVO.setCode(orgVO.getCode());
            customerVO.setName(orgVO.getName());
            customerVO.setCategoryId(Long.valueOf(1920403022555385858L));
            customerVO.setSocialCreditCode(orgVO.getCode());
            CommonResponse customerResponse = this.customerApi.syncCustomer(customerVO);
            if (customerResponse.isSuccess()) {
                this.logger.info("\u540c\u6b65\u5ba2\u6237\u6570\u636e\u5b8c\u6210");
                customerVO = (CustomerVO)customerResponse.getData();
            } else {
                this.logger.info("\u540c\u6b65\u5ba2\u6237\u6570\u636e\u5931\u8d25\uff1a{}", (Object)customerResponse.getMsg());
            }
        }
        SupplierVO supplierVO = null;
        if (StringUtils.isNotBlank((String)contractVO.getSocialCreditCode())) {
            supplierVO = new SupplierVO();
            supplierVO.setCode(contractVO.getSupplierCode());
            supplierVO.setName(contractVO.getSupplierName());
            supplierVO.setSocialCreditCode(contractVO.getSocialCreditCode());
            CommonResponse re = this.supplierZYApi.syncSuppler(supplierVO);
            if (re.isSuccess()) {
                this.logger.info("\u540c\u6b65\u4f9b\u5e94\u5546\u6570\u636e\u5b8c\u6210");
                supplierVO = (SupplierVO)re.getData();
            } else {
                this.logger.info("\u540c\u6b65\u4f9b\u5e94\u5546\u6570\u636e\u5931\u8d25\uff1a{}", (Object)re.getMsg());
            }
        }
        if ("\u7269\u8d44\u5408\u540c".equals(contractVO.getType())) {
            MaterialContractEntity materialContract = null;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"code", (Object)contractVO.getContractCode());
            List contractList = this.materialContractService.list((Wrapper)wrapper);
            if (contractList != null && contractList.size() > 0) {
                materialContract = (MaterialContractEntity)((Object)contractList.get(0));
                materialContract.setName(contractVO.getContractName());
                materialContract.setSignDate(contractVO.getSignDate());
                materialContract.setAmountWithTax(contractVO.getContractMny());
                materialContract.setAmountWithoutTax(contractVO.getContractMny());
                if (customerVO != null) {
                    materialContract.setContractorEnterpriseId(customerVO.getId());
                    materialContract.setContractorEnterpriseName(customerVO.getName());
                }
                if (supplierVO != null) {
                    materialContract.setSupplierId(supplierVO.getId());
                    materialContract.setSupplierName(supplierVO.getName());
                }
            } else {
                materialContract = new MaterialContractEntity();
                materialContract.setId(IdWorker.getId());
                materialContract.setCode(contractVO.getContractCode());
                materialContract.setName(contractVO.getContractName());
                materialContract.setSignDate(contractVO.getSignDate());
                materialContract.setAmountWithTax(contractVO.getContractMny());
                materialContract.setAmountWithoutTax(contractVO.getContractMny());
                if (customerVO != null) {
                    materialContract.setContractorEnterpriseId(customerVO.getId());
                    materialContract.setContractorEnterpriseName(customerVO.getName());
                }
                if (supplierVO != null) {
                    materialContract.setSupplierId(supplierVO.getId());
                    materialContract.setSupplierName(supplierVO.getName());
                }
                materialContract.setProjectId(pro.getId());
                materialContract.setProjectName(pro.getName());
                materialContract.setOrgId(pro.getProjectDepartmentId());
                materialContract.setChangeState(1);
                materialContract.setState("1");
                materialContract.setBillState(0);
            }
            this.materialContractService.saveOrUpdate((Object)materialContract, false);
        } else if ("\u52b3\u52a1\u5408\u540c".equals(contractVO.getType())) {
            SubContractEntity subContract = null;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"bill_code", (Object)contractVO.getContractCode());
            List contractList = this.subContractService.list((Wrapper)wrapper);
            if (contractList != null && contractList.size() > 0) {
                subContract = (SubContractEntity)((Object)contractList.get(0));
                subContract.setContractName(contractVO.getContractName());
                subContract.setSignDate(contractVO.getSignDate());
                subContract.setContractMny(contractVO.getContractMny());
                subContract.setContractTaxMny(contractVO.getContractMny());
                if (customerVO != null) {
                    subContract.setCustomerId(customerVO.getId());
                    subContract.setCustomerName(customerVO.getName());
                }
                if (supplierVO != null) {
                    subContract.setSupplierId(supplierVO.getId());
                    subContract.setSupplierName(supplierVO.getName());
                }
            } else {
                subContract = new SubContractEntity();
                subContract.setId(IdWorker.getId());
                subContract.setBillCode(contractVO.getContractCode());
                subContract.setContractName(contractVO.getContractName());
                subContract.setSignDate(contractVO.getSignDate());
                subContract.setContractMny(contractVO.getContractMny());
                subContract.setContractTaxMny(contractVO.getContractMny());
                if (customerVO != null) {
                    subContract.setCustomerId(customerVO.getId());
                    subContract.setCustomerName(customerVO.getName());
                }
                if (supplierVO != null) {
                    subContract.setSupplierId(supplierVO.getId());
                    subContract.setSupplierName(supplierVO.getName());
                }
                subContract.setProjectId(pro.getId());
                subContract.setProjectName(pro.getName());
                subContract.setOrgId(pro.getProjectDepartmentId());
                subContract.setChangeStatus(1);
                subContract.setContractStatus("2");
                subContract.setBillState(0);
            }
            this.subContractService.saveOrUpdate((Object)subContract, false);
        } else if ("\u5176\u4ed6\u652f\u51fa\u5408\u540c".equals(contractVO.getType())) {
            OtherContractEntity otherContract = null;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"bill_code", (Object)contractVO.getContractCode());
            List contractList = this.otherContractService.list((Wrapper)wrapper);
            if (contractList != null && contractList.size() > 0) {
                otherContract = (OtherContractEntity)((Object)contractList.get(0));
                otherContract.setContractName(contractVO.getContractName());
                otherContract.setSignDate(contractVO.getSignDate());
                otherContract.setContractMny(contractVO.getContractMny());
                otherContract.setContractTaxMny(contractVO.getContractMny());
                if (customerVO != null) {
                    otherContract.setCustomerId(customerVO.getId());
                    otherContract.setCustomerName(customerVO.getName());
                }
                if (supplierVO != null) {
                    otherContract.setSupplierId(supplierVO.getId());
                    otherContract.setSupplierName(supplierVO.getName());
                }
            } else {
                otherContract = new OtherContractEntity();
                otherContract.setId(IdWorker.getId());
                otherContract.setBillCode(contractVO.getContractCode());
                otherContract.setContractName(contractVO.getContractName());
                otherContract.setSignDate(contractVO.getSignDate());
                otherContract.setContractMny(contractVO.getContractMny());
                otherContract.setContractTaxMny(contractVO.getContractMny());
                if (customerVO != null) {
                    otherContract.setCustomerId(customerVO.getId());
                    otherContract.setCustomerName(customerVO.getName());
                }
                if (supplierVO != null) {
                    otherContract.setSupplierId(supplierVO.getId());
                    otherContract.setSupplierName(supplierVO.getName());
                }
                otherContract.setProjectId(pro.getId());
                otherContract.setProjectName(pro.getName());
                otherContract.setOrgId(pro.getProjectDepartmentId());
                otherContract.setChangeStatus(1);
                otherContract.setContractStatus("2");
                otherContract.setBillState(0);
            }
            this.otherContractService.saveOrUpdate((Object)otherContract, false);
        }
        this.logger.info("---------------------\u540c\u6b65\u5408\u540c\u7ed3\u675f----------------------");
    }
}

