package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.asset.vo.AssetRecordVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 固定资产
 * 
 * @author generator
 * 
 */
public class AssetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long materialId; // 资产id（来源合同明细id）
    private String assetName; // 资产名称（来源合同明细产品名称）
    private Long contractId; // 合同id
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String spec; // 规格型号
    private String measureUnit; // 计量单位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date financeEntryDate; // 财务入账日期
    private Long propertyOrgId; // 产权单位id
    private String propertyOrgName; // 产权单位名称
    private Long manageOrgId; // 管理单位id
    private String manageOrgName; // 管理单位名称
    private Integer dependOnProject; // 是否属于项目: 默认为true
    private Long projectId; // 所属项目Id
    private String projectName; // 所属项目名称
    private String projectCode; // 所属项目编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private String useDept; // 使用部门
    private String depositPlace; // 存放地点
    private String usePerson; // 使用人
    private Integer equipmentState; // 设备状态：1-在用 2-处置 3-报废
    private Long assetTypeId; // 资产类别id
    private String assetTypeName; // 资产类别名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 验收日期
    private Long supplierId; // 供应商Id
    private String supplierName; // 供应商名称
    private Integer assetSourceType; // 资产来源：1-手动新增 2-导入
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private String memo; // 备注
    private String origin; // 产地
    private String maker; // 制造商
    private String tecCode; // 技术编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outFactoryDate; // 出厂日期
    private Long depreciationId; // 折旧方法id
    private String depreciationName; // 折旧方法名称
    private BigDecimal initCoinMny; // 原币金额
    private BigDecimal assetInitMny; // 资产原值
    private String expectUseTerm; // 预计使用期间数
    private String depreciationTerm; // 已折旧期间数
    private BigDecimal totalDepreciationMny; // 累计折旧金额
    private BigDecimal expectSalvageMny; // 预计净残值
    private BigDecimal netMny; // 净值
    private BigDecimal disposeMny; // 处置金额

    private String billStateName; //单据编码名称
    private String equipmentStateName; //设备状态名称
    private Integer outOccupyFlag; // 是否被调出占用 0-否 1-是

    private String errorMessage; //导入错误信息
    private List<AssetRecordVO> detailList = new ArrayList<>(); // 固定资产流转记录

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Integer getOutOccupyFlag() {
        return outOccupyFlag;
    }

    public void setOutOccupyFlag(Integer outOccupyFlag) {
        this.outOccupyFlag = outOccupyFlag;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="materialContractDetail")
    public Long getMaterialId() {
        return materialId;
    }

    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getAssetName() {
        return assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getMeasureUnit() {
        return measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }
    public Date getFinanceEntryDate() {
        return financeEntryDate;
    }

    public void setFinanceEntryDate(Date financeEntryDate) {
        this.financeEntryDate = financeEntryDate;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getPropertyOrgId() {
        return propertyOrgId;
    }

    @ReferDeserialTransfer
    public void setPropertyOrgId(Long propertyOrgId) {
        this.propertyOrgId = propertyOrgId;
    }
    public String getPropertyOrgName() {
        return propertyOrgName;
    }

    public void setPropertyOrgName(String propertyOrgName) {
        this.propertyOrgName = propertyOrgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getManageOrgId() {
        return manageOrgId;
    }

    @ReferDeserialTransfer
    public void setManageOrgId(Long manageOrgId) {
        this.manageOrgId = manageOrgId;
    }
    public String getManageOrgName() {
        return manageOrgName;
    }

    public void setManageOrgName(String manageOrgName) {
        this.manageOrgName = manageOrgName;
    }
    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getUseDept() {
        return useDept;
    }

    public void setUseDept(String useDept) {
        this.useDept = useDept;
    }
    public String getDepositPlace() {
        return depositPlace;
    }

    public void setDepositPlace(String depositPlace) {
        this.depositPlace = depositPlace;
    }
    public String getUsePerson() {
        return usePerson;
    }

    public void setUsePerson(String usePerson) {
        this.usePerson = usePerson;
    }
    public Integer getEquipmentState() {
        return equipmentState;
    }

    public void setEquipmentState(Integer equipmentState) {
        this.equipmentState = equipmentState;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getAssetTypeId() {
        return assetTypeId;
    }
    @ReferDeserialTransfer
    public void setAssetTypeId(Long assetTypeId) {
        this.assetTypeId = assetTypeId;
    }
    public String getAssetTypeName() {
        return assetTypeName;
    }

    public void setAssetTypeName(String assetTypeName) {
        this.assetTypeName = assetTypeName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Integer getAssetSourceType() {
        return assetSourceType;
    }

    public void setAssetSourceType(Integer assetSourceType) {
        this.assetSourceType = assetSourceType;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
    public String getMaker() {
        return maker;
    }

    public void setMaker(String maker) {
        this.maker = maker;
    }
    public String getTecCode() {
        return tecCode;
    }

    public void setTecCode(String tecCode) {
        this.tecCode = tecCode;
    }
    public Date getOutFactoryDate() {
        return outFactoryDate;
    }

    public void setOutFactoryDate(Date outFactoryDate) {
        this.outFactoryDate = outFactoryDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getDepreciationId() {
        return depreciationId;
    }

    @ReferDeserialTransfer
    public void setDepreciationId(Long depreciationId) {
        this.depreciationId = depreciationId;
    }
    public String getDepreciationName() {
        return depreciationName;
    }

    public void setDepreciationName(String depreciationName) {
        this.depreciationName = depreciationName;
    }
    public BigDecimal getInitCoinMny() {
        return initCoinMny;
    }

    public void setInitCoinMny(BigDecimal initCoinMny) {
        this.initCoinMny = initCoinMny;
    }
    public BigDecimal getAssetInitMny() {
        return assetInitMny;
    }

    public void setAssetInitMny(BigDecimal assetInitMny) {
        this.assetInitMny = assetInitMny;
    }
    public String getExpectUseTerm() {
        return expectUseTerm;
    }

    public void setExpectUseTerm(String expectUseTerm) {
        this.expectUseTerm = expectUseTerm;
    }
    public String getDepreciationTerm() {
        return depreciationTerm;
    }

    public void setDepreciationTerm(String depreciationTerm) {
        this.depreciationTerm = depreciationTerm;
    }
    public BigDecimal getTotalDepreciationMny() {
        return totalDepreciationMny;
    }

    public void setTotalDepreciationMny(BigDecimal totalDepreciationMny) {
        this.totalDepreciationMny = totalDepreciationMny;
    }
    public BigDecimal getExpectSalvageMny() {
        return expectSalvageMny;
    }

    public void setExpectSalvageMny(BigDecimal expectSalvageMny) {
        this.expectSalvageMny = expectSalvageMny;
    }
    public BigDecimal getNetMny() {
        return netMny;
    }

    public void setNetMny(BigDecimal netMny) {
        this.netMny = netMny;
    }
    public BigDecimal getDisposeMny() {
        return disposeMny;
    }

    public void setDisposeMny(BigDecimal disposeMny) {
        this.disposeMny = disposeMny;
    }

    public List<AssetRecordVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AssetRecordVO> detailList) {
        this.detailList = detailList;
    }

    public String getEquipmentStateName() {
        return equipmentStateName;
    }

    public void setEquipmentStateName(String equipmentStateName) {
        this.equipmentStateName = equipmentStateName;
    }
}
