package com.ejianc.business.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 物资总计划VO
 *
 * @author CJ
 * @Description: 物资总计划VO
 * @date 2021/3/2 17:17
 */
public class MaterialMasterPlanVO extends BaseVO {

    private static final long serialVersionUID = -3534047606256076009L;

    /**
     * 总计划变更状态：未变更
     */
    public static final Integer PLAN_CHANGE_STATE_UNCHANGED = 0;

    /**
     * 总计划变更状态：变更中
     */
    public static final Integer PLAN_CHANGE_STATE_CHANGING = 1;

    /**
     * 总计划变更状态：已变更
     */
    public static final Integer PLAN_CHANGE_STATE_CHANGED = 2;

    /**
     * 项目Id
     */
    private Long projectId;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 计划编码
     */
    private String planCode;

    /**
     * 总计划金额
     */
    private BigDecimal totalPlanAmt;

    /**
     * 备注
     */
    private String remark;

    /**
     * 变更状态
     */
    private Integer changeState;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 变更中的变更计划Id
     */
    private Long curChangingPlanId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 修改人名称
     */
    private String modifyUserName;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;

    /**
     * 变更版本
     */
    private Integer changeVersion;

    /**
     * 变更历史列表
     */
    private List<PlanChangeHisVO> planChangeHisList;

    public List<PlanChangeHisVO> getPlanChangeHisList() {
        return planChangeHisList;
    }

    public void setPlanChangeHisList(List<PlanChangeHisVO> planChangeHisList) {
        this.planChangeHisList = planChangeHisList;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getCurChangingPlanId() {
        return curChangingPlanId;
    }

    public void setCurChangingPlanId(Long curChangingPlanId) {
        this.curChangingPlanId = curChangingPlanId;
    }

    private List<MaterialMasterPlanSubVO> materialSubList = new ArrayList<>();

    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public BigDecimal getTotalPlanAmt() {
        return totalPlanAmt;
    }

    public void setTotalPlanAmt(BigDecimal totalPlanAmt) {
        this.totalPlanAmt = totalPlanAmt;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<MaterialMasterPlanSubVO> getMaterialSubList() {
        return materialSubList;
    }

    public void setMaterialSubList(List<MaterialMasterPlanSubVO> materialSubList) {
        this.materialSubList = materialSubList;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
