package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.service.IProjectTargetcostRecordService;
import com.ejianc.business.cost.service.IProjectTargetcostService;
import com.ejianc.business.cost.utils.ProjectUtils;
import com.ejianc.business.cost.vo.ProjectTargetcostDetailVO;
import com.ejianc.business.cost.vo.ProjectTargetcostRecordVO;
import com.ejianc.business.cost.vo.ProjectTargetcostVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目目标成本
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectTargetcost")
public class ProjectTargetcostController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zydxProjectTargetcost";//此处需要根据实际修改

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private IProjectTargetcostService service;
    @Autowired
    private IProjectTargetcostRecordService recordService;
    @Autowired
    private IEngdepartRespcostService engdepartRespcostService;
    @Autowired
    private ProjectUtils projectUtils;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectTargetcostVO> saveOrUpdate(@RequestBody ProjectTargetcostVO saveOrUpdateVO) {
    	ProjectTargetcostEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectTargetcostEntity.class);
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.eq("project_id", entity.getProjectId());
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setChangeState("1");//未变更
        }else{
            checkWrapper.ne("id", entity.getId());
        }
        List check = service.list(checkWrapper);
        if(check.size()>0){
            throw new BusinessException("项目【"+entity.getProjectName()+"】下已存在项目目标成本");
        }
        //子项目累计分配额不得超合同额
        BigDecimal contractMny = saveOrUpdateVO.getContractTaxMny()!=null? saveOrUpdateVO.getContractTaxMny() : new BigDecimal(0);
        if("子项目".equals(saveOrUpdateVO.getProjectProperty())){
            List<Long> projectIds = projectUtils.getProjectList(saveOrUpdateVO.getProjectId());
            if(projectIds!=null && projectIds.size()>0){
                QueryWrapper<ProjectTargetcostEntity> wrapper = new QueryWrapper<>();
                wrapper.in("project_id", projectIds);
                List<ProjectTargetcostEntity> lsit = service.list(wrapper);
                if(lsit!=null && lsit.size()>0){
                    BigDecimal amont = saveOrUpdateVO.getAllocateContractMny()!=null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
                    for(ProjectTargetcostEntity vo : lsit){
                        BigDecimal allocateContractMny = vo.getAllocateContractMny()!=null ? vo.getAllocateContractMny() : new BigDecimal(0);
                        amont = amont.add(allocateContractMny);
                    }
                    if(amont.compareTo(contractMny)>0){
                        throw new BusinessException("子项目累计分配额【"+amont.setScale(2,BigDecimal.ROUND_HALF_UP)+"】不得超合同额【"+contractMny.setScale(2,BigDecimal.ROUND_HALF_UP)+"】");
                    }
                }
            }else{
                BigDecimal allocateContractMny = saveOrUpdateVO.getAllocateContractMny()!=null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
                if(allocateContractMny.compareTo(contractMny)>0){
                    throw new BusinessException("子项目累计分配额【"+allocateContractMny.setScale(2,BigDecimal.ROUND_HALF_UP)+"】不得超合同额【"+contractMny.setScale(2,BigDecimal.ROUND_HALF_UP)+"】");
                }
            }
        }else{
            BigDecimal allocateContractMny = saveOrUpdateVO.getAllocateContractMny()!=null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
            if(allocateContractMny.compareTo(contractMny)>0){
                throw new BusinessException("子项目累计分配额【"+allocateContractMny.setScale(2,BigDecimal.ROUND_HALF_UP)+"】不得超合同额【"+contractMny.setScale(2,BigDecimal.ROUND_HALF_UP)+"】");
            }
        }
        engdepartRespcostService.checkAmount(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getProjectProperty(), saveOrUpdateVO.getTargetcostTotal());

        if(entity.getProjectTargetcostDetailList()!=null && entity.getProjectTargetcostDetailList().size()>0){
            Map<String, Long> map = new HashMap<>();
            entity.getProjectTargetcostDetailList().forEach(item -> {
                if("add".equals(item.getRowState())){
                    item.setId(IdWorker.getId());
                    item.setTargetcostId(entity.getId());
                }
                if(!"del".equals(item.getRowState())){
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getProjectTargetcostDetailList().forEach(item -> {
                if("add".equals(item.getRowState()) && item.getCode().indexOf(".")!=-1){
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid(map.get(code));
                }
            });
        }
    	service.saveOrUpdate(entity, false);
    	ProjectTargetcostVO vo = BeanMapper.map(entity, ProjectTargetcostVO.class);

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectTargetcostDetailList())) {
            sortIntMethod(vo.getProjectTargetcostDetailList());
            List<ProjectTargetcostDetailVO> detailVOS = createTreeData(vo.getProjectTargetcostDetailList());
            vo.setProjectTargetcostDetailList(detailVOS);
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectTargetcostVO> queryDetail(Long id) {
    	ProjectTargetcostEntity entity = service.selectById(id);
    	ProjectTargetcostVO vo = BeanMapper.map(entity, ProjectTargetcostVO.class);

        //当前单据变更过则显示变更记录
        QueryWrapper<ProjectTargetcostRecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("taskcost_id", vo.getId());
        List<ProjectTargetcostRecordEntity> records = recordService.list(queryWrapper);
        if(records!=null&&records.size()>0){
            vo.setRecordList(BeanMapper.mapList(records, ProjectTargetcostRecordVO.class));
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectTargetcostDetailList())) {
            sortIntMethod(vo.getProjectTargetcostDetailList());
            List<ProjectTargetcostDetailVO> detailVOS = createTreeData(vo.getProjectTargetcostDetailList());
            vo.setProjectTargetcostDetailList(detailVOS);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    private static void sortIntMethod(List<ProjectTargetcostDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                ProjectTargetcostDetailVO o1Detail = objectMapper.convertValue(o1, ProjectTargetcostDetailVO.class);
                ProjectTargetcostDetailVO o2Detail = objectMapper.convertValue(o2, ProjectTargetcostDetailVO.class);
                String[] strs1 = o1Detail.getCode().split("\\.");
                String[] strs2 = o2Detail.getCode().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }

    public static List<ProjectTargetcostDetailVO> createTreeData(List<ProjectTargetcostDetailVO> list) {
        List<ProjectTargetcostDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ProjectTargetcostDetailVO> listMap = new HashMap<>();
        for(ProjectTargetcostDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ProjectTargetcostDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            ProjectTargetcostDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ProjectTargetcostDetailVO> child = (List<ProjectTargetcostDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ProjectTargetcostDetailVO> children = new ArrayList<ProjectTargetcostDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectTargetcostVO> vos) {
        service.removeByIds(vos.stream().map(ProjectTargetcostVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectTargetcostVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            departmentIds.add(org.getId());
        });
        param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectTargetcostEntity> page = service.queryPage(param,false);
        IPage<ProjectTargetcostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectTargetcostVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            departmentIds.add(org.getId());
        });
        param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<ProjectTargetcostEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectTargetcost-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectTargetcostData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectTargetcostVO>> refProjectTargetcostData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectTargetcostEntity> page = service.queryPage(param,false);
        IPage<ProjectTargetcostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectTargetcostVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/queryEngdepartRespCostById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectTargetcostVO> queryEngdepartRespCostById(Long id) {
        EngdepartRespcostEntity entity = engdepartRespcostService.selectById(id);
        ProjectTargetcostVO vo = new ProjectTargetcostVO();
        vo.setRespcostId(id);
        vo.setProjectId(entity.getProjectId());
        vo.setProjectDepartmentId(entity.getProjectDepartmentId());
        vo.setProjectName(entity.getProjectName());
        vo.setOrgId(entity.getOrgId());
        vo.setPubUnitName(entity.getPubUnitName());
        vo.setContractUnitName(entity.getContractUnitName());
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setStartDate(entity.getStartDate());
        vo.setFinishDate(entity.getFinishDate());

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getEngdepartRespcostDetailList())) {
            List<ProjectTargetcostDetailVO> projectTargetcostDetailList = new ArrayList<>(); // 工程部责任成本明细
            Map<String, Long> map = new HashMap<>();
            for(EngdepartRespcostDetailEntity detail : entity.getEngdepartRespcostDetailList()){
                ProjectTargetcostDetailVO d = new ProjectTargetcostDetailVO();
                d.setCode(detail.getCode());
                d.setAddState(false);
                d.setCostAmount(detail.getAmount());
                d.setFeeType(detail.getFeeType());
                d.setRespcostDetailId(detail.getId());
                d.setSubjectCode(detail.getSubjectCode());
                d.setSubjectId(detail.getSubjectId());
                d.setSubjectName(detail.getSubjectName());
                d.setRowState("add");
                d.setId(IdWorker.getId());
                map.put(detail.getCode(), d.getId());
                projectTargetcostDetailList.add(d);
            }
            projectTargetcostDetailList.forEach(item -> {
                if(item.getCode().indexOf(".")!=-1){
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid(map.get(code));
                }
            });
            sortIntMethod(projectTargetcostDetailList);
            List<ProjectTargetcostDetailVO> detailVOS = createTreeData(projectTargetcostDetailList);
            vo.setProjectTargetcostDetailList(detailVOS);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/checkBillParam", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONArray> checkBillParam(@RequestBody ProjectTargetcostVO vo) {
        JSONArray list = new JSONArray();
        MathContext mc = new MathContext(4, RoundingMode.HALF_UP);

        //获取标签测算金额
        PreBidCostCalcEntity preBidCostCalcEntity = preBidCostCalcService.queryDataByProjectId(vo.getProjectId());
        if(preBidCostCalcEntity==null){
            throw new BusinessException("未获取到该项目标前测算数据，请先完成标前测算");
        }
        BigDecimal costTaxTotal = preBidCostCalcEntity.getCostTaxTotal()!=null ? preBidCostCalcEntity.getCostTaxTotal() : new BigDecimal(0);

        //项目目标成本金额（含子项目累计金额）不能超标前测算金额
        CommonResponse<BillParamVO> dataResponse = paramConfigApi.getBillParamByCode("P-m69ri60308");
        if(dataResponse.isSuccess()){
            BigDecimal roleValue = dataResponse.getData().getRoleValue();
            if("子项目".equals(vo.getProjectProperty())){
                List<Long> projectIds = projectUtils.getProjectList(vo.getProjectId());
                if(projectIds!=null && projectIds.size()>0){
                    QueryWrapper<ProjectTargetcostEntity> wrapper = new QueryWrapper<>();
                    wrapper.in("project_id", projectIds);
                    List<ProjectTargetcostEntity> lsit = service.list(wrapper);
                    if(lsit!=null && lsit.size()>0){
                        BigDecimal amont = vo.getTargetcostTotal()!=null ? vo.getTargetcostTotal() : new BigDecimal(0);
                        for(ProjectTargetcostEntity pr : lsit){
                            BigDecimal targetcostTotal = pr.getTargetcostTotal()!=null ? pr.getTargetcostTotal() : new BigDecimal(0);
                            amont = amont.add(targetcostTotal);
                        }

                        BigDecimal absoluteValue = amont.subtract(costTaxTotal);
                        BigDecimal da = new BigDecimal(0);
                        if(costTaxTotal.compareTo(new BigDecimal(0)) != 0){
                            da = absoluteValue.divide(costTaxTotal,mc).multiply(new BigDecimal(100));
                        }
                        if(da.compareTo(roleValue)>0){
                            JSONObject item = new JSONObject();
                            item.put("type", "1");
                            item.put("warnItem", "1");
                            item.put("warnName", "标前测算控项目目标成本");
                            item.put("content", "【项目目标成本】的目标成本金额："+amont.setScale(2)+"元，大于【标前测算】的项目成本："+costTaxTotal.setScale(2)+"元");
                            list.add(item);
                        }
                    }
                }else{
                    BigDecimal targetcostTotal = vo.getTargetcostTotal()!=null ? vo.getTargetcostTotal() : new BigDecimal(0);
                    BigDecimal absoluteValue = targetcostTotal.subtract(costTaxTotal);
                    BigDecimal da = new BigDecimal(0);
                    if(costTaxTotal.compareTo(new BigDecimal(0)) != 0){
                        da = absoluteValue.divide(costTaxTotal,mc).multiply(new BigDecimal(100));
                    }
                    if(da.compareTo(roleValue)>0){
                        JSONObject item = new JSONObject();
                        item.put("type", "1");
                        item.put("warnItem", "1");
                        item.put("warnName", "标前测算控项目目标成本");
                        item.put("content", "【项目目标成本】的目标成本金额："+targetcostTotal.setScale(2)+"元，大于【标前测算】的项目成本："+costTaxTotal.setScale(2)+"元");
                        list.add(item);
                    }
                }
            }else{
                BigDecimal targetcostTotal = vo.getTargetcostTotal()!=null ? vo.getTargetcostTotal() : new BigDecimal(0);
                BigDecimal absoluteValue = targetcostTotal.subtract(costTaxTotal);
                BigDecimal da = new BigDecimal(0);
                if(costTaxTotal.compareTo(new BigDecimal(0)) != 0){
                    da = absoluteValue.divide(costTaxTotal,mc).multiply(new BigDecimal(100));
                }
                if(da.compareTo(roleValue)>0){
                    JSONObject item = new JSONObject();
                    item.put("type", "1");
                    item.put("warnItem", "1");
                    item.put("warnName", "标前测算控项目目标成本");
                    item.put("content", "【项目目标成本】的目标成本金额："+targetcostTotal.setScale(2)+"元，大于【标前测算】的项目成本："+costTaxTotal.setScale(2)+"元");
                    list.add(item);
                }
            }
        }else{
            throw new BusinessException("查询参数配置失败！");
        }
        return CommonResponse.success(list);
    }

    @RequestMapping(value = "/queryDataByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryDataByProjectId(Long projectId) {
        JSONObject data = service.queryDataByProjectId(projectId);
        return CommonResponse.success(data);
    }
}
