package com.ejianc.business.other.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 其他支出合同清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_other_contract_detail")
public class OtherContractDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="code")
    private String code; // 清单编号
    @TableField(value="name")
    private String name; // 清单名称
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="num")
    private BigDecimal num; // 工程量
    @TableField(value="detail_tax_rate")
    private BigDecimal detailTaxRate; // 税率
    @TableField(value="detail_price")
    private BigDecimal detailPrice; // 单价(无税)
    @TableField(value="detail_tax_price")
    private BigDecimal detailTaxPrice; // 单价(含税)
    @TableField(value="detail_mny")
    private BigDecimal detailMny; // 合价(无税)
    @TableField(value="detail_tax_mny")
    private BigDecimal detailTaxMny; // 合价(含税)
    @TableField(value="detail_tax")
    private BigDecimal detailTax; // 税额
    @TableField(value="detail_memo")
    private String detailMemo; // 备注
    @TableField(value="change_type")
    private Integer changeType; // 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-终止，6-其他
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_bid")
    private Long changeBid; // 变更子表主键

    @TableField(value="src_supplement_flag")
    private Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    @TableField(value="src_supplement_id")
    private Long srcSupplementId; // 来源补充协议主表ID
    @TableField(value="src_supplement_detail_id")
    private Long srcSupplementDetailId; // 来源补充协议明细ID
    
    @TableField(exist = false)
    private BigDecimal sumNum;
    @TableField(value = "source_id")
    private Long sourceId;//来源预算主表id
    @TableField(value = "source_detail_id")
    private Long sourceDetailId;//来源预算子表id
    @TableField(value = "source_type")
    private Integer sourceType;// 0:手动新增  1:预算


    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public BigDecimal getSumNum() {
		return sumNum;
	}

	public void setSumNum(BigDecimal sumNum) {
		this.sumNum = sumNum;
	}

	public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }

    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }

    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 清单编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 清单编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 清单名称
     */
    public String getName() {
        return name;
    }

    /**
     * 清单名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 工程量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 工程量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    /**
     * 税率
     */
    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    /**
     * 单价(无税)
     */
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    /**
     * 单价(无税)
     */
    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    /**
     * 合价(无税)
     */
    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    /**
     * 合价(含税)
     */
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    /**
     * 税额
     */
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    /**
     * 税额
     */
    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    /**
     * 备注
     */
    public String getDetailMemo() {
        return detailMemo;
    }

    /**
     * 备注
     */
    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-终止，6-其他
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-终止，6-其他
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    
}
