package com.ejianc.business.sync.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.PreBidCostCalcDetailEntity;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.service.IPreBidCostCalcDetailService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.vo.PreBidCostCalcDetailVO;
import com.ejianc.business.cost.vo.PreBidCostCalcVO;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sync.service.ISyncService;
import com.ejianc.business.sync.vo.SyncContractVO;
import com.ejianc.business.sync.vo.SyncProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.supplier.api.ISupplierZYApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 同步数据
 * 
 * @author generator
 * 
 */
@Service("syncService")
public class SyncServiceImpl implements ISyncService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private IPreBidCostCalcDetailService preBidCostCalcDetailService;
    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private ISupplierZYApi supplierZYApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private com.ejianc.business.sub.service.IContractService subContractService;

    @Autowired
    private IOtherContractService otherContractService;

    @Autowired
    private IMaterialContractService materialContractService;

    @Override
    public void syncProject(SyncProjectVO projectVO) {
        logger.info("---------------------同步项目开始----------------------");
        QueryWrapper<PreBidCostCalcEntity> preBidCostCalcWrapper = new QueryWrapper<>();
        preBidCostCalcWrapper.eq("source_id", projectVO.getProjectId());
        PreBidCostCalcEntity preBidCostCalc = preBidCostCalcService.getOne(preBidCostCalcWrapper);
        if(preBidCostCalc == null) {
            preBidCostCalc = new PreBidCostCalcEntity();
            preBidCostCalc.setId(IdWorker.getId());
        }
        //先查询合同信息
        ContractEntity contract = null;
        if(StringUtils.isNotBlank(projectVO.getProjectContractCode())){
            QueryWrapper<ContractEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("source_id", projectVO.getProjectContractCode());
            List<ContractEntity> contractList = contractService.list(wrapper);
            if(contractList!=null && contractList.size()>0){
                contract = contractList.get(0);
                contract.setContractName(projectVO.getProjectContractName());
                contract.setSignDate(projectVO.getSignDate());
                contract.setContractMny(projectVO.getContractMny());
            }else{
                contract = new ContractEntity();
                contract.setId(IdWorker.getId());
                contract.setBillCode(projectVO.getProjectContractCode());
                contract.setContractName(projectVO.getProjectContractName());
                contract.setSignDate(projectVO.getSignDate());
                contract.setContractMny(projectVO.getContractMny());
                contract.setContractTaxMny(projectVO.getContractMny());
                contract.setSourceId(projectVO.getProjectContractCode());
                contract.setChangeStatus(1);
                contract.setContractStatus(2);
                contract.setBillState(0);
            }
        }
        CommonResponse<List<DefdocDetailVO>> defAssetTypeList = defdocApi.getDefDocByDefCode("zydx_project_type");
        Map<String, DefdocDetailVO> defdocMap = new HashMap<>();
        if(defAssetTypeList.isSuccess() && defAssetTypeList.getData()!=null && defAssetTypeList.getData().size()>0){
            for (DefdocDetailVO datum : defAssetTypeList.getData()) {
                defdocMap.put(datum.getName(), datum);
            }
        }
        CommonResponse<OrgVO> orgResponse = iOrgApi.findBySourceId(projectVO.getProjectOrgId());
        OrgVO orgVO = null;
        if(orgResponse.isSuccess() && orgResponse.getData()!=null){
            orgVO = orgResponse.getData();
        }else{
            logger.info("未获取到项目所属组织信息，请先确认组织是否同步");
            throw new BusinessException("未获取到项目所属组织信息，请先确认组织是否同步");
        }
        ProjectRegisterVO project = new ProjectRegisterVO();
        project.setSourceId(projectVO.getProjectId());
        project.setOrgId(orgVO.getId());
        project.setOrgName(orgVO.getName());
        project.setCode(projectVO.getProjectCode());
        project.setName(StringUtils.isNotBlank(projectVO.getProjectName())?projectVO.getProjectName():projectVO.getProjectCode());
        project.setProjectType(defdocMap.get(projectVO.getProjectType())!=null?defdocMap.get(projectVO.getProjectType()).getId():null);
        project.setProjectTypeName(projectVO.getProjectType());
        project.setProjectSource(projectVO.getProjectSource());
        project.setInternalCooperationProject(projectVO.getInternalCooperationProject());
        project.setFirstBusiness(projectVO.getFirstBusiness());
        project.setSecondBusiness(projectVO.getSecondBusiness());
        project.setProjectOverview(projectVO.getProjectOverview());
        project.setAddress(projectVO.getProjectAddress());
        project.setIncomeArea(projectVO.getProjectAddress());
        project.setContractId(contract!=null?contract.getId():null);
        project.setSignDate(projectVO.getSignDate());
        project.setContractMny(projectVO.getContractMny());
        project.setStatus(projectVO.getState()!=null?projectVO.getState().toString():"1");
        project.setBillState(0);
        //同步客户数据
        CommonResponse<List<DefdocDetailVO>> taxTypeList = defdocApi.getDefDocByDefCode("tax_payer_type");
        Map<String, DefdocDetailVO> taxTypecMap = new HashMap<>();
        if(taxTypeList.isSuccess() && taxTypeList.getData()!=null && taxTypeList.getData().size()>0){
            for (DefdocDetailVO datum : taxTypeList.getData()) {
                taxTypecMap.put(datum.getName(), datum);
            }
        }
        CustomerVO customerVO = new CustomerVO();
        customerVO.setSourceId(projectVO.getCustomerId());
        customerVO.setCode(projectVO.getCustomerCode());
        customerVO.setName(projectVO.getCustomerName());
        customerVO.setCategoryId(1l);
        customerVO.setSocialCreditCode(projectVO.getSocialCreditCode());
        customerVO.setTaxPayerTypeName(projectVO.getTaxType());
        customerVO.setTaxPayerType(taxTypecMap.get(projectVO.getTaxType())!=null?taxTypecMap.get(projectVO.getTaxType()).getId():null);
        customerVO.setAddress(projectVO.getCustomerAddress());
        customerVO.setBankAccount(projectVO.getBankAccount());
        customerVO.setBankCode(projectVO.getBankCode());
        customerVO.setBankName(projectVO.getBankName());
        customerVO.setLegal(projectVO.getLinker());
        customerVO.setTelephone(projectVO.getCellphone());
        CommonResponse<CustomerVO> customerResponse = customerApi.syncCustomer(customerVO);
        if(customerResponse.isSuccess()){
            logger.info("同步客户数据完成");
            customerVO = customerResponse.getData();
        }else{
            logger.info("同步客户数据失败：{}",customerResponse.getMsg());
        }
        project.setPubUnit(customerVO.getId());
        project.setPubUnitName(projectVO.getCustomerName());
        project.setBidCostId(preBidCostCalc.getId());

        if(contract!=null) {
            contract.setContractorUnit(orgVO.getId());
            contract.setContractorUnitName(orgVO.getName());
            contract.setCustomerId(customerVO.getId());
            contract.setCustomerName(projectVO.getCustomerName());
        }

        CommonResponse<ProjectRegisterVO> pro = projectApi.syncProject(project);
        if(pro.isSuccess()){
            logger.info("同步项目数据完成");
            if(contract!=null){
                contract.setProjectId(pro.getData().getId());
                contract.setProjectName(pro.getData().getName());
                contract.setOrgId(pro.getData().getProjectDepartmentId());
            }
            preBidCostCalc.setProjectId(pro.getData().getId());
            preBidCostCalc.setProjectDepartmentId(pro.getData().getProjectDepartmentId());
            preBidCostCalc.setOrgId(pro.getData().getOrgId());
            preBidCostCalc.setEstablishmentOrgId(pro.getData().getOrgId());
            preBidCostCalc.setEstablishmentOrgName(orgVO.getName());
        }else{
            logger.info("同步项目数据失败，{}",pro.getMsg());
            throw new BusinessException(pro.getMsg());
        }
        if(contract!=null){
            contractService.saveOrUpdate(contract, false);
            logger.info("同步合同数据完成");
        }

        if(preBidCostCalc.getSourceId() == null){
            preBidCostCalc.setProjectName(project.getName());
            preBidCostCalc.setPubUnitName(projectVO.getCustomerName());
            preBidCostCalc.setSourceId(projectVO.getProjectId());
            BillCodeParam billCodeParam = BillCodeParam.build("PreBidCostCalc", InvocationInfoProxy.getTenantid(), BeanMapper.map(preBidCostCalc, PreBidCostCalcVO.class));
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                preBidCostCalc.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            List<PreBidCostCalcDetailVO> detailList = projectVO.getPreBidCostCalcDetailList();
            for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                preBidCostCalcDetailVO.setRowState("add");
            }
            preBidCostCalc.setPreBidCostCalcDetailList(BeanMapper.mapList(detailList, PreBidCostCalcDetailEntity.class));
        }else{
            QueryWrapper<PreBidCostCalcDetailEntity> deWrapper = new QueryWrapper<>();
            deWrapper.eq("pid", preBidCostCalc.getId());
            List<PreBidCostCalcDetailEntity> deList = preBidCostCalcDetailService.list(deWrapper);

            List<PreBidCostCalcDetailVO> detailList = projectVO.getPreBidCostCalcDetailList();
            Map<String, PreBidCostCalcDetailVO> detailMap = new HashMap<>();
            for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                detailMap.put(preBidCostCalcDetailVO.getCostCode(), preBidCostCalcDetailVO);
            }
            if (deList != null && deList.size()>0) {
                List<PreBidCostCalcDetailEntity> preBidCostCalcDetailList = new ArrayList<>();
                List<String> codeList = new ArrayList<>();
                for (PreBidCostCalcDetailEntity en : deList) {
                    if(StringUtils.isBlank(en.getCostCode())){
                        en.setRowState("del");
                        preBidCostCalcDetailList.add(en);
                        continue;
                    }
                    if(detailMap.get(en.getCostCode())!=null){
                        PreBidCostCalcDetailVO d = detailMap.get(en.getCostCode());
                        en.setCostCode(d.getCostCode());
                        en.setMemo(d.getMemo());
                        en.setMny(d.getMny());
                        en.setCostStructure(d.getRevenueShare()!=null?d.getRevenueShare().toString():null);
                        en.setCostType(d.getCostType());
                        en.setRevenueShare(d.getRevenueShare());
                        en.setRowState("edit");
                        codeList.add(d.getCostCode());
                        preBidCostCalcDetailList.add(en);
                    }else{
                        en.setRowState("del");
                        preBidCostCalcDetailList.add(en);
                    }
                }
                for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                    if(!codeList.contains(preBidCostCalcDetailVO.getCostCode())){
                        preBidCostCalcDetailVO.setRowState("add");
                        preBidCostCalcDetailList.add(BeanMapper.map(preBidCostCalcDetailVO, PreBidCostCalcDetailEntity.class));
                    }
                }
                preBidCostCalc.setPreBidCostCalcDetailList(preBidCostCalcDetailList);
            }else{
                for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                    preBidCostCalcDetailVO.setRowState("add");
                }
                preBidCostCalc.setPreBidCostCalcDetailList(BeanMapper.mapList(detailList, PreBidCostCalcDetailEntity.class));
            }
        }
        List<PreBidCostCalcDetailEntity> detailList = preBidCostCalc.getPreBidCostCalcDetailList();

        BigDecimal costNotaxTotal = new BigDecimal(0);
        BigDecimal costTaxTotal = new BigDecimal(0);
        BigDecimal dynamicCostTotal = new BigDecimal(0);
        BigDecimal projectProfitRate = new BigDecimal(0);
        List<Long> delIds = new ArrayList<>();
        List<PreBidCostCalcDetailEntity> addList = new ArrayList<>();
        for (PreBidCostCalcDetailEntity en : detailList) {
            if(en.getPid()==null){
                en.setPid(preBidCostCalc.getId());
            }
            if("del".equals(en.getRowState())){
                delIds.add(en.getId());
                continue;
            }else{
                addList.add(en);
            }
            if("直接人工费".equals(en.getCostType())){
                preBidCostCalc.setLaborCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("直接材料费".equals(en.getCostType())){
                preBidCostCalc.setMaterialCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("机械使用费".equals(en.getCostType())){
                preBidCostCalc.setEquipmentCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("其他直接费".equals(en.getCostType())){
                preBidCostCalc.setDirectCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("外协成本".equals(en.getCostType()) || "协作费用".equals(en.getCostType())){
                en.setCostType("外协成本");
                preBidCostCalc.setCoalitionCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("其他费用支出".equals(en.getCostType())){
                preBidCostCalc.setOtherCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("增值税及附加".equals(en.getCostType()) || "税金及附加".equals(en.getCostType())){
                en.setCostType("增值税及附加");
                preBidCostCalc.setTaxCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                }
            }else if("不含税收入".equals(en.getCostType())){
                preBidCostCalc.setIncomeNotax(en.getMny());
            }else if("垫资资金成本".equals(en.getCostType())){
                preBidCostCalc.setCapitalCost(en.getMny());
                if(en.getMny()!=null){
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }
        }
        if(preBidCostCalc.getIncomeNotax()==null){
            preBidCostCalc.setIncomeNotax(new BigDecimal(0));
            preBidCostCalc.setProjectProfitRate(new BigDecimal(0));
        }else {
            if (preBidCostCalc.getIncomeNotax().compareTo(new BigDecimal(0)) != 0) {
                MathContext mc = new MathContext(4, RoundingMode.HALF_UP);
                projectProfitRate = preBidCostCalc.getIncomeNotax().subtract(dynamicCostTotal).subtract(preBidCostCalc.getTaxCost()).divide(preBidCostCalc.getIncomeNotax(), mc).multiply(new BigDecimal(100));
                preBidCostCalc.setProjectProfitRate(projectProfitRate);
            } else {
                preBidCostCalc.setProjectProfitRate(new BigDecimal(0));
            }
        }
        if(addList!=null && addList.size()>0){
            preBidCostCalcDetailService.saveOrUpdateBatch(addList, addList.size(), false);
        }
        if(delIds!=null && delIds.size()>0){
            preBidCostCalcDetailService.removeByIds(delIds);
        }
        preBidCostCalc.setPreBidCostCalcDetailList(null);
        preBidCostCalc.setBillState(1);
        preBidCostCalcService.saveOrUpdate(preBidCostCalc);
        logger.info("同步标签测算数据完成");
        logger.info("---------------------同步项目结束----------------------");
    }

    @Override
    public void syncContract(SyncContractVO contractVO) {
        logger.info("---------------------同步合同开始----------------------");
        if(StringUtils.isBlank(contractVO.getContractCode())){
            throw new BusinessException("缺少合同编码，请传参");
        }
        if(StringUtils.isBlank(contractVO.getContractName())){
            throw new BusinessException("缺少合同名称，请传参");
        }
        if(StringUtils.isBlank(contractVO.getProjectId())){
            throw new BusinessException("缺少项目id，请传参");
        }
        //获取项目
        CommonResponse<ProjectRegisterVO> proResponse = projectApi.queryProjectBySourceId(contractVO.getProjectId());
        ProjectRegisterVO pro = null;
        if(proResponse.isSuccess()){
            if(proResponse.getData()!=null){
                pro = proResponse.getData();
            }else{
                throw new BusinessException("系统中未获取到项目：【"+contractVO.getProjectName()+"】数据，请先同步项目数据");
            }
        }else{
            throw new BusinessException(proResponse.getMsg());
        }
        //获取组织
        CommonResponse<OrgVO> orgResponse = iOrgApi.findBySourceId(contractVO.getApplyOrgId());
        OrgVO orgVO = null;
        if(orgResponse.isSuccess() && orgResponse.getData()!=null){
            orgVO = orgResponse.getData();
        }else{
            logger.info("未获取到申请单位信息，请先确认申请单位是否同步");
            throw new BusinessException("未获取到申请单位信息，请先确认申请单位是否同步");
        }
        //根据组织同步客户
        CustomerVO customerVO = null;
        if(StringUtils.isNotBlank(contractVO.getApplyOrgId())) {
            customerVO = new CustomerVO();
            customerVO.setSourceId(contractVO.getApplyOrgId());
            customerVO.setCode(orgVO.getCode());
            customerVO.setName(orgVO.getName());
            customerVO.setCategoryId(1920403022555385858l);
            customerVO.setSocialCreditCode(orgVO.getCode());
            CommonResponse<CustomerVO> customerResponse = customerApi.syncCustomer(customerVO);
            if (customerResponse.isSuccess()) {
                logger.info("同步客户数据完成");
                customerVO = customerResponse.getData();
            } else {
                logger.info("同步客户数据失败：{}", customerResponse.getMsg());
            }
        }

        SupplierVO supplierVO = null;
        //同步供应商
        if(StringUtils.isNotBlank(contractVO.getSocialCreditCode())){
            supplierVO = new SupplierVO();
            supplierVO.setCode(contractVO.getSupplierCode());
            supplierVO.setName(contractVO.getSupplierName());
            supplierVO.setSocialCreditCode(contractVO.getSocialCreditCode());
            CommonResponse<SupplierVO> re = supplierZYApi.syncSuppler(supplierVO);
            if(re.isSuccess()){
                logger.info("同步供应商数据完成");
                supplierVO = re.getData();
            }else{
                logger.info("同步供应商数据失败：{}",re.getMsg());
            }
        }

        //同步合同
        if("物资合同".equals(contractVO.getType())){
            MaterialContractEntity materialContract = null;
            QueryWrapper<MaterialContractEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("code", contractVO.getContractCode());
            List<MaterialContractEntity> contractList = materialContractService.list(wrapper);
            if(contractList!=null && contractList.size()>0){
                materialContract = contractList.get(0);
                materialContract.setName(contractVO.getContractName());
                materialContract.setSignDate(contractVO.getSignDate());
                materialContract.setAmountWithTax(contractVO.getContractMny());
                materialContract.setAmountWithoutTax(contractVO.getContractMny());
                if(customerVO!=null){
                    materialContract.setContractorEnterpriseId(customerVO.getId());
                    materialContract.setContractorEnterpriseName(customerVO.getName());
                }
                if(supplierVO!=null){
                    materialContract.setSupplierId(supplierVO.getId());
                    materialContract.setSupplierName(supplierVO.getName());
                }
            }else{
                materialContract = new MaterialContractEntity();
                materialContract.setId(IdWorker.getId());
                materialContract.setCode(contractVO.getContractCode());
                materialContract.setName(contractVO.getContractName());
                materialContract.setSignDate(contractVO.getSignDate());
                materialContract.setAmountWithTax(contractVO.getContractMny());
                materialContract.setAmountWithoutTax(contractVO.getContractMny());
                if(customerVO!=null){
                    materialContract.setContractorEnterpriseId(customerVO.getId());
                    materialContract.setContractorEnterpriseName(customerVO.getName());
                }
                if(supplierVO!=null){
                    materialContract.setSupplierId(supplierVO.getId());
                    materialContract.setSupplierName(supplierVO.getName());
                }

                materialContract.setProjectId(pro.getId());
                materialContract.setProjectName(pro.getName());
                materialContract.setOrgId(pro.getProjectDepartmentId());

                materialContract.setChangeState(1);
                materialContract.setState("1");
                materialContract.setBillState(0);
            }
            materialContractService.saveOrUpdate(materialContract, false);
        }else if("劳务合同".equals(contractVO.getType())){
            SubContractEntity subContract = null;
            QueryWrapper<SubContractEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_code", contractVO.getContractCode());
            List<SubContractEntity> contractList = subContractService.list(wrapper);
            if(contractList!=null && contractList.size()>0){
                subContract = contractList.get(0);
                subContract.setContractName(contractVO.getContractName());
                subContract.setSignDate(contractVO.getSignDate());
                subContract.setContractMny(contractVO.getContractMny());
                subContract.setContractTaxMny(contractVO.getContractMny());
                if(customerVO!=null){
                    subContract.setCustomerId(customerVO.getId());
                    subContract.setCustomerName(customerVO.getName());
                }
                if(supplierVO!=null){
                    subContract.setSupplierId(supplierVO.getId());
                    subContract.setSupplierName(supplierVO.getName());
                }
            }else{
                subContract = new SubContractEntity();
                subContract.setId(IdWorker.getId());
                subContract.setBillCode(contractVO.getContractCode());
                subContract.setContractName(contractVO.getContractName());
                subContract.setSignDate(contractVO.getSignDate());
                subContract.setContractMny(contractVO.getContractMny());
                subContract.setContractTaxMny(contractVO.getContractMny());
                if(customerVO!=null){
                    subContract.setCustomerId(customerVO.getId());
                    subContract.setCustomerName(customerVO.getName());
                }
                if(supplierVO!=null){
                    subContract.setSupplierId(supplierVO.getId());
                    subContract.setSupplierName(supplierVO.getName());
                }

                subContract.setProjectId(pro.getId());
                subContract.setProjectName(pro.getName());
                subContract.setOrgId(pro.getProjectDepartmentId());

                subContract.setChangeStatus(1);
                subContract.setContractStatus("2");
                subContract.setBillState(0);
            }

            subContractService.saveOrUpdate(subContract, false);
        }else if("其他支出合同".equals(contractVO.getType())){
            OtherContractEntity otherContract = null;
            QueryWrapper<OtherContractEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_code", contractVO.getContractCode());
            List<OtherContractEntity> contractList = otherContractService.list(wrapper);
            if(contractList!=null && contractList.size()>0){
                otherContract = contractList.get(0);
                otherContract.setContractName(contractVO.getContractName());
                otherContract.setSignDate(contractVO.getSignDate());
                otherContract.setContractMny(contractVO.getContractMny());
                otherContract.setContractTaxMny(contractVO.getContractMny());
                if(customerVO!=null){
                    otherContract.setCustomerId(customerVO.getId());
                    otherContract.setCustomerName(customerVO.getName());
                }
                if(supplierVO!=null){
                    otherContract.setSupplierId(supplierVO.getId());
                    otherContract.setSupplierName(supplierVO.getName());
                }
            }else{
                otherContract = new OtherContractEntity();
                otherContract.setId(IdWorker.getId());
                otherContract.setBillCode(contractVO.getContractCode());
                otherContract.setContractName(contractVO.getContractName());
                otherContract.setSignDate(contractVO.getSignDate());
                otherContract.setContractMny(contractVO.getContractMny());
                otherContract.setContractTaxMny(contractVO.getContractMny());
                if(customerVO!=null){
                    otherContract.setCustomerId(customerVO.getId());
                    otherContract.setCustomerName(customerVO.getName());
                }
                if(supplierVO!=null){
                    otherContract.setSupplierId(supplierVO.getId());
                    otherContract.setSupplierName(supplierVO.getName());
                }

                otherContract.setProjectId(pro.getId());
                otherContract.setProjectName(pro.getName());
                otherContract.setOrgId(pro.getProjectDepartmentId());

                otherContract.setChangeStatus(1);
                otherContract.setContractStatus("2");
                otherContract.setBillState(0);
            }
            otherContractService.saveOrUpdate(otherContract, false);
        }
        logger.info("---------------------同步合同结束----------------------");
    }
}
