package com.ejianc.business.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.asset.bean.AssetRecordEntity;
/**
 * 固定资产
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_asset")
public class AssetEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="material_id")
    private Long materialId; // 资产id（来源合同明细id）
    @TableField(value="asset_name")
    private String assetName; // 资产名称（来源合同明细产品名称）
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="measure_unit")
    private String measureUnit; // 计量单位
    @TableField(value="finance_entry_date")
    private Date financeEntryDate; // 财务入账日期
    @TableField(value="property_org_id")
    private Long propertyOrgId; // 产权单位id
    @TableField(value="property_org_name")
    private String propertyOrgName; // 产权单位名称
    @TableField(value="manage_org_id")
    private Long manageOrgId; // 管理单位id
    @TableField(value="manage_org_name")
    private String manageOrgName; // 管理单位名称
    @TableField(value="depend_on_project")
    private Integer dependOnProject; // 是否属于项目: 默认为true
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 所属项目名称
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="use_dept")
    private String useDept; // 使用部门
    @TableField(value="deposit_place")
    private String depositPlace; // 存放地点
    @TableField(value="use_person")
    private String usePerson; // 使用人
    @TableField(value="equipment_state")
    private Integer equipmentState; // 设备状态：1-在用 2-处置 3-报废
    @TableField(value="asset_type_id")
    private Long assetTypeId; // 资产类别id
    @TableField(value="asset_type_name")
    private String assetTypeName; // 资产类别名称
    @TableField(value="check_date")
    private Date checkDate; // 验收日期
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商Id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="asset_source_type")
    private Integer assetSourceType; // 资产来源：1-手动新增 2-导入
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="origin")
    private String origin; // 产地
    @TableField(value="maker")
    private String maker; // 制造商
    @TableField(value="tec_code")
    private String tecCode; // 技术编码
    @TableField(value="out_factory_date")
    private Date outFactoryDate; // 出厂日期
    @TableField(value="depreciation_id")
    private Long depreciationId; // 折旧方法id
    @TableField(value="depreciation_name")
    private String depreciationName; // 折旧方法名称
    @TableField(value="init_coin_mny")
    private BigDecimal initCoinMny; // 原币金额
    @TableField(value="asset_init_mny")
    private BigDecimal assetInitMny; // 资产原值
    @TableField(value="expect_use_term")
    private String expectUseTerm; // 预计使用期间数
    @TableField(value="depreciation_term")
    private String depreciationTerm; // 已折旧期间数
    @TableField(value="total_depreciation_mny")
    private BigDecimal totalDepreciationMny; // 累计折旧金额
    @TableField(value="expect_salvage_mny")
    private BigDecimal expectSalvageMny; // 预计净残值
    @TableField(value="net_mny")
    private BigDecimal netMny; // 净值
    @TableField(value="dispose_mny")
    private BigDecimal disposeMny; // 处置金额
    @TableField(value="out_occupy_flag")
    private Integer outOccupyFlag; // 是否被调出占用 0-否 1-是
    
    @TableField(exist=false)
    @SubEntity(serviceName="assetRecordService", pidName = "assetId")
    private List<AssetRecordEntity> detailList = new ArrayList<>(); // 固定资产流转记录

    public Integer getOutOccupyFlag() {
        return outOccupyFlag;
    }

    public void setOutOccupyFlag(Integer outOccupyFlag) {
        this.outOccupyFlag = outOccupyFlag;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getAssetName() {
        return assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getMeasureUnit() {
        return measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }
    public Date getFinanceEntryDate() {
        return financeEntryDate;
    }

    public void setFinanceEntryDate(Date financeEntryDate) {
        this.financeEntryDate = financeEntryDate;
    }
    public Long getPropertyOrgId() {
        return propertyOrgId;
    }

    public void setPropertyOrgId(Long propertyOrgId) {
        this.propertyOrgId = propertyOrgId;
    }
    public String getPropertyOrgName() {
        return propertyOrgName;
    }

    public void setPropertyOrgName(String propertyOrgName) {
        this.propertyOrgName = propertyOrgName;
    }
    public Long getManageOrgId() {
        return manageOrgId;
    }

    public void setManageOrgId(Long manageOrgId) {
        this.manageOrgId = manageOrgId;
    }
    public String getManageOrgName() {
        return manageOrgName;
    }

    public void setManageOrgName(String manageOrgName) {
        this.manageOrgName = manageOrgName;
    }
    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getUseDept() {
        return useDept;
    }

    public void setUseDept(String useDept) {
        this.useDept = useDept;
    }
    public String getDepositPlace() {
        return depositPlace;
    }

    public void setDepositPlace(String depositPlace) {
        this.depositPlace = depositPlace;
    }
    public String getUsePerson() {
        return usePerson;
    }

    public void setUsePerson(String usePerson) {
        this.usePerson = usePerson;
    }
    public Integer getEquipmentState() {
        return equipmentState;
    }

    public void setEquipmentState(Integer equipmentState) {
        this.equipmentState = equipmentState;
    }
    public Long getAssetTypeId() {
        return assetTypeId;
    }

    public void setAssetTypeId(Long assetTypeId) {
        this.assetTypeId = assetTypeId;
    }
    public String getAssetTypeName() {
        return assetTypeName;
    }

    public void setAssetTypeName(String assetTypeName) {
        this.assetTypeName = assetTypeName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Integer getAssetSourceType() {
        return assetSourceType;
    }

    public void setAssetSourceType(Integer assetSourceType) {
        this.assetSourceType = assetSourceType;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
    public String getMaker() {
        return maker;
    }

    public void setMaker(String maker) {
        this.maker = maker;
    }
    public String getTecCode() {
        return tecCode;
    }

    public void setTecCode(String tecCode) {
        this.tecCode = tecCode;
    }
    public Date getOutFactoryDate() {
        return outFactoryDate;
    }

    public void setOutFactoryDate(Date outFactoryDate) {
        this.outFactoryDate = outFactoryDate;
    }
    public Long getDepreciationId() {
        return depreciationId;
    }

    public void setDepreciationId(Long depreciationId) {
        this.depreciationId = depreciationId;
    }
    public String getDepreciationName() {
        return depreciationName;
    }

    public void setDepreciationName(String depreciationName) {
        this.depreciationName = depreciationName;
    }
    public BigDecimal getInitCoinMny() {
        return initCoinMny;
    }

    public void setInitCoinMny(BigDecimal initCoinMny) {
        this.initCoinMny = initCoinMny;
    }
    public BigDecimal getAssetInitMny() {
        return assetInitMny;
    }

    public void setAssetInitMny(BigDecimal assetInitMny) {
        this.assetInitMny = assetInitMny;
    }
    public String getExpectUseTerm() {
        return expectUseTerm;
    }

    public void setExpectUseTerm(String expectUseTerm) {
        this.expectUseTerm = expectUseTerm;
    }
    public String getDepreciationTerm() {
        return depreciationTerm;
    }

    public void setDepreciationTerm(String depreciationTerm) {
        this.depreciationTerm = depreciationTerm;
    }
    public BigDecimal getTotalDepreciationMny() {
        return totalDepreciationMny;
    }

    public void setTotalDepreciationMny(BigDecimal totalDepreciationMny) {
        this.totalDepreciationMny = totalDepreciationMny;
    }
    public BigDecimal getExpectSalvageMny() {
        return expectSalvageMny;
    }

    public void setExpectSalvageMny(BigDecimal expectSalvageMny) {
        this.expectSalvageMny = expectSalvageMny;
    }
    public BigDecimal getNetMny() {
        return netMny;
    }

    public void setNetMny(BigDecimal netMny) {
        this.netMny = netMny;
    }
    public BigDecimal getDisposeMny() {
        return disposeMny;
    }

    public void setDisposeMny(BigDecimal disposeMny) {
        this.disposeMny = disposeMny;
    }


    public List<AssetRecordEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AssetRecordEntity> detailList) {
        this.detailList = detailList;
    }
}
