package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.bean.PurchaseSettlementMaterialDetailEntity;
import com.ejianc.business.material.bean.PurchaseSettlementOtherFeeEntity;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.mapper.PurchaseSettlementMapper;
import com.ejianc.business.material.mapper.PurchaseSettlementMaterialDetailMapper;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class PurchaseSettlementService extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity> implements IPurchaseSettlementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private PurchaseSettlementMaterialDetailMapper purchaseSettlementMaterialDetailMapper;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IParamConfigApi paramConfigApi;

    //总计划量
    private static String PARAM_PLAN_COUNT = "P-41513I11";

    //总计划价
    private static String PARAM_PLAN_PRICE = "P-u2AcaJ12";


    //历史价
    private static String PARAM_PRICE_AREA = "P-166rjs14";
    //【材料合同价】控制【材料结算价】
    private static String PARAM_DETAIL_PRICE = "P-7PCBV283";

    //合同金额
    private static String PARAM_PRICE_CONTRACT = "P-hSH85015";

    @Override
    public IPage<PurchaseSettlementVO> queryForList(QueryParam queryParam, boolean isEs) {
        // 结算跳转付款申请制单标识
        boolean payApplyFlagHasFree = queryParam.getParams().containsKey("payApplyFlagHasFree");
        queryParam.getParams().remove("payApplyFlagHasFree");
        IPage<PurchaseSettlementVO> voPage = null;
        IPage<PurchaseSettlementEntity> entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            List<PurchaseSettlementVO> purchaseSettlementVOS = BeanMapper.mapList(entityPage.getRecords(), PurchaseSettlementVO.class);
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(purchaseSettlementVOS);
        }
        return voPage;
    }

    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper<PurchaseSettlementEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(current_settlement_amount_tax) as totalSettleAmount");
        Map<String, Object> amount = super.getMap(query);

        return null != amount ? new BigDecimal(amount.get("totalSettleAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }
    @Override
    public BigDecimal calculateTotalSettlementNoTax(QueryParam queryParam) {
        QueryWrapper<PurchaseSettlementEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(current_settlement_amount) as totalSettleAmountNoTax");
        Map<String, Object> amount = super.getMap(query);

        return null != amount ? new BigDecimal(amount.get("totalSettleAmountNoTax").toString()) : BigDecimal.ZERO.setScale(8);
    }

    @Override
    public void processCost(PurchaseSettlementEntity entity) {
        String factor = "1";
        boolean canPush = true;

        entity.setRelationFlag(canPush ? "1" : "0");
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, BigDecimal settledAmount, BigDecimal currentSettlementAmount, BigDecimal contractAmount, String purchaseMethod, MaterialPriceVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};

        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        List<MaterialPriceVO> detailList = vo.getDetail();
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        if (CollectionUtils.isNotEmpty(detailList) && (int) detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

            Map<Long, MaterialPriceVO> numMap = new HashMap<>();
            detailList.forEach(detail -> {
                MaterialPriceVO materialPriceVO = numMap.get(detail.getMaterialId());
                if (materialPriceVO != null) {
                    materialPriceVO.setNum(ComputeUtil.safeAdd(materialPriceVO.getNum(), detail.getNum()));
                    materialPriceVO.setPrice(ComputeUtil.isLessThan(detail.getPrice(), materialPriceVO.getPrice()) ? detail.getPrice() : materialPriceVO.getPrice());
                } else {
                    numMap.put(detail.getMaterialId(), detail);
                }
            });
            vo.setDetail(new ArrayList<>(numMap.values()));

            List<MaterialPriceVO> detail = vo.getDetail();
            if (CollectionUtils.isNotEmpty(detail)) {
                if (isJc == 0) {
                    // 【物资总计划量】控制【物资合同量】 组织结算不受控制
                    CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_COUNT, curOrgId);
                    if (!response.isSuccess()) {
                        throw new BusinessException("【物资总计划量】控制【物资合同量】，获取控制参数失败，失败原因：" + response.getMsg());
                    }
                    List<BillParamVO> billParamVOS = response.getData();

                    if (CollectionUtils.isNotEmpty(billParamVOS)) {
                        for (BillParamVO billParamVO : billParamVOS) {
                            if (0 != billParamVO.getControlType()) {
                                List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                                //获取已生效的量
                                List<MaterialPriceVO> vos = purchaseSettlementMaterialDetailMapper.purchaseSettlementMaterialDetailMapper(vo.getProjectId(), materialIds);

                                Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                                for (MaterialPriceVO d : detail) {
                                    BigDecimal num = d.getNum();
                                    BigDecimal planNum = d.getPlanNum();
                                    BigDecimal _planNum = planNum.multiply(divide);
                                    BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                                    BigDecimal allNum = hasNum.add(num);
                                    if (allNum.compareTo(_planNum) > 0) {
                                        //已签订数量
                                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                        paramsCheckDsVO.setWarnName("物资结算量大于总计划量");
                                        StringBuffer stringBuffer = new StringBuffer();
                                        stringBuffer.append("本次结算数量：").append(num.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                                .append("，已结算数量：").append(hasNum.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                                .append("，总计划数量*").append(roleValue.setScale(8,4).stripTrailingZeros().toPlainString())
                                                .append("%:").append(_planNum.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                                .append("。超出数量：").append(allNum.subtract(_planNum).setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString());
                                        paramsCheckDsVO.setContent(stringBuffer.toString());
                                        updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                    }
                                }
                            }
                        }
                    }

                    // 总计划价格【总计划价】控制【物资结算价】 组织结算不受控制
                    CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_PRICE, curOrgId);
                    if (!response1.isSuccess()) {
                        throw new BusinessException("总计划价格【总计划价】控制【物资结算价】，获取控制参数失败，失败原因：" + response1.getMsg());
                    }
                    List<BillParamVO> billParamVOS1 = response1.getData();

                    if (CollectionUtils.isNotEmpty(billParamVOS1)) {
                        for (BillParamVO billParamVO : billParamVOS1) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                                for (MaterialPriceVO d : detail) {
                                    BigDecimal price = d.getPrice();
                                    BigDecimal planPrice = d.getPlanPrice();
                                    if (price.compareTo(planPrice) > 0) {
                                        BigDecimal _planPrice = planPrice.multiply(divide);
                                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                        paramsCheckDsVO.setWarnName("结算单价大于总计划单价");
                                        StringBuffer stringBuffer = new StringBuffer();
                                        stringBuffer.append("本次结算单价：").append(price.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                                .append("，总计划单价*").append(roleValue.setScale(8,4).stripTrailingZeros().toPlainString())
                                                .append("%: ").append(_planPrice.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                                .append("。超出金额：").append(price.subtract(_planPrice).setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString());
                                        paramsCheckDsVO.setContent(stringBuffer.toString());
                                        updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                    }
                                }
                            }
                        }
                    }

                }


                // 结算历史价格区间【历史价】控制【物资结算价】
                CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PRICE_AREA, curOrgId);
                if (!response1.isSuccess()) {
                    throw new BusinessException("结算历史价格区间【历史价】控制【物资结算价】，获取控制参数失败，失败原因：" + response1.getMsg());
                }
                List<BillParamVO> billParamVOS1 = response1.getData();

                if (CollectionUtils.isNotEmpty(billParamVOS1)) {
                    for (BillParamVO billParamVO : billParamVOS1) {
                        if (0 != billParamVO.getControlType()) {
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                            for (MaterialPriceVO d : detail) {
                                BigDecimal price = d.getPrice();
                                BigDecimal maxPrice = d.getMaxPrice() == null ? BigDecimal.ZERO : d.getMaxPrice();
                                BigDecimal minPrice = d.getMinPrice();
                                if (price.compareTo(maxPrice) > 0 && maxPrice.compareTo(BigDecimal.ZERO) > 0) {
                                    BigDecimal _maxPrice = maxPrice.multiply(divide);
                                    BigDecimal _minPrice = minPrice.multiply(divide);
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("结算单价大于物资历史价");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("本次结算单价：").append(price.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                            .append("，物资历史价*").append(roleValue.setScale(8,4).stripTrailingZeros().toPlainString()).append("%: ")
                                            .append(_minPrice.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                            .append("~").append(_maxPrice.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                            .append("。超出最高价：").append(price.subtract(_maxPrice).setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString());
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            }
                        }
                    }
                }

                //【材料合同价】控制【材料结算价】
                    CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_DETAIL_PRICE, curOrgId);
                    if (!response.isSuccess()) {
                        throw new BusinessException("【材料合同价】控制【材料结算价】，获取控制参数失败，失败原因：" + response.getMsg());
                    }
                    List<BillParamVO> billParamVOS = response.getData();
                    if (CollectionUtils.isNotEmpty(billParamVOS)) {
                        MaterialContractEntity materialContractEntity = materialContractService.selectById(contractId);
                        MaterialContractVO contractVO = BeanMapper.map(materialContractEntity, MaterialContractVO.class);
                        List<MaterialContractDetailSubVO> materialDetailList = contractVO.getMaterialDetailList();
                        Map<String, BigDecimal> conMap = new HashMap();
                        if (CollectionUtils.isNotEmpty(materialDetailList)){
                            conMap = materialDetailList.stream().collect(Collectors.toMap(MaterialContractDetailSubVO::getMaterialId, MaterialContractDetailSubVO::getUnitPrice, (v1, v2) -> v2));
                        }
                        for (BillParamVO billParamVO : billParamVOS) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                                for (MaterialPriceVO d : detail) {
                                    if (conMap.keySet().contains(String.valueOf(d.getMaterialId()))) {
                                        BigDecimal price = d.getPrice();
                                        BigDecimal conPrice = ComputeUtil.nullToZero(conMap.get(String.valueOf(d.getMaterialId())));
                                        //百分比单价
                                        BigDecimal _conPrice = ComputeUtil.safeMultiply(conPrice,divide);
                                        if (price.compareTo(_conPrice) > 0) {
                                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                            paramsCheckDsVO.setWarnName("材料结算单价大于采购合同价");
                                            StringBuffer stringBuffer = new StringBuffer();
                                            stringBuffer.append("本次结算单价：").append(price.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                                    .append("，采购合同单价*").append(roleValue.setScale(8,4).stripTrailingZeros().toPlainString()).append("%: ")
                                                    .append(_conPrice.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                                    .append("。超出金额：").append(ComputeUtil.safeSub(price, _conPrice)
                                                    .setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString());
                                            paramsCheckDsVO.setContent(stringBuffer.toString());
                                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
        }
        if (isJc == 0) {
        //【合同金额】控制【结算金额】 集采合同不受该参数影响
        CommonResponse<List<BillParamVO>> response2 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PRICE_CONTRACT, curOrgId);
        if (!response2.isSuccess()) {
            throw new BusinessException("【合同金额】控制【结算金额】，获取控制参数失败，失败原因：" + response2.getMsg());
        }
        List<BillParamVO> billParamVOS2 = response2.getData();

        if (CollectionUtils.isNotEmpty(billParamVOS2)) {
            for (BillParamVO billParamVO : billParamVOS2) {
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal comMny = contractAmount.multiply(roleValue.divide(BigDecimal.valueOf(100)));
                BigDecimal sumPayWithThisMny = settledAmount.add(currentSettlementAmount);
                if (sumPayWithThisMny.compareTo(comMny) > 0) {
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("合同超结");
                    paramsCheckDsVO.setWarnName("结算金额大于合同金额");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次结算金额：").append(currentSettlementAmount.setScale(2, BigDecimal.ROUND_HALF_UP))
                            .append("元，合同金额*").append(roleValue.setScale(8,4).stripTrailingZeros().toPlainString()).append("%: ")
                            .append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元。超出金额：").append(sumPayWithThisMny.subtract(comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }
        }




        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public JSONObject querySettleNum(SettleNumberVO settleNumberVO) {
        JSONObject result = new JSONObject();
        Long projectId = settleNumberVO.getProjectId();
        Long contractId = settleNumberVO.getContractId();
        List<Long> materialIds = settleNumberVO.getMaterialIds();
        List<SettleNumberVO> list = purchaseSettlementMaterialDetailMapper.querySettleNum(projectId, contractId, materialIds);
        Map<Long, BigDecimal> settleNumMap = list.stream().collect(Collectors.toMap(SettleNumberVO::getMaterialId, SettleNumberVO::getSettleNumber));
        result.put("projectId",projectId);
        result.put("contractId",contractId);
        result.put("settleNumMap",settleNumMap);
        return result;
    }

    @Override
    public List<Map<String, Object>> querySettlePayWarn(List<SqlParam> sqlParamList) {
        return baseMapper.querySettlePayWarn(sqlParamList);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper<PurchaseSettlementEntity> wrapper = super.changeToQueryWrapper(param);
        wrapper.select("sum(current_settlement_amount_tax) as sumSettlementAmountTax, sum(current_apply_amount) as sumApplyAmount, sum(current_paid_amount) as sumPaidAmount");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("sumSettlementAmountTax", 0);
            resp.put("sumApplyAmount", 0);
            resp.put("sumPaidAmount", 0);
        }
        return resp;
    }
}
