package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.service.IPlanChangeHisService;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 总计划审批回调服务类
 *
 * @author CJ
 * @Description: 总计划审批回调服务类
 * @date 2021/3/6 16:50
 */
@Service("materialMasterPlan")
public class PlanBpmCallbackServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPlanChangeService planChangeService;

    @Autowired
    private IPlanChangeHisService planChangeHisService;

    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;

    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialMasterPlanEntity e = materialMasterPlanService.selectById(billId);
        UserContext userContext = sessionManager.getUserContext();

        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        materialMasterPlanService.saveOrUpdate(e, false);

        return CommonResponse.success("总计划审批回调处理成功！");
    }

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialMasterPlanEntity e = materialMasterPlanService.selectById(billId);
        e.setEffectiveDate(new Date());
        if(state == 1) {
            //直审时记录
            UserContext userContext = sessionManager.getUserContext();
            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
        }
        materialMasterPlanService.saveOrUpdate(e, false);
        return CommonResponse.success("总计划审批回调处理成功！");
    }

    /**
     * 弃审
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialMasterPlanEntity e = materialMasterPlanService.selectById(billId);

        logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】执行弃审前校验！", billId, billTypeCode);
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】校验被下游单据引用结果：{}", billId, billTypeCode, JSONObject.toJSONString(resp));
        if(!resp.isSuccess()) {
            logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】执行弃审操作校验结束，未通过校验，原因：{}", resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }

        return CommonResponse.success("总计划弃审回调处理成功！");
    }

    /**
     * 撤回
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        MaterialMasterPlanEntity e = materialMasterPlanService.selectById(billId);

        logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】执行撤回前校验！", billId, billTypeCode);
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】校验被下游单据引用结果：{}", billId, billTypeCode, JSONObject.toJSONString(resp));
        if(!resp.isSuccess()) {
            logger.info("物资总计划单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}", resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }

        return CommonResponse.success("总计划撤回回调处理成功！");
    }
}
