/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuotePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteRentDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultEntity;
import com.ejianc.business.bidprice.material.bean.PicketageQuotePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.PicketageQuoteRentDetailEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageService;
import com.ejianc.business.bidprice.material.service.IMaterialQuotePurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteRentDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.business.bidprice.material.service.IMaterialResultService;
import com.ejianc.business.bidprice.material.service.IPicketageQuotePurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IPicketageQuoteRentDetailService;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuotePurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="inquiryCommonService")
public class InquiryCommonService {
    @Autowired
    private IMaterialInquiryService materialInquiryService;
    @Autowired
    private IMaterialQuoteService materialQuoteService;
    @Autowired
    private IMaterialQuotePurchaseDetailService materialQuotePurchaseDetailService;
    @Autowired
    private IMaterialQuoteRentDetailService materialQuoteRentDetailService;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IMaterialResultService materialResultService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IMaterialPicketageService materialPicketageService;
    @Autowired
    private IPicketageQuotePurchaseDetailService purchaseDetailService;
    @Autowired
    private IPicketageQuoteRentDetailService rentDetailService;

    public InquiryCommonVO queryDetailByInquiry(Long inquiryId, Integer inquiryState, String inquiryType, Boolean picketageFlag) {
        InquiryCommonVO inquiryCommonVO;
        block19: {
            HashMap<Long, String> supplierNameMap;
            List quoteIds;
            block20: {
                MaterialInquiryEntity inquiryEntity = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(inquiryId));
                MaterialInquiryVO materialInquiryVO = (MaterialInquiryVO)((Object)BeanMapper.map((Object)((Object)inquiryEntity), MaterialInquiryVO.class));
                inquiryCommonVO = (InquiryCommonVO)((Object)BeanMapper.map((Object)((Object)materialInquiryVO), InquiryCommonVO.class));
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(MaterialQuoteEntity::getInquiryId, (Object)inquiryId);
                queryWrapper.in(MaterialQuoteEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
                List list = this.materialQuoteService.list((Wrapper)queryWrapper);
                List materialQuoteVOS = BeanMapper.mapList((Iterable)list, MaterialQuoteVO.class);
                inquiryCommonVO.setMaterialQuoteVOList(materialQuoteVOS);
                Map<Object, Object> purchaseListMap = new HashMap();
                Map<Object, Object> rentListMap = new HashMap();
                QueryWrapper quotePurchaseWrapper = new QueryWrapper();
                quotePurchaseWrapper.eq((Object)"inquiry_id", (Object)inquiryId);
                List purchaseDetailEntities = this.purchaseDetailService.list((Wrapper)quotePurchaseWrapper);
                if (CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) {
                    purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuotePurchaseDetailEntity::getQuoteId));
                }
                QueryWrapper quoteRentWrapper = new QueryWrapper();
                quoteRentWrapper.eq((Object)"inquiry_id", (Object)inquiryId);
                List rentDetailEntities = this.rentDetailService.list();
                if (CollectionUtils.isNotEmpty((Collection)rentDetailEntities)) {
                    rentListMap = rentDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteRentDetailEntity::getQuoteId));
                }
                if (!CollectionUtils.isNotEmpty((Collection)materialQuoteVOS)) break block19;
                quoteIds = materialQuoteVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
                JSONObject fileParam = new JSONObject();
                fileParam.put("sourceIds", quoteIds);
                JSONArray sourceTypeArr = new JSONArray();
                sourceTypeArr.add((Object)"quote");
                fileParam.put("sourceTypeList", (Object)JSONObject.toJSONString((Object)sourceTypeArr));
                CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(fileParam);
                List fileData = (List)listCommonResponse.getData();
                Map<Object, Object> fileMap = new HashMap();
                if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)fileData)) {
                    fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (e1, e2) -> e1));
                }
                if (!fileMap.isEmpty()) {
                    for (MaterialQuoteVO quoteVO : materialQuoteVOS) {
                        AttachmentVO attachmentVO = (AttachmentVO)fileMap.get(quoteVO.getId());
                        if (attachmentVO == null) continue;
                        quoteVO.setQuoteFileId(attachmentVO.getId());
                        quoteVO.setQuoteFileName(attachmentVO.getFileName());
                    }
                }
                Map<String, List<MaterialQuoteVO>> supplierQuoteMap = materialQuoteVOS.stream().collect(Collectors.groupingBy(MaterialQuoteVO::getSocialCreditCode));
                supplierNameMap = new HashMap<Long, String>();
                for (String key : supplierQuoteMap.keySet()) {
                    List<MaterialQuoteVO> valueList = supplierQuoteMap.get(key);
                    if (valueList.size() > 1) {
                        int i = 1;
                        for (MaterialQuoteVO materialQuoteVO : valueList) {
                            String biewVersion = " (\u65b9\u6848" + i++ + ")";
                            String _supplierNameView = materialQuoteVO.getSupplierName() + (String)biewVersion;
                            materialQuoteVO.setSupplierNameView(_supplierNameView);
                            materialQuoteVO.setViewVersion(biewVersion);
                            supplierNameMap.put(materialQuoteVO.getId(), _supplierNameView);
                        }
                        continue;
                    }
                    MaterialQuoteVO quoteVO = valueList.get(0);
                    quoteVO.setSupplierNameView(quoteVO.getSupplierName());
                    supplierNameMap.put(quoteVO.getId(), quoteVO.getSupplierName());
                }
                if (picketageFlag != null && picketageFlag.booleanValue()) {
                    LambdaQueryWrapper picketageEntityLambdaQueryWrapper = new LambdaQueryWrapper();
                    picketageEntityLambdaQueryWrapper.eq(MaterialPicketageEntity::getInquiryId, (Object)inquiryId);
                    List picketageEntities = this.materialPicketageService.list((Wrapper)picketageEntityLambdaQueryWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)picketageEntities)) {
                        MaterialPicketageEntity materialPicketageEntity = (MaterialPicketageEntity)((Object)picketageEntities.get(0));
                        inquiryCommonVO.setId(materialPicketageEntity.getId());
                        inquiryCommonVO.setInquiryDate(materialPicketageEntity.getHandleDate());
                        inquiryCommonVO.setMemo(materialPicketageEntity.getMemo());
                    }
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.in(MaterialResultEntity::getQuoteId, quoteIds);
                    List resultEntityList = this.materialResultService.list((Wrapper)wrapper);
                    if (CollectionUtils.isNotEmpty((Collection)resultEntityList)) {
                        BigDecimal sumBidMny = BigDecimal.ZERO;
                        Map<Long, MaterialResultEntity> resultEntityMap = resultEntityList.stream().collect(Collectors.toMap(MaterialResultEntity::getQuoteId, e -> e, (e1, e2) -> e1));
                        for (MaterialQuoteVO materialQuoteVO : materialQuoteVOS) {
                            Long quoteVOId = materialQuoteVO.getId();
                            MaterialResultEntity materialResultEntity = resultEntityMap.get(quoteVOId);
                            if (materialResultEntity != null) {
                                materialQuoteVO.setSupplierName(materialResultEntity.getSupplierName());
                                materialQuoteVO.setSupplierNameView((String)supplierNameMap.get(materialResultEntity.getQuoteId()));
                                materialQuoteVO.setBidFlag(materialResultEntity.getBidFlag());
                                materialQuoteVO.setBidMny(materialResultEntity.getBidMny());
                                materialQuoteVO.setBidMemo(materialResultEntity.getBidMemo());
                                sumBidMny = ComputeUtil.safeAdd(sumBidMny, materialResultEntity.getBidMny());
                                if (CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities) && CollectionUtils.isNotEmpty((Collection)((Collection)purchaseListMap.get(materialQuoteVO.getId())))) {
                                    materialQuoteVO.setMaterialQuotePurchaseDetailList(BeanMapper.mapList((Iterable)((Iterable)purchaseListMap.get(materialQuoteVO.getId())), MaterialQuotePurchaseDetailVO.class));
                                }
                                if (!CollectionUtils.isNotEmpty((Collection)rentDetailEntities) || !CollectionUtils.isNotEmpty((Collection)((Collection)rentListMap.get(materialQuoteVO.getId())))) continue;
                                materialQuoteVO.setMaterialQuoteRentDetailList(BeanMapper.mapList((Iterable)((Iterable)rentListMap.get(materialQuoteVO.getId())), MaterialQuoteRentDetailVO.class));
                                continue;
                            }
                            materialQuoteVO.setBidFlag(0);
                        }
                        inquiryCommonVO.setSumBidMny(sumBidMny);
                    }
                }
                if (inquiryCommonVO.getPricingType() != 1) break block20;
                LambdaQueryWrapper purchaseDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper();
                purchaseDetailEntityLambdaQueryWrapper.in(MaterialQuotePurchaseDetailEntity::getQuoteId, quoteIds);
                List purchaseDetailEntityList = this.materialQuotePurchaseDetailService.list((Wrapper)purchaseDetailEntityLambdaQueryWrapper);
                List materialQuotePurchaseDetailVOS = BeanMapper.mapList((Iterable)purchaseDetailEntityList, MaterialQuotePurchaseDetailVO.class);
                if (!CollectionUtils.isNotEmpty((Collection)materialQuotePurchaseDetailVOS)) break block19;
                materialQuotePurchaseDetailVOS.forEach(t2 -> t2.setSupplierName((String)supplierNameMap.get(t2.getQuoteId())));
                Map<Long, List<MaterialQuotePurchaseDetailVO>> purchaseQuoteMap = materialQuotePurchaseDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuotePurchaseDetailVO::getSourceId));
                List<MaterialInquiryPurchaseDetailVO> materialInquiryPurchaseDetailList = inquiryCommonVO.getMaterialInquiryPurchaseDetailList();
                for (MaterialInquiryPurchaseDetailVO materialInquiryPurchaseDetailVO : materialInquiryPurchaseDetailList) {
                    List purchaseQuotePriceList;
                    List<MaterialQuotePurchaseDetailVO> materialQuotePurchaseDetailList = purchaseQuoteMap.get(materialInquiryPurchaseDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(materialQuotePurchaseDetailList) && CollectionUtils.isNotEmpty(purchaseQuotePriceList = materialQuotePurchaseDetailList.stream().filter(t2 -> t2.getPurchaseQuotePrice() != null).map(t2 -> t2.getPurchaseQuotePrice()).collect(Collectors.toList()))) {
                        BigDecimal maxPrice = (BigDecimal)Collections.max(purchaseQuotePriceList);
                        BigDecimal minPrice = (BigDecimal)Collections.min(purchaseQuotePriceList);
                        materialInquiryPurchaseDetailVO.setMinBidPrice(minPrice);
                        materialInquiryPurchaseDetailVO.setMaxBidPrice(maxPrice);
                    }
                    materialInquiryPurchaseDetailVO.setMaterialQuotePurchaseDetailVOList(materialQuotePurchaseDetailList);
                }
                break block19;
            }
            LambdaQueryWrapper rentDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            rentDetailEntityLambdaQueryWrapper.in(MaterialQuoteRentDetailEntity::getQuoteId, quoteIds);
            List rentDetailEntityList = this.materialQuoteRentDetailService.list((Wrapper)rentDetailEntityLambdaQueryWrapper);
            List materialQuoteRentDetailVOS = BeanMapper.mapList((Iterable)rentDetailEntityList, MaterialQuoteRentDetailVO.class);
            if (CollectionUtils.isNotEmpty((Collection)materialQuoteRentDetailVOS)) {
                materialQuoteRentDetailVOS.forEach(t2 -> t2.setSupplierName((String)supplierNameMap.get(t2.getQuoteId())));
                Map<Long, List<MaterialQuoteRentDetailVO>> rentQuoteMap = materialQuoteRentDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuoteRentDetailVO::getSourceId));
                List<MaterialInquiryRentDetailVO> materialInquiryRentDetailList = inquiryCommonVO.getMaterialInquiryRentDetailList();
                for (MaterialInquiryRentDetailVO materialInquiryRentDetailVO : materialInquiryRentDetailList) {
                    List<MaterialQuoteRentDetailVO> materialQuoteRentDetailVOList = rentQuoteMap.get(materialInquiryRentDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(materialQuoteRentDetailVOList)) {
                        BigDecimal maxPrice = materialQuoteRentDetailVOList.stream().filter(t2 -> t2.getRentQuotePrice() != null).max(Comparator.comparing(MaterialQuoteRentDetailVO::getRentQuotePrice)).get().getRentQuotePrice();
                        BigDecimal minPrice = materialQuoteRentDetailVOList.stream().filter(t2 -> t2.getRentQuotePrice() != null).min(Comparator.comparing(MaterialQuoteRentDetailVO::getRentQuotePrice)).get().getRentQuotePrice();
                        materialInquiryRentDetailVO.setMinBidPrice(minPrice);
                        materialInquiryRentDetailVO.setMaxBidPrice(maxPrice);
                    }
                    materialInquiryRentDetailVO.setMaterialQuoteRentDetailVOList(materialQuoteRentDetailVOList);
                }
            }
        }
        return inquiryCommonVO;
    }

    public JSONObject queryContractListByInquiry(Long inquiryId, Long picketageId, Integer inquiryState, String inquiryType) {
        MaterialPicketageEntity picketageEntity;
        JSONObject resObj = new JSONObject();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(inquiryId != null, MaterialResultEntity::getInquiryId, (Object)inquiryId);
        wrapper.eq(picketageId != null, MaterialResultEntity::getPicketageId, (Object)picketageId);
        List list = this.materialResultService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resObj;
        }
        LambdaQueryWrapper picketageEntityLambdaQueryWrapper = new LambdaQueryWrapper();
        picketageEntityLambdaQueryWrapper.eq(inquiryId != null, MaterialPicketageEntity::getInquiryId, (Object)inquiryId);
        picketageEntityLambdaQueryWrapper.eq(picketageId != null, BaseEntity::getId, (Object)picketageId);
        List picketageEntities = this.materialPicketageService.list((Wrapper)picketageEntityLambdaQueryWrapper);
        MaterialPicketageEntity materialPicketageEntity = picketageEntity = CollectionUtils.isNotEmpty((Collection)picketageEntities) ? (MaterialPicketageEntity)((Object)picketageEntities.get(0)) : null;
        if (picketageEntity != null) {
            resObj.put("picketageId", (Object)picketageEntity.getId());
            resObj.put("bidWinnerId", (Object)picketageEntity.getBidWinnerId());
            resObj.put("bidWinnerName", (Object)picketageEntity.getBidWinnerName());
        }
        Long l = inquiryId = inquiryId != null ? inquiryId : picketageEntity.getInquiryId();
        if (inquiryId != null) {
            MaterialInquiryEntity byId = (MaterialInquiryEntity)((Object)this.materialInquiryService.getById(inquiryId));
            resObj.put("billCode", (Object)byId.getBillCode());
            resObj.put("billState", (Object)byId.getBillState());
        }
        ArrayList<JSONObject> contractList = new ArrayList<JSONObject>();
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if ("material".equals(inquiryType)) {
            LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
            lambdaUpdateWrapper.in(MaterialContractEntity::getEnquiryPriceBillId, ids);
            lambdaUpdateWrapper.orderByDesc(MaterialContractEntity::getSignDate);
            List contractEntities = this.materialContractService.list((Wrapper)lambdaUpdateWrapper);
            for (MaterialContractEntity materialContractVO : contractEntities) {
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)materialContractVO.getId());
                obj.put("code", (Object)materialContractVO.getCode());
                obj.put("contractName", (Object)materialContractVO.getName());
                obj.put("supplierName", (Object)materialContractVO.getSupplierName());
                obj.put("contractType", (Object)"\u7269\u8d44\u91c7\u8d2d\u5408\u540c");
                obj.put("inquiryType", (Object)"material");
                obj.put("orgName", (Object)materialContractVO.getOrgName());
                obj.put("contractMny", (Object)materialContractVO.getAmountWithTax());
                if (materialContractVO.getSignDate() != null) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    String signDate = format.format(materialContractVO.getSignDate());
                    obj.put("signDate", (Object)signDate);
                }
                obj.put("billStateName", (Object)BillStateEnum.getEnumByStateCode((Integer)materialContractVO.getBillState()).getDescription());
                obj.put("billState", (Object)materialContractVO.getBillState());
                contractList.add(obj);
            }
        }
        resObj.put("contractList", contractList);
        return resObj;
    }
}

