/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.HistoryEntity;
import com.ejianc.business.income.mapper.HistoryMapper;
import com.ejianc.business.income.service.IHistoryClauseService;
import com.ejianc.business.income.service.IHistoryDetailService;
import com.ejianc.business.income.service.IHistoryService;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.HistoryClauseVo;
import com.ejianc.business.income.vo.HistoryDetailVo;
import com.ejianc.business.income.vo.HistoryVo;
import com.ejianc.business.income.vo.comparator.HistoryDetailComparatorVo;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="HistoryService")
public class HistoryServiceImpl
extends BaseServiceImpl<HistoryMapper, HistoryEntity>
implements IHistoryService {
    @Autowired
    private IHistoryDetailService historyDetailService;
    @Autowired
    private IHistoryClauseService historyClauseService;

    @Override
    public HistoryVo queryDetailByChangeId(Long changeId) {
        HistoryEntity historyEntity = (HistoryEntity)((Object)((HistoryMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().eq((Object)"change_id", (Object)changeId)));
        if (historyEntity != null) {
            HistoryVo historyVo = (HistoryVo)((Object)BeanMapper.map((Object)((Object)historyEntity), HistoryVo.class));
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("historyId", new Parameter("eq", (Object)historyEntity.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List historyDetailEntities = this.historyDetailService.queryList(queryParam, false);
            if (historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List detailVos = BeanMapper.mapList((Iterable)historyDetailEntities, HistoryDetailVo.class);
                Collections.sort(detailVos, new HistoryDetailComparatorVo());
                for (HistoryDetailVo cdEntity : detailVos) {
                    cdEntity.setTid(cdEntity.getContractBid().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                }
                historyVo.setCheckList(TreeNodeBUtil.buildTree(detailVos));
            }
            QueryParam query = new QueryParam();
            query.getParams().put("historyId", new Parameter("eq", (Object)historyEntity.getId()));
            query.getOrderMap().put("createTime", "desc");
            List clauses = this.historyClauseService.queryList(query, false);
            if (clauses != null && clauses.size() > 0) {
                List clauseVoList = BeanMapper.mapList((Iterable)clauses, HistoryClauseVo.class);
                historyVo.setClauseList(clauseVoList);
            }
            return historyVo;
        }
        return null;
    }
}

