package com.ejianc.business.labprice.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labprice.bean.LaborPicketageQuoteDetailEntity;
import com.ejianc.business.labprice.service.ILaborInquiryService;
import com.ejianc.business.labprice.service.ILaborPicketageQuoteDetailService;
import com.ejianc.business.labprice.service.ILaborPicketageSupplierService;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.bean.PicketageQuoteDetailEntity;
import com.ejianc.business.othprice.consts.InquiryStateEnum;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.service.IPicketageQuoteDetailService;
import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.service.IPicketageSupplierService;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labprice.bean.LaborPicketageEntity;
import com.ejianc.business.labprice.service.ILaborPicketageService;
import com.ejianc.business.labprice.vo.LaborPicketageVO;

/**
 * 定标
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("laborPicketage")
public class LaborPicketageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ILaborPicketageQuoteDetailService purchaseDetailService;
    private static final String BILL_CODE = "ZYDX_LABOR_PICKETAGE";//此处需要根据实际修改

    @Autowired
    private ILaborPicketageService service;
    @Autowired
    private ILaborPicketageSupplierService materialPicketageSupplierService;
    @Autowired
    private ILaborInquiryService inquiryService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LaborPicketageVO> saveOrUpdate(@RequestBody LaborPicketageVO saveOrUpdateVO) {
    	LaborPicketageEntity entity = BeanMapper.map(saveOrUpdateVO, LaborPicketageEntity.class);
        if (entity.getBidWinMny()!=null){
            entity.setBidWinMnyStr(entity.getBidWinMny().toString());
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                //自制 签订数量
                entity.setContractSign(0);
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (entity.getSelfFlag() == null ){
            entity.setSelfFlag(1);
        }
        service.insertOrUpdate(entity);
    	LaborPicketageVO vo = BeanMapper.map(entity, LaborPicketageVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("参照查询详情")
    @RequestMapping(value = "/queryDetailToRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailToRef(@RequestParam Long id) {
        JSONObject vo=service.queryDetailToRef(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     *  根据询价单 id 查询 询价清单 和报价记录
     * @param inquiryId
     * @return 询价清单--{purchaseList、rentList} 报价记录--{quoteList} 清单数量统计--{totalMap}
     */
    @RequestMapping(value = "/queryByInquiryToDetailAndQuote", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(@RequestParam(value = "inquiryId") String inquiryId){
        return service.queryByInquiryToDetailAndQuote(inquiryId);
    }

    @ApiOperation("新增或者修改参照")
    @RequestMapping(value = "/saveOrUpdateRef", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> saveOrUpdateRef(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody LaborPicketageVO saveOrUpdateVO) {
        LaborPicketageEntity entity = BeanMapper.map(saveOrUpdateVO, LaborPicketageEntity.class);
        if (entity.getBidWinMny()!=null){
            entity.setBidWinMnyStr(entity.getBidWinMny().toString());
        }
        service.checkRefSave(entity);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                //自制 签订数量
                entity.setContractSign(0);
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if(entity.getInquiryId()!=null){
                inquiryService.updateInquiry(entity.getInquiryId(), InquiryStateEnum.WIN_STATE.getCode());
            }
        }

        if (entity.getSelfFlag() == null ){
            entity.setSelfFlag(1);
        }
        service.insertOrUpdateRef(entity);
        JSONObject vo=service.queryDetailToRef(entity.getId());
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LaborPicketageVO> queryDetail(Long id) {
        LaborPicketageVO vo = service.queryMaterialPicketageDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborPicketageVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            Collection<LaborPicketageEntity> materialPicketageEntities = service.listByIds(vos.stream().map(LaborPicketageVO::getId).collect(Collectors.toList()));
            for (LaborPicketageEntity vo : materialPicketageEntities) {
                if (vo.getSelfFlag()!=1){
                    inquiryService.updateInquiry(vo.getInquiryId(), InquiryStateEnum.EXPIRATION_STATE.getCode());
                }
                QueryWrapper<LaborPicketageQuoteDetailEntity> purchaseWrapper  = new QueryWrapper<>();
                purchaseWrapper.eq("picketage_id",vo.getId());
                purchaseDetailService.remove(purchaseWrapper);
            }
        }
        service.removeByIds(vos.stream().map(LaborPicketageVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LaborPicketageVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidWinnerName");
        /** 租户隔离 */
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("contractSign")){
            Integer contractSign= Integer.parseInt(params.get("contractSign").getValue().toString());
            params.remove("contractSign");
            if (contractSign==1){
                param.getParams().put("contractSign", new Parameter(QueryParam.GT,0));
            }else {
                param.getParams().put("contractSign", new Parameter(QueryParam.EQ,0));
            }
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<LaborPicketageEntity> page = service.queryPage(param,false);
        IPage<LaborPicketageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborPicketageVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LaborPicketageEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborPicketage-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLaborPicketageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LaborPicketageVO>> refLaborPicketageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LaborPicketageEntity> page = service.queryPage(param,false);
        IPage<LaborPicketageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborPicketageVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
