package com.ejianc.business.zyportal.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zyportal.service.IZyPortalService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

/**
 * 门户数据
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("zyPortal")
public class ZyPortalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IZyPortalService zyPortalService;

    /**
     * @Description 项目情况
     */
    @RequestMapping(value = "/getProjectInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getProjectInfo() {
        JSONObject json = zyPortalService.getProjectInfo();
    	return CommonResponse.success(json);
    }

    /**
     * @Description 产能统计
     */
    @RequestMapping(value = "/getProductionCapacity", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getProductionCapacity() {
        JSONObject json = zyPortalService.getProductionCapacity();
    	return CommonResponse.success(json);
    }

    /**
     * @Description 业务板块级
     */
    @RequestMapping(value = "/getBusinessSegment", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBusinessSegment() {
        JSONObject json = zyPortalService.getBusinessSegment();
    	return CommonResponse.success(json);
    }

    /**
     * @Description 分公司项目统计
     */
    @RequestMapping(value = "/getCompanyProjectInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getCompanyProjectInfo() {
        JSONObject json = zyPortalService.getCompanyProjectInfo();
    	return CommonResponse.success(json);
    }

    /**
     * @Description 项目金额区间--项目个数
     */
    @RequestMapping(value = "/getProjectMoneyInterval", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getProjectMoneyInterval() {
        JSONObject json = zyPortalService.getProjectMoneyInterval();
    	return CommonResponse.success(json);
    }

    /**
     * @Description 项目利润率区间--按照合同造价表里，项目毛利率统计
     */
    @RequestMapping(value = "/getProjectProfitMarginInterval", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getProjectProfitMarginInterval() {
        JSONObject json = zyPortalService.getProjectProfitMarginInterval();
    	return CommonResponse.success(json);
    }

    /**
     * @Description 项目进度分析
     */
    @RequestMapping(value = "/getProjectProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getProjectProcess() {
        JSONObject json = zyPortalService.getProjectProcess();
    	return CommonResponse.success(json);
    }

    /**
     * @Description 成本情况分析
     */
    @RequestMapping(value = "/getCostStructure", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getCostStructure() {
        JSONObject json = zyPortalService.getCostStructure();
    	return CommonResponse.success(json);
    }

    /**
     * @Description 进度成本分析
     */
    @RequestMapping(value = "/getProcessCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getProcessCost() {
        JSONObject json = zyPortalService.getProcessCost();
    	return CommonResponse.success(json);
    }


}
