package com.ejianc.business.zyportal.mapper;

import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.zyportal.vo.PortalVO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;
import java.util.Map;
import com.ejianc.business.income.bean.ProductionEntity;

@Mapper
public interface ZyPortalMapper{

    //获取项目数量
    Integer getProjectNum(Map<String, Object> params);

    List<ProductionEntity> getProductionCapacity(Map<String, Object> paramEfficiency);

    List<PortalVO> getBusinessSegment(Map<String, Object> params);

    List<PortalVO> getCompanyProjectInfo(Map<String, Object> params);

    PortalVO getProjectMoneyInterval(Map<String, Object> params);
    PortalVO getProjectProfitMarginInterval(Map<String, Object> params);

    List<ProductionEntity> getOutputValueProgress(Map<String, Object> outputValueProgressParams);

    List<ProjectRegisterVO> getProjectList(Map<String, Object> projectParams);

    List<PortalVO> getCompletionAssessment(Map<String, Object> completionAssessmentParams);

    List<PortalVO> getCostStructure(Map<String, Object> params);
    List<PortalVO> getConstructionCost(Map<String, Object> params);

    List<PortalVO> getMaterialMoney(Map<String, Object> materialParams);

    List<PortalVO> getOtherMoney(Map<String, Object> otherParams);

    List<PortalVO> getLaborProcessMoney(Map<String, Object> laborProcessParams);

    List<PortalVO> getLaborFinishMoney(Map<String, Object> laborFinishParams);
}
