package com.ejianc.business.sync.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.vo.PreBidCostCalcDetailVO;
import com.ejianc.business.market.bean.SpacePermitEntity;
import com.ejianc.business.market.service.ISpacePermitService;
import com.ejianc.business.market.vo.SpacePermitVO;
import com.ejianc.business.sync.service.ISyncService;
import com.ejianc.business.sync.vo.SyncContractVO;
import com.ejianc.business.sync.vo.SyncProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 同步数据
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sync")
public class SyncController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISyncService syncService;

    /**
     * @Description saveOrUpdate 同步项目
     */
    @RequestMapping(value = "/syncProject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncProject(@RequestBody SyncProjectVO projectVO) {
        syncService.syncProject(projectVO);
    	return CommonResponse.success("数据同步成功！");
    }

    /**
     * @Description saveOrUpdate 同步合同
     */
    @RequestMapping(value = "/syncContract", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncContract(@RequestBody SyncContractVO contractVO) {
        syncService.syncContract(contractVO);
        return CommonResponse.success("数据同步成功！");
    }
}
