/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.AssetAmortizeDetailEntity;
import com.ejianc.business.asset.bean.AssetAmortizeEntity;
import com.ejianc.business.asset.service.IAssetAmortizeService;
import com.ejianc.business.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.business.asset.vo.AssetAmortizeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"assetAmortize"})
public class AssetAmortizeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZY_ASSET_AMORTIZE";
    @Autowired
    private IAssetAmortizeService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> saveOrUpdate(@RequestBody AssetAmortizeVO saveOrUpdateVO) {
        QueryWrapper query = new QueryWrapper();
        if (null != saveOrUpdateVO.getDependOnProject() && 1 == saveOrUpdateVO.getDependOnProject()) {
            query.eq((Object)"project_id", (Object)saveOrUpdateVO.getProjectId());
        } else {
            query.eq((Object)"org_id", (Object)saveOrUpdateVO.getOrgId());
        }
        if (null != saveOrUpdateVO.getId()) {
            query.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        query.eq((Object)"bill_state", (Object)0);
        List billCodeEntityList = this.service.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)billCodeEntityList)) {
            return CommonResponse.error((String)("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5" + (saveOrUpdateVO.getDependOnProject() == 1 ? "\u9879\u76ee" : "\u7ec4\u7ec7") + "\u5df2\u6709\u672a\u751f\u6548\u7684\u5355\u636e\uff01"));
        }
        AssetAmortizeEntity entity = (AssetAmortizeEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), AssetAmortizeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        AssetAmortizeVO vo = (AssetAmortizeVO)((Object)BeanMapper.map((Object)((Object)entity), AssetAmortizeVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> queryDetail(Long id) {
        AssetAmortizeEntity entity = (AssetAmortizeEntity)((Object)this.service.selectById(id));
        AssetAmortizeVO vo = (AssetAmortizeVO)((Object)BeanMapper.map((Object)((Object)entity), AssetAmortizeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetAmortizeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AssetAmortizeVO assetAmortizeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetAmortizeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, AssetAmortizeVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            e.setDependOnProjectName(0 == e.getDependOnProject() ? "\u5426" : "\u662f");
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("AssetAmortize-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAssetAmortizeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeVO>> refAssetAmortizeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetAmortizeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"getAssetAmortizeByProjectOrOrg"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> getAssetAmortizeByProjectOrOrg(Integer dependOnProject, @RequestParam(required=false) Long orgId, @RequestParam(required=false) Long projectId, Long assetAmortizeId) {
        AssetAmortizeVO assetAmortizeVO = new AssetAmortizeVO();
        QueryWrapper query = new QueryWrapper();
        if (1 == dependOnProject) {
            query.eq((Object)"project_id", (Object)projectId);
        } else {
            query.eq((Object)"org_id", (Object)orgId);
        }
        if (null != assetAmortizeId) {
            query.ne((Object)"id", (Object)assetAmortizeId);
        }
        query.orderByDesc((Object)"make_date");
        List billCodeEntityList = this.service.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)billCodeEntityList)) {
            if (0 == ((AssetAmortizeEntity)((Object)billCodeEntityList.get(0))).getBillState()) {
                return CommonResponse.error((String)("\u67e5\u8be2\u5931\u8d25\uff0c\u8be5" + (dependOnProject == 1 ? "\u9879\u76ee" : "\u7ec4\u7ec7") + "\u5df2\u6709\u672a\u751f\u6548\u7684\u5355\u636e\uff01"));
            }
            AssetAmortizeEntity amortizeEntity = (AssetAmortizeEntity)((Object)this.service.selectById(((AssetAmortizeEntity)((Object)billCodeEntityList.get(0))).getId()));
            for (AssetAmortizeDetailEntity detailEntity : amortizeEntity.getDetailList()) {
                detailEntity.setTotalDetailMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getDetailMny(), (BigDecimal)detailEntity.getTotalDetailMny()));
                detailEntity.setDetailMny(BigDecimal.ZERO);
                detailEntity.setRowState("add");
                detailEntity.setAssetAmortizeId(null);
            }
            assetAmortizeVO.setDetailList(BeanMapper.mapList(amortizeEntity.getDetailList(), AssetAmortizeDetailVO.class));
            assetAmortizeVO.setTotalAmortizeMny(ComputeUtil.safeAdd((BigDecimal)amortizeEntity.getAmortizeMny(), (BigDecimal)amortizeEntity.getTotalAmortizeMny()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)assetAmortizeVO));
    }
}

