package com.ejianc.business.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.income.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 签证洽商索赔-清单
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
public class ClaimDetailVo extends BaseVO implements ITreeNodeB {

    private static final long serialVersionUID = 1L;

    /**
     * 清单编号
     */
    @TableField("code")
    private String code;

    /**
     * 签证索赔主键
     */
    @TableField("claim_id")
    private Long claimId;
    /**
     * parent_id
     */
    @TableField("parent_id")
    private Long parentId;

    /**
     * 序号
     */
    @TableField("detail_index")
    private String detailIndex;

    /**
     * 是否末级
     */
    @TableField("leaf_flag")
    private Boolean leafFlag;

    /**
     * 清单名称
     */
    @TableField("name")
    private String name;

    /**
     * 计量单位
     */
    @TableField("unit")
    private String unit;

    /**
     * 发生工程量
     */
    @TableField("occur_num")
    private BigDecimal occurNum;

    /**
     * 发生综合单价
     */
    @TableField("occur_price")
    private BigDecimal occurPrice;

    /**
     * 发生合计
     */
    @TableField("occur_mny")
    private BigDecimal occurMny;

    /**
     * 审核工程量
     */
    @TableField("reply_num")
    private BigDecimal replyNum;

    /**
     * 审核综合单价
     */
    @TableField("reply_price")
    private BigDecimal replyPrice;

    /**
     * 审核合计
     */
    @TableField("reply_mny")
    private BigDecimal replyMny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;
    /**
     * 来源主键（合同清单）
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;
    /**
     * 来源类型，1-引用，2-新增
     */
    @TableField("source_type")
    private Integer sourceType;

    private String tid;
    private String tpid;
    //错误类型
    private String warnType;

    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;

    private String shadowId;
    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getClaimId() {
        return claimId;
    }

    public void setClaimId(Long claimId) {
        this.claimId = claimId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getOccurNum() {
        return occurNum;
    }

    public void setOccurNum(BigDecimal occurNum) {
        this.occurNum = occurNum;
    }
    public BigDecimal getOccurPrice() {
        return occurPrice;
    }

    public void setOccurPrice(BigDecimal occurPrice) {
        this.occurPrice = occurPrice;
    }
    public BigDecimal getOccurMny() {
        return occurMny;
    }

    public void setOccurMny(BigDecimal occurMny) {
        this.occurMny = occurMny;
    }
    public BigDecimal getReplyNum() {
        return replyNum;
    }

    public void setReplyNum(BigDecimal replyNum) {
        this.replyNum = replyNum;
    }
    public BigDecimal getReplyPrice() {
        return replyPrice;
    }

    public void setReplyPrice(BigDecimal replyPrice) {
        this.replyPrice = replyPrice;
    }
    public BigDecimal getReplyMny() {
        return replyMny;
    }

    public void setReplyMny(BigDecimal replyMny) {
        this.replyMny = replyMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
