package com.ejianc.business.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 结算
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("otherSettle")
public class OtherSettleController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOtherContractService  otherContractService;


    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    
    @Autowired
    private IOtherSettleService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherSettleVO> saveOrUpdate(@RequestBody OtherSettleVO saveorUpdateVO) {
        CommonResponse<OtherSettleVO> response = service.saveOrUpdate(saveorUpdateVO);
        return response;
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherSettleVO> queryDetail(Long id) {
        OtherSettleVO vo = service.queryDetail(id);
        return CommonResponse.success(vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherSettleVO> vos) {
        service.removeByIds(vos.stream().map(OtherSettleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OtherSettleVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 结算跳转付款申请制单标识
        boolean payApplyFlagHasFree = param.getParams().containsKey("payApplyFlagHasFree");
        param.getParams().remove("payApplyFlagHasFree");


        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OtherSettleEntity> page = service.queryPage(param,false);
        IPage<OtherSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OtherSettleVO> voList = BeanMapper.mapList(page.getRecords(), OtherSettleVO.class);

  		pageData.setRecords(voList);
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OtherSettleEntity> entityList = service.queryList(param);
        List<OtherSettleVO> list = BeanMapper.mapList(entityList, OtherSettleVO.class);
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OtherSettle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refOtherSettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherSettleVO>> refOtherSettleData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                       @RequestParam(defaultValue = "10") Integer pageSize,
                                                                       @RequestParam(value = "searchText", required = false) String searchText,
                                                                       @RequestParam(value = "condition", required = false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        /** 剩余可申请金额不等于0  */
//        ComplexParam c4 = ParamUtil.getOrParam("surplusApplyMny", new Parameter(QueryParam.NE, 0), new Parameter(QueryParam.EQ, null));
//        queryParam.getComplexParams().add(c4);
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        if(StringUtils.isNotBlank(condition)){
            JSONObject con = JSONObject.parseObject(condition);
            if(condition.contains("contractId")){
                queryParam.getParams().put("contractId",new Parameter(QueryParam.EQ,con.getLong("contractId")));
            }
            if(condition.contains("orgId")){
                queryParam.getParams().put("orgId",new Parameter(QueryParam.EQ,con.getLong("orgId")));
            }
            if(condition.contains("supplierId")){
                queryParam.getParams().put("supplierId",new Parameter(QueryParam.EQ,con.getLong("supplierId")));
            }
        }
        IPage<OtherSettleEntity> pageData = service.queryPage(queryParam,false);
        IPage<OtherSettleVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List<OtherSettleVO> voList = BeanMapper.mapList(pageData.getRecords(), OtherSettleVO.class);
        result.setRecords(voList);
        return CommonResponse.success("参照查询成功！", result);
    }
    /**
     * 结算历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySettleHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleHistoryVo> querySettleHistory(@RequestParam Long id) {
        SettleHistoryVo vo = service.querySettleHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * 根据主键ID,orgId查询累计结算金额，累计冲抵金额,累计付款，累计预付款金额
     * @param
     * @return
     */
    @RequestMapping(value = "/querySumSettlementTaxMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherSettleVO> querySumSettlementTaxMny(@RequestParam Long contractId,@RequestParam Long orgId) {
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        OtherSettleVO vo = new OtherSettleVO();

        BigDecimal sumPayMny = null;
        BigDecimal sumPrePayMny = null;
        vo.setSumPayMny(sumPayMny==null?BigDecimal.ZERO:sumPayMny);
        vo.setSumPrepayMny(sumPrePayMny==null?BigDecimal.ZERO:sumPrePayMny);
        LambdaQueryWrapper<OtherSettleEntity> lambdachange = Wrappers.<OtherSettleEntity>lambdaQuery();
        lambdachange.eq(OtherSettleEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(OtherSettleEntity::getContractId,contractId);
        lambdachange.eq(OtherSettleEntity::getOrgId,orgId);
        lambdachange.in(OtherSettleEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<OtherSettleEntity> list = service.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            final BigDecimal[] alreadyRentMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e-> {
                alreadyRentMoney[0] = alreadyRentMoney[0].add(e.getSettleTaxMny()==null? BigDecimal.ZERO:e.getSettleTaxMny());
                alreadyRentMoney[1] = alreadyRentMoney[1].add(e.getThisOffsetMny()==null? BigDecimal.ZERO:e.getThisOffsetMny());
            });
            //累计结算金额
            vo.setSumSettleTaxMny(alreadyRentMoney[0]);
            //累计冲抵金额
            vo.setSumOffsetMny(alreadyRentMoney[1]);
        }
        BigDecimal sumOffsetMnys = vo.getSumOffsetMny()==null?BigDecimal.ZERO:vo.getSumOffsetMny();
        /*if(vo.getSumPrepayMny().compareTo(BigDecimal.ZERO)>=0&&sumOffsetMnys.compareTo(BigDecimal.ZERO)>=0){
            vo.setSymny(vo.getSumPrepayMny().subtract(sumOffsetMnys));
        }*/
        OtherContractVO otherContractVO = otherContractService.queryDetail(contractId);
        List<OtherContractPayPlanVO> payPlanVos = otherContractVO.getPayPlanVos();
        if (CollectionUtils.isNotEmpty(payPlanVos)){
            for (OtherContractPayPlanVO payPlanVo : payPlanVos) {
                payPlanVo.setName(payPlanVo.getPayPlanName());
                payPlanVo.setScale(payPlanVo.getPayRate());
            }
        }
        vo.setStageList(payPlanVos);
        return CommonResponse.success(vo);
    }

    /**
     *
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

        IPage<OtherSettleEntity> pageData= service.queryPage(param,false);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), OtherSettleVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Description saveOrUpdate 关联保存
     */
    @RequestMapping(value = "/pushToCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherSettleVO> pushToCost(@RequestBody OtherSettleVO otherSettleVO) {
        CommonResponse<OtherSettleVO> response = service.pushToCost(otherSettleVO);
        return response;
    }
    /**
     * @Author mrsir_wxp
     * @Date 2020/6/20 根据合同id和组织id查询直属结算单累计结算金额和
     * @Description calculateAlreadyPurchaseMoney
     * @Param [contractId, orgId]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping("/calculateAlreadyPurchaseMoney")
    @ResponseBody
    public CommonResponse<JSONObject> calculateAlreadyPurchaseMoney(@RequestParam Long contractId,@RequestParam Long orgId){
        if(contractId == null || orgId == null){
            return CommonResponse.error("参数错误！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractId));
//        param.getParams().put("orgId",new Parameter(QueryParam.EQ,orgId));
        param.getOrderMap().put("signDate",QueryParam.DESC);
        param.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<OtherSettleEntity> entities = service.queryList(param,false);
        String lastTime = null;
        final BigDecimal[] alreadyPurchaseMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),
                new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),
                new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)
        };
        if(ListUtil.isNotEmpty(entities)){
            lastTime = DateFormatUtil.formatDate("yyyy-MM-dd",entities.get(0).getSignDate());
            entities.forEach(e-> {
                alreadyPurchaseMoney[0] = alreadyPurchaseMoney[0].add(e.getSettleTaxMny() == null&&!(orgId.equals(e.getOrgId())) ?new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP):e.getSettleTaxMny());
                alreadyPurchaseMoney[1] = alreadyPurchaseMoney[1].add(e.getSettleMny() == null&&!(orgId.equals(e.getOrgId())) ?new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP):e.getSettleMny());
                alreadyPurchaseMoney[2] = alreadyPurchaseMoney[2].add(e.getThisOffsetMny() == null ?new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP):e.getThisOffsetMny());

            });
        }
        JSONObject data = new JSONObject();
        data.put("sumSettleTaxMny",alreadyPurchaseMoney[0].toString());
        data.put("sumSettleMny",alreadyPurchaseMoney[1].toString());
        data.put("sumOffsetMny",alreadyPurchaseMoney[2].toString());
        data.put("lastTime",lastTime);
        return CommonResponse.success(data);
    }
    
    /**
     * 导出清单结算明细
     *
     * @return
     */
    @PostMapping("/settleExcelDownload")
    public void settlementExcelDownload(HttpServletResponse response, @RequestBody OtherSettleVO vo) {
        Map<String, Object> beans = new HashMap<>();
        List<OtherSettleDetailVO> list = service.settlementExcelDownload(vo);
        beans.put("records", list);
        ExcelExport.getInstance().export("otherSettlement-detail-export.xlsx", beans, response);
    }
    
    /**
     * 下载成本科目挂接说明
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDescription", method = RequestMethod.POST)
    @ResponseBody
    public void downloadDescription(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subject-description.xlsx", "成本科目挂接说明");
    }
    
}
