package com.ejianc.business.cost.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.service.IPreBidCostCalcService;

import com.ejianc.framework.core.response.CommonResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

/**
 * 标前测算
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/preBidCostCalc")
public class PreBidCostCalcApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPreBidCostCalcService service;


    @RequestMapping(value = "/updPreBidCostCalc", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updPreBidCostCalc(@RequestParam(value = "preBidCostCalcId") Long preBidCostCalcId,@RequestParam(value = "projectId") Long projectId) {
        LambdaUpdateWrapper<PreBidCostCalcEntity> updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(PreBidCostCalcEntity::getId,preBidCostCalcId);
        updateWrapper.set(PreBidCostCalcEntity::getProjectId,projectId);
        service.update(updateWrapper);
        return CommonResponse.success("更新成功！");
    }


}
