package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.EngdepartRespcostMapper;
import com.ejianc.business.cost.service.IEngdepartRespcostDetailService;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.utils.ProjectUtils;
import com.ejianc.business.cost.vo.EngdepartRespcostDetailVO;
import com.ejianc.business.cost.vo.EngdepartRespcostVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 工程部责任成本
 * 
 * @author generator
 * 
 */
@Service("engdepartRespcostService")
public class EngdepartRespcostServiceImpl extends BaseServiceImpl<EngdepartRespcostMapper, EngdepartRespcostEntity> implements IEngdepartRespcostService{


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEngdepartRespcostDetailService engdepartRespcostDetailService;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private ProjectUtils projectUtils;
    @Autowired
    private IProjectApi projectApi;

    private static final String BILL_CODE = "zydxEngdepartRespcost";//此处需要根据实际修改

    //根据项目项目成本金额校验数据
    @Override
    public void checkAmount(Long projectId, String projectProperty, BigDecimal targetcostTotal){
        PreBidCostCalcEntity preBidCostCalcEntity = preBidCostCalcService.queryDataByProjectId(projectId);
        if(preBidCostCalcEntity==null){
            throw new BusinessException("未获取到该项目标前测算数据，请先完成标前测算");
        }
        BigDecimal costTaxTotal = preBidCostCalcEntity.getCostTaxTotal()!=null ? preBidCostCalcEntity.getCostTaxTotal() : new BigDecimal(0);

        if("子项目".equals(projectProperty)){
            //子项目累计工程部责任成本金额不得超标前测算
            List<Long> projectIds = projectUtils.getProjectList(projectId);
            projectIds.add(projectId);
            if(projectIds!=null && projectIds.size()>0){
                QueryWrapper<EngdepartRespcostEntity> wrapper = new QueryWrapper<>();
                wrapper.in("project_id", projectIds);
                List<EngdepartRespcostEntity> lsit = this.list(wrapper);
                if(lsit!=null && lsit.size()>0){
                    BigDecimal all = targetcostTotal!=null ? targetcostTotal : new BigDecimal(0);
                    for(EngdepartRespcostEntity vo : lsit){
                        if(!vo.getId().equals(projectId)){
                            BigDecimal respcostTotal = vo.getRespcostTotal()!=null ? vo.getRespcostTotal(): new BigDecimal(0);
                            all = all.add(respcostTotal);
                        }else{
                            BigDecimal prjsaleCost = vo.getPrjsaleCost()!=null ? vo.getPrjsaleCost() : new BigDecimal(0);
                            all = all.add(prjsaleCost);
                        }
                    }
                    if(all.compareTo(costTaxTotal)>0){
                        throw new BusinessException("工程部责任成本：子项目累计责任成本总金额【"+all.setScale(2,BigDecimal.ROUND_HALF_UP)+"】不得超标前测算【"+costTaxTotal.setScale(2,BigDecimal.ROUND_HALF_UP)+"】");
                    }
                }
            }
        }else{
            //父项目工程部责任成本金额不得超标前测算
            QueryWrapper<EngdepartRespcostEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("project_id", projectId);
            List<EngdepartRespcostEntity> lsit = this.list(wrapper);
            if(lsit!=null && lsit.size()>0){
                BigDecimal amont = targetcostTotal!=null ? targetcostTotal : new BigDecimal(0);
                EngdepartRespcostEntity entity = lsit.get(0);
                BigDecimal prebidCost = entity.getPrebidCost()!=null ? entity.getPrebidCost(): new BigDecimal(0);
                amont = amont.add(prebidCost);
                if(amont.compareTo(costTaxTotal)>0){
                    throw new BusinessException("工程部责任成本：责任成本总金额【"+amont.setScale(2,BigDecimal.ROUND_HALF_UP)+"】不得超标前测算【"+costTaxTotal.setScale(2,BigDecimal.ROUND_HALF_UP)+"】");
                }
            }
        }
    }

    //根据项目目标成本生成工程部责任成本
    @Override
    public void generate(ProjectTargetcostEntity targetcostEntity) {
        PreBidCostCalcEntity preBidCostCalcEntity = preBidCostCalcService.queryDataByProjectId(targetcostEntity.getProjectId());
        if(preBidCostCalcEntity==null){
            throw new BusinessException("未获取到该项目标前测算数据，请先完成标前测算");
        }
        QueryWrapper<EngdepartRespcostEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("prjcontract_targetcost_id", targetcostEntity.getId());
        EngdepartRespcostEntity entity = this.getOne(wrapper);
        if(entity!=null){
            //存在，修改原先数据值
            entity.setRespcostTotal(targetcostEntity.getTargetcostTotal());
            entity.setPrebidCost(targetcostEntity.getTargetcostTotal());//责任成本总金额 = 项目成本+工程部销售费用,但是【工程部销售费用】为空，所以。。
            entity.setAllocateContractMny(targetcostEntity.getAllocateContractMny());//分配合同额
            QueryWrapper<EngdepartRespcostDetailEntity> detailWrapper = new QueryWrapper<>();
            detailWrapper.eq("respcost_id", entity.getId());
            List<EngdepartRespcostDetailEntity> dList = engdepartRespcostDetailService.list(detailWrapper);
            entity.setEngdepartRespcostDetailList(dList);

            Map<Long,EngdepartRespcostDetailEntity> exitMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(entity.getEngdepartRespcostDetailList())){
                for (EngdepartRespcostDetailEntity engdepartRespcostDetailEntity : entity.getEngdepartRespcostDetailList()) {
                    exitMap.put(engdepartRespcostDetailEntity.getProjectTargetcostDetailId(), engdepartRespcostDetailEntity);
                }
            }

            if (CollectionUtils.isNotEmpty(targetcostEntity.getProjectTargetcostDetailList())) {
                List<EngdepartRespcostDetailEntity> engdepartRespcostDetailList = new ArrayList<>(); // 工程部责任成本明细
                Map<String, Long> map = new HashMap<>();
                List<Long> exitIds = new ArrayList<>();
                for(ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()){
                    exitIds.add(detail.getId());
                    if(exitMap.get(detail.getId())!=null){
                        //修改
                        EngdepartRespcostDetailEntity d = exitMap.get(detail.getId());
                        d.setCode(detail.getCode());
                        d.setAddState(detail.getAddState());
                        d.setCostAmount(detail.getCostAmount());
                        d.setAmount(detail.getAmount());
                        d.setFeeType(detail.getFeeType());
                        d.setSubjectCode(detail.getSubjectCode());
                        d.setSubjectId(detail.getSubjectId());
                        d.setSubjectName(detail.getSubjectName());
                        d.setRowState("edit");
                        map.put(detail.getCode(), d.getId());
                        engdepartRespcostDetailList.add(d);
                    }else{
                        //新增
                        EngdepartRespcostDetailEntity d = new EngdepartRespcostDetailEntity();
                        d.setCode(detail.getCode());
                        d.setAddState(detail.getAddState());
                        d.setCostAmount(detail.getCostAmount());
                        d.setAmount(detail.getAmount());
                        d.setFeeType(detail.getFeeType());
                        d.setProjectTargetcostDetailId(detail.getId());
                        d.setSubjectCode(detail.getSubjectCode());
                        d.setSubjectId(detail.getSubjectId());
                        d.setSubjectName(detail.getSubjectName());
                        d.setRespcostId(entity.getId());
                        d.setRowState("add");
                        d.setId(IdWorker.getId());
                        map.put(detail.getCode(), d.getId());
                        engdepartRespcostDetailList.add(d);
                    }
                }
                if(engdepartRespcostDetailList!=null && engdepartRespcostDetailList.size()>0){
                    engdepartRespcostDetailList.forEach(item -> {
                        if(item.getCode().indexOf(".")!=-1){
                            String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                            item.setPid(map.get(code));
                        }
                    });
                }
                //删除数据
                if(CollectionUtils.isNotEmpty(entity.getEngdepartRespcostDetailList()) && CollectionUtils.isNotEmpty(exitIds)){
                    for (EngdepartRespcostDetailEntity engdepartRespcostDetailEntity : entity.getEngdepartRespcostDetailList()) {
                        if(!exitIds.contains(engdepartRespcostDetailEntity.getProjectTargetcostDetailId())){
                            engdepartRespcostDetailEntity.setRowState("del");
                            engdepartRespcostDetailList.add(engdepartRespcostDetailEntity);
                        }
                    }
                }
                entity.setEngdepartRespcostDetailList(engdepartRespcostDetailList);
            }
        }else{
            entity = BeanMapper.map(targetcostEntity, EngdepartRespcostEntity.class);
            Long id = IdWorker.getId();
            entity.setProjectTargetcostId(targetcostEntity.getId());
            entity.setRespcostTotal(targetcostEntity.getTargetcostTotal());
            entity.setPrebidCost(targetcostEntity.getTargetcostTotal());//责任成本总金额 = 项目成本+工程部销售费用,但是【工程部销售费用】为空，所以。。
            entity.setAllocateContractMny(targetcostEntity.getAllocateContractMny());//分配合同额
            entity.setBillState(0);
            entity.setEstablishmentDate(null);
            entity.setEstablishmentOrgId(null);
            entity.setEstablishmentOrgName(null);
            entity.setEstablishmentUserId(null);
            entity.setEstablishmentUserName(null);
            entity.setRemark(null);
            entity.setId(id);
            entity.setCreateTime(null);
            entity.setCreateUserCode(null);
            entity.setUpdateTime(null);
            entity.setUpdateUserCode(null);
            entity.setVersion(null);
            entity.setSyncEsFlag(null);

            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(entity, EngdepartRespcostVO.class));
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(targetcostEntity.getProjectTargetcostDetailList())) {
                List<EngdepartRespcostDetailEntity> engdepartRespcostDetailList = new ArrayList<>(); // 工程部责任成本明细
                Map<String, Long> map = new HashMap<>();
                for(ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()){
                    EngdepartRespcostDetailEntity d = new EngdepartRespcostDetailEntity();
                    d.setCode(detail.getCode());
                    d.setAddState(detail.getAddState());
                    d.setCostAmount(detail.getCostAmount());
                    d.setAmount(detail.getAmount());
                    d.setFeeType(detail.getFeeType());
                    d.setProjectTargetcostDetailId(detail.getId());
                    d.setSubjectCode(detail.getSubjectCode());
                    d.setSubjectId(detail.getSubjectId());
                    d.setSubjectName(detail.getSubjectName());
                    d.setRespcostId(id);
                    d.setRowState("add");
                    d.setId(IdWorker.getId());
                    map.put(detail.getCode(), d.getId());
                    engdepartRespcostDetailList.add(d);
                }
                if(engdepartRespcostDetailList!=null && engdepartRespcostDetailList.size()>0){
                    engdepartRespcostDetailList.forEach(item -> {
                        if(item.getCode().indexOf(".")!=-1){
                            String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                            item.setPid(map.get(code));
                        }
                    });
                }
                entity.setEngdepartRespcostDetailList(engdepartRespcostDetailList);
            }
        }
        //获取标签测算数据
//        entity.setPrebidCost(preBidCostCalcEntity.getCostTaxTotal());
        this.saveOrUpdate(entity, false);
    }

    @Override
    public JSONObject queryDataByProjectId(Long projectId) {
        JSONObject json = new JSONObject();
        //获取子项目id
        List<Long> projectIds = new ArrayList<>();
        CommonResponse<List<ProjectRegisterVO>> listResponse = projectApi.queryProjectByPid(projectId);
        if(listResponse.isSuccess() && listResponse.getData()!=null && listResponse.getData().size()>0){
            for(ProjectRegisterVO vo : listResponse.getData()){
                projectIds.add(vo.getId());
            }
        }else{
            projectIds.add(projectId);
        }
        //获取项目目标成本
        QueryWrapper<EngdepartRespcostEntity> wrapper = new QueryWrapper<>();
        wrapper.in("project_id", projectIds);
        List<EngdepartRespcostEntity> list = this.list(wrapper);
        List<EngdepartRespcostVO> data = new ArrayList<>();
        List<EngdepartRespcostDetailVO> detailList = new ArrayList<>();
        if(list!=null && list.size()>0){
            data = BeanMapper.mapList(list, EngdepartRespcostVO.class);
            Map<Long, List<EngdepartRespcostDetailEntity>> detailMap = new HashMap<>();
            List<EngdepartRespcostDetailVO> allList = new ArrayList<>();
            List<Long> pids = new ArrayList<>();//保存pid，用于判断该节点是否是叶子节点
            Map<Long,Long> idMap = new HashMap<>();
            Map<Long,Long> subjectIdMap = new HashMap<>();
            Map<Long,List<EngdepartRespcostDetailVO>> subjectMap = new HashMap<>();//存放根据成本id的map数据，用于后面父节点合并，子节点处理
            for(EngdepartRespcostEntity entity : list){
                QueryWrapper<EngdepartRespcostDetailEntity> w = new QueryWrapper<>();
                w.eq("respcost_id", entity.getId());
                List<EngdepartRespcostDetailEntity> dList = engdepartRespcostDetailService.list(w);
                if(dList!=null && dList.size()>0){
                    detailMap.put(entity.getId(), dList);
                    for(EngdepartRespcostDetailEntity de : dList){
                        idMap.put(de.getId(), IdWorker.getId());
                        EngdepartRespcostDetailVO vo = BeanMapper.map(de, EngdepartRespcostDetailVO.class);
                        vo.setProjectId(entity.getProjectId());
                        vo.setProjectName(entity.getProjectName());
                        allList.add(vo);
                        if(de.getPid()!=null && !pids.contains(de.getPid())){
                            pids.add(de.getPid());
                        }
                        if(de.getAddState()!=null && de.getAddState()){
                            //本节点新增的，
                            detailList.add(vo);
                        }else{
                            subjectIdMap.put(de.getSubjectId(), IdWorker.getId());
                            if(subjectMap.get(de.getSubjectId())!=null){
                                List<EngdepartRespcostDetailVO> a = subjectMap.get(de.getSubjectId());
                                a.add(vo);
                                subjectMap.put(de.getSubjectId(), a);
                            }else{
                                List<EngdepartRespcostDetailVO> a = new ArrayList<>();
                                a.add(vo);
                                subjectMap.put(de.getSubjectId(), a);
                            }
                        }
                    }
                }
            }
            //对新id数据进行对照处理---先将所有的成本科目重复的数据进行id的合并，这样会导致叶子节点的数据id重复，但是后面叶子节点的id不从这里取
            for(EngdepartRespcostDetailVO en : allList){
                if(en.getSubjectId()!=null){
                    idMap.put(en.getId(), subjectIdMap.get(en.getSubjectId()));
                }
            }

            //构建子表数据
            //1、获取所有数据
            //2、将数据按照成本档案id进行map结构存储，然后循环遍历，若该成本档案id对应多个，且该数据为父节点，进行合并，若该数据为叶子节点，构建虚拟父级节点，
            for(Long key : subjectMap.keySet()){
                List<EngdepartRespcostDetailVO> subjectList = subjectMap.get(key);
                if(subjectList!=null  && subjectList.size()>0){
                    if(subjectList.size()>1){
                        //存在重复的数据
                        //1、判断该数据是否是父节点，是则合并,并清理
                        Boolean isParent = false;
                        String projectName = "";
                        for(EngdepartRespcostDetailVO entity : subjectList){
                            if(projectName.length()>0){
                                projectName += (","+entity.getProjectName());
                            }else{
                                projectName += (entity.getProjectName());
                            }
                            if(pids.contains(entity.getId())){
                                isParent = true;
                            }
                        }
                        if(isParent){
                            EngdepartRespcostDetailVO vo = BeanMapper.map(subjectList.get(0), EngdepartRespcostDetailVO.class);
                            vo.setProjectName(projectName);
                            vo.setId(idMap.get(vo.getId()));
                            if(vo.getPid()!=null){
                                vo.setPid(idMap.get(vo.getId()));
                            }
                            detailList.add(vo);
                        }else{
                            EngdepartRespcostDetailVO vo1 = BeanMapper.map(subjectList.get(0), EngdepartRespcostDetailVO.class);
                            //生成虚拟节点，
                            Long id = IdWorker.getId();
                            EngdepartRespcostDetailVO d = new EngdepartRespcostDetailVO();
                            d.setAddState(vo1.getAddState());
                            d.setFeeType(vo1.getFeeType());
                            d.setSubjectCode(vo1.getSubjectCode());
                            d.setSubjectId(vo1.getSubjectId());
                            d.setSubjectName(vo1.getSubjectName());
                            d.setProjectName(projectName);
                            d.setPid(idMap.get(vo1.getPid()));
                            d.setId(id);
                            detailList.add(d);
                            for(EngdepartRespcostDetailVO entity : subjectList){
                                EngdepartRespcostDetailVO vo = BeanMapper.map(entity, EngdepartRespcostDetailVO.class);
                                vo.setPid(id);
                                vo.setId(IdWorker.getId());
                                detailList.add(vo);
                            }
                        }
                    }else{
                        //成本档案数据就一条，
                        EngdepartRespcostDetailVO vo = BeanMapper.map(subjectList.get(0), EngdepartRespcostDetailVO.class);
                        if(vo.getPid()!=null){
                            vo.setPid(idMap.get(vo.getPid()));
                        }
                        vo.setId(idMap.get(vo.getId()));
                        detailList.add(vo);
                    }
                }
            }

            //根据pid重新构建innercode
            //1、先排序，顺序：成本档案subjectInnerCode，项目id，id(手动新增的)
            //2、根据pid构建成树，
            //3、根据树生成code,并计算合计值
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(detailList)){
                detailList.sort(Comparator.comparing(EngdepartRespcostDetailVO::getSubjectCode,Comparator.nullsLast(String::compareTo))
                        .thenComparing(EngdepartRespcostDetailVO::getProjectId,Comparator.nullsLast(Long::compare))
                        .thenComparing(EngdepartRespcostDetailVO::getId,Comparator.nullsLast(Long::compare)));

                detailList = createTreeData1(detailList);
                //然后得到的新的数据【树3】，汇总计算值，--并同时计算code值
                for(int i=0; i<detailList.size(); i++){
                    EngdepartRespcostDetailVO vo = detailList.get(i);
                    String code = String.valueOf(i + 1);
                    vo.setCode(code);
                    BigDecimal camount = addAllAmount(vo, code);
                    vo.setAmount(camount);
                }
            }

        }
        json.put("projectList", data);
        json.put("detailList", detailList);
        return json;
    }

    //项目目标成本弃审删除工程部责任成本
    @Override
    public void backData(ProjectTargetcostEntity targetcostEntity) {
        QueryWrapper<EngdepartRespcostEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("prjcontract_targetcost_id", targetcostEntity.getId());
        EngdepartRespcostEntity entity = this.getOne(wrapper);
        if(entity!=null){
            if(entity.getBillState()==0){

                QueryWrapper<EngdepartRespcostDetailEntity> detailWrapper = new QueryWrapper<>();
                detailWrapper.eq("respcost_id", entity.getId());
                engdepartRespcostDetailService.remove(detailWrapper);

                this.removeById(entity.getId());
            }else{
                throw new BusinessException("该单据生成的工程部责任成本且已提交，不允许弃审");
            }
        }
    }

    @Override
    public EngdepartRespcostVO queryDetailByProjectId(Long projectId) {
        LambdaQueryWrapper<EngdepartRespcostEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(EngdepartRespcostEntity::getProjectId,projectId)
                .eq(EngdepartRespcostEntity::getDr,0)
                .in(EngdepartRespcostEntity::getBillState,Arrays.asList(1,3))
                .orderByDesc(EngdepartRespcostEntity::getCreateTime)
                .last("limit 1");
        List<EngdepartRespcostEntity> list = super.list(lambdaQueryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return BeanMapper.map(list.get(0),EngdepartRespcostVO.class);
    }

    public List<EngdepartRespcostDetailVO> createTreeData1(List<EngdepartRespcostDetailVO> list) {
        List<EngdepartRespcostDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, EngdepartRespcostDetailVO> listMap = new HashMap<>();
        for(EngdepartRespcostDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            EngdepartRespcostDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            EngdepartRespcostDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<EngdepartRespcostDetailVO> child = (List<EngdepartRespcostDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<EngdepartRespcostDetailVO> children = new ArrayList<EngdepartRespcostDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private BigDecimal addAllAmount(EngdepartRespcostDetailVO vo, String pcode){
        BigDecimal amount = vo.getAmount()!=null ? vo.getAmount() : new BigDecimal(0);
        if(vo.getChildren()!=null && vo.getChildren().size()>0){
            vo.setProjectId(null);
//            vo.setProjectName(null);
            amount = new BigDecimal(0);
            for(int i=0; i<vo.getChildren().size(); i++){
                EngdepartRespcostDetailVO c = vo.getChildren().get(i);
                String code = null;
                if(StringUtils.isNotBlank(pcode)){
                    code = pcode +"." + (i+1);
                }else{
                    code = String.valueOf(i+1);
                }
                c.setCode(code);
                BigDecimal camount = addAllAmount(c, code);
                amount = amount.add(camount);
            }
            vo.setAmount(amount);
        }
        return amount;
    }
}
