package com.ejianc.business.income.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.vo.report.*;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

@Mapper
public interface ReportMapper extends BaseCrudMapper<ContractEntity> {
    List<ReportVo> getFinance(@Param("tenantId") Long tenantId,
                              @Param("endTime") String endTime,
                              @Param("projectManager") String projectManager,
                              @Param("engineeringType") String engineeringType,
                              @Param("text") String text,
                              @Param("orgids") List<Long> orgids);

    List<ReportSumVo> getProductionMny(@Param("contractIds") Set<Long> contractIds,
                                       @Param("endTime") String endTime);

    List<ReportSumVo> getQuoteMny(@Param("contractIds") Set<Long> contractIds,
                                  @Param("endTime") String endTime);

    List<ReportMonthVo> getProjectMonth(@Param("tenantId") Long tenantId,
                                        @Param("projectManager") String projectManager,
                                        @Param("engineeringType") String engineeringType,
                                        @Param("text") String text,
                                        @Param("orgids") List<Long> orgids);

    List<ReportSumVo> getProductionAndCost(@Param("lastTime") String lastTime,
                                           @Param("lastDay") Integer lastDay,
                                           @Param("contractIds") List<Long> contractIds);

    List<ReportSumVo> getReceive(@Param("tenantId") Long tenantId,
                                 @Param("lastTime") String lastTime,
                                 @Param("lastDay") Integer lastDay,
                                 @Param("contractIds") List<Long> contractIds);

    ProjectReportVo getDate(@Param("projectId") Long projectId, @Param("lastDay") Integer lastDay);

    List<ProjectReportVo> getMonthProductionMny(@Param("projectId") Long projectId, @Param("lastDay") Integer lastDay);

    List<ProjectReportVo> getMonthProduction(@Param("projectId") Long projectId);

    List<ProjectMnyVO> queryProjectMnyList(Page<ProjectMnyVO> page,@Param(Constants.WRAPPER) QueryWrapper wrapper);
}
