package com.ejianc.business.sub.vo;

import com.ejianc.business.sub.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 过程结算明细表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public class SubSettleDetailVO extends BaseVO implements ITreeNodeB {

    private static final long serialVersionUID = 1L;

    /**
     * 结算ID
     */
    private Long settleId;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 合同明细ID
     */
    private Long contractDetailId;

    /**
     * 序号
     */
    private String treeIndex;

    /**
     * 清单编码
     */
    private String code;

    /**
     * 清单名称
     */
    private String name;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 工程量
     */
    private BigDecimal num;

    /**
     * 综合单价
     */
    private BigDecimal price;

    /**
     * 本期结算工程量
     */
    private BigDecimal settleNum;

    /**
     * 本期结算金额
     */
    private BigDecimal settleMny;

    /**
     * 来源类型(1:合同内，2:合同外)
     */
    private Integer sourceType;

    /**
     * 备注
     */
    private String memo;

    /**
     * 父ID
     */
    private Long parentId;

    /**
     * 是否末级
     */
    private Boolean leafFlag;

    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    private List<ITreeNodeB> children;
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;
    private String shadowId;


    /**
     * 成本科目主键
     */
    private Long subjectId;
    /**
     * 成本科目名称
     */
    private String subjectName;

    /**
     * 成本科目----正元的
     */
    private Long costCategory;

    private BigDecimal sumSettleNum; // 累计结算工程量 (不含本期)
    private BigDecimal sumSettleNumEndthis; // 累计结算工程量 (含本期)

    private BigDecimal settleNumSum;// 临时字段 总工程量
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date settleCreateTime; //临时字段 主表单据创建时间

    private String spec;//特征

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public BigDecimal getSumSettleNum() {
        return sumSettleNum;
    }

    public void setSumSettleNum(BigDecimal sumSettleNum) {
        this.sumSettleNum = sumSettleNum;
    }

    public BigDecimal getSumSettleNumEndthis() {
        return sumSettleNumEndthis;
    }

    public void setSumSettleNumEndthis(BigDecimal sumSettleNumEndthis) {
        this.sumSettleNumEndthis = sumSettleNumEndthis;
    }

    public BigDecimal getSettleNumSum() {
        return settleNumSum;
    }

    public void setSettleNumSum(BigDecimal settleNumSum) {
        this.settleNumSum = settleNumSum;
    }

    public Date getSettleCreateTime() {
        return settleCreateTime;
    }

    public void setSettleCreateTime(Date settleCreateTime) {
        this.settleCreateTime = settleCreateTime;
    }

    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }


    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnit() {
        return unit;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getSettleNum() {
        return settleNum;
    }

    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;

    }

    @ReferSerialTransfer(referCode = "zydx-subject-org")
    public Long getCostCategory() {
        return costCategory;
    }

    @ReferDeserialTransfer
    public void setCostCategory(Long costCategory) {
        this.costCategory = costCategory;
    }
}
