package com.ejianc.business.zyportal.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.zyportal.mapper.ZyPortalMapper;
import com.ejianc.business.zyportal.service.IZyPortalService;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.zyportal.vo.PortalVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;

/**
 *
 * 
 * @author generator
 * 
 */
@Service("zyPortalService")
public class ZyPortalServiceImpl implements IZyPortalService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${database.dbtype:mysql}")
    private String dbType;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ZyPortalMapper zyPortalMapper;

    //获取项目情况
    @Override
    public JSONObject getProjectInfo() {
        JSONObject result = new JSONObject();
        //获取项目情况
        List<Long> orgIdList = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        //1、获取本年新增的项目数量
        Map<String,Object> params = new HashMap<>();
        params.put("orgIdList", orgIdList);
        params.put("thisYear", "thisYear");
        params.put("dbType", dbType);
        Integer thisYearProjectNum = zyPortalMapper.getProjectNum(params);
        result.put("thisYearProjectNum", thisYearProjectNum);
        //2、获取未开工的项目数量
        Map<String,Object> params2 = new HashMap<>();
        params2.put("orgIdList", orgIdList);
        params2.put("status", "1");
        params2.put("dbType", dbType);
        Integer notStartedProjectNum = zyPortalMapper.getProjectNum(params2);
        result.put("notStartedProjectNum", notStartedProjectNum);
        //3、获取在建的项目数量
        Map<String,Object> params3 = new HashMap<>();
        params3.put("orgIdList", orgIdList);
        params3.put("status", "2");
        params3.put("dbType", dbType);
        Integer buildProjectNum = zyPortalMapper.getProjectNum(params3);
        result.put("buildProjectNum", buildProjectNum);
        //4、获取待验收的项目数量
        Map<String,Object> params4 = new HashMap<>();
        params4.put("orgIdList", orgIdList);
        params4.put("status", "5");
        params4.put("dbType", dbType);
        Integer acceptanceProjectNum = zyPortalMapper.getProjectNum(params4);
        result.put("acceptanceProjectNum", acceptanceProjectNum);
        //5、获取完工的项目数量
        Map<String,Object> params5 = new HashMap<>();
        params5.put("orgIdList", orgIdList);
        params5.put("status", "3");
        params5.put("dbType", dbType);
        Integer finishProjectNum = zyPortalMapper.getProjectNum(params5);
        result.put("finishProjectNum", finishProjectNum);
        //6、获取停工的项目数量
        Map<String,Object> params6 = new HashMap<>();
        params6.put("orgIdList", orgIdList);
        params6.put("status", "4");
        params6.put("dbType", dbType);
        Integer stopProjectNum = zyPortalMapper.getProjectNum(params6);
        result.put("stopProjectNum", stopProjectNum);
        //7、获取全部的项目数量
        Map<String,Object> params7 = new HashMap<>();
        params7.put("orgIdList", orgIdList);
        params7.put("status", "5");
        params7.put("dbType", dbType);
        Integer allProjectNum = zyPortalMapper.getProjectNum(params7);
        result.put("allProjectNum", allProjectNum);
        return result;
    }

    //产能统计
    @Override
    public JSONObject getProductionCapacity() {
        /**
         *
         * 产能统计：作用--统计近6个月产值报量数据
            单位：取集团及其下的直属分子公司级别组织 ， 注意：第一个数据是整个公司的总体数据
            月份：取当前月的上一个月开始的近6个月，比如当前月12月，那就列出近6、7、8、9、10、11这六个月份； 能不能跟当前日期比对，当前日期大于25日，就从当前月计算，当前日期25日以前，从上一个月开始？？
            数据：统计组织下所有项目，产值时间在对应月份，本期完成产值累计值
         *
         * */
        Map<Long, Map<String, BigDecimal>> resultMap = new HashMap<>();

        //获取分子公司
        LinkedHashMap<Long, OrgVO> orgMap = this.getOrgMap(true);

        List<Long> orgIdsList = new ArrayList<>();
        if(orgMap!=null && orgMap.size()>0){
            for (Long aLong : orgMap.keySet()) {
                orgIdsList.add(aLong);
                resultMap.put(aLong, new HashMap<>());
            }
        }
        //获取月份
        LocalDate today = LocalDate.now();
        List<String> monthList = new ArrayList<>();
        List<String> monthSqlList = new ArrayList<>();
        String beginTime = "";
        String endTime = "";
        for (int i = 6; i > 0; i--) {
            LocalDate month = today.minusMonths(i);
            monthList.add(month.format(DateTimeFormatter.ofPattern("MM")));
            monthSqlList.add(month.format(DateTimeFormatter.ofPattern("yyyy-MM")));
        }
        int dayOfMonth = today.getDayOfMonth();
        if (dayOfMonth >= 25) {
            //当前日期大于25号
            monthList.remove(0);
            String currentMonthStr = today.format(DateTimeFormatter.ofPattern("MM"));
            monthList.add(currentMonthStr);

            monthSqlList.remove(0);
            String currentMonthStr1 = today.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            monthSqlList.add(currentMonthStr1);

            LocalDate nextMonth = today.minusMonths(-1);
            String nextMonthStr = nextMonth.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            endTime = nextMonthStr + "-01 00:00:00";
        }else{
            String currentMonthStr1 = today.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            endTime = currentMonthStr1 + "-01 00:00:00";
        }
        beginTime = monthSqlList.get(0) + "-01 00:00:00";

        LinkedList<String> legendData = new LinkedList<>();
        for (String month : monthList) {
            legendData.add(month);
        }
        //初始化数据
        for (Long orgId : resultMap.keySet()) {
            Map<String, BigDecimal> v = new HashMap<>();
            for (String month : monthSqlList) {
                v.put(month, new BigDecimal(0));
            }
            resultMap.put(orgId, v);
        }
        List<Long> orgIds = new ArrayList<Long>();
        Map<Long,String> innerCodeMap = new LinkedHashMap<>();
        CommonResponse<List<OrgVO>> orgResponse= orgApi.findChildrenByParentIds(orgIdsList);
        if (orgResponse.isSuccess()){
            for (OrgVO vo:orgResponse.getData()){
                orgIds.add(vo.getId());
                innerCodeMap.put(vo.getId(),vo.getInnerCode());
            }
        }

        Map<String,Object> paramEfficiency = new HashMap<>();
        paramEfficiency.put("tenantId", InvocationInfoProxy.getTenantid());
        paramEfficiency.put("beginTime",beginTime);
        paramEfficiency.put("endTime",endTime);
        paramEfficiency.put("orgIds",orgIds);
        paramEfficiency.put("dbType", dbType);
        List<ProductionEntity> productionList = zyPortalMapper.getProductionCapacity(paramEfficiency);

        for (ProductionEntity vo : productionList){
            if(vo.getFinishTaxMny()==null){
                continue;
            }
            if(innerCodeMap.containsKey(vo.getOrgId())){
                String innerCode =innerCodeMap.get(vo.getOrgId());
                for (Long orgId : resultMap.keySet()) {
                    if(innerCode.contains(orgId+"")){
                        Map<String, BigDecimal> m = resultMap.get(orgId);
                        for (String month : m.keySet()) {
                            BigDecimal va = m.get(month);
                            if(vo.getBillCode().equals(month)){
                                va = va.add(vo.getFinishTaxMny());
                                m.put(month, va);
                            }
                        }
                    }
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray data = new JSONArray();
        for (Long orgId : resultMap.keySet()) {
            String orgName = orgMap.get(orgId).getName();
            com.alibaba.fastjson.JSONObject dataJson = new com.alibaba.fastjson.JSONObject();
            dataJson.put("name",orgName);
            dataJson.put("data",resultMap.get(orgId).entrySet());
            data.add(dataJson);
        }
        jsonObject.put("data",data);
        jsonObject.put("legendData",legendData);
        return null;
    }

    @Override
    public JSONObject getBusinessSegment() {
        Map<Long, List<Long>> defMap = new HashMap<>();
        Map<Long, DefdocDetailVO> defDetailMap = new HashMap<>();
        Map<Long, Long> childParentMap = new HashMap<>();
        this.getBusinessSegmentDefdoc(defMap, defDetailMap, childParentMap);
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> orgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            orgIds.add(org.getId());
        });

        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("orgIds",orgIds);
        List<PortalVO> list = zyPortalMapper.getBusinessSegment(params);

        Map<Long, PortalVO> reMap = new HashMap<>();
        //初始化数据
        for (Long defId : defMap.keySet()) {
            PortalVO vo = new PortalVO();
            vo.setContractMny(new BigDecimal(0));
            vo.setNum(0);
            reMap.put(defId, vo);
        }
        //加载数据
        for (PortalVO portalVO : list) {
            Long pDefId = childParentMap.get(portalVO.getId());
            PortalVO vo = reMap.get(pDefId);
            Integer num = (vo.getNum()!=null?vo.getNum():0)+(portalVO.getNum()!=null?portalVO.getNum():0);
            vo.setNum(num);
            if(vo.getContractMny()!=null){
                BigDecimal con = portalVO.getContractMny()!=null?portalVO.getContractMny():new BigDecimal(0);
                con = con.add(vo.getContractMny());
                vo.setContractMny(con);
            }else{
                BigDecimal con = portalVO.getContractMny()!=null?portalVO.getContractMny():new BigDecimal(0);
                vo.setContractMny(con);
            }
        }
        JSONArray numResult = new JSONArray();
        JSONArray moneyResult = new JSONArray();
        for (Long defId : reMap.keySet()) {
            JSONObject num = new JSONObject();
            num.put("name", defDetailMap.get(defId).getName());
            num.put("value", reMap.get(defId).getNum());
            numResult.add(num);
            JSONObject money = new JSONObject();
            money.put("name", defDetailMap.get(defId).getName());
            money.put("value", reMap.get(defId).getContractMny());
            moneyResult.add(money);
        }
        JSONObject re = new JSONObject();
        re.put("numData", numResult);
        re.put("contractMnyData", moneyResult);
        return null;
    }

    @Override
    public JSONObject getCompanyProjectInfo() {
        //获取分子公司
        LinkedHashMap<Long, OrgVO> orgMap = this.getOrgMap(false);
        Map<Long, Integer> numMap = new HashMap<>();
        Map<Long, BigDecimal> moneyMap = new HashMap<>();

        List<Long> orgIdsList = new ArrayList<>();
        if(orgMap!=null && orgMap.size()>0){
            for (Long aLong : orgMap.keySet()) {
                orgIdsList.add(aLong);
                numMap.put(aLong, 0);
                moneyMap.put(aLong, new BigDecimal(0));
            }
        }
        List<Long> orgIds = new ArrayList<Long>();
        Map<Long,String> innerCodeMap = new LinkedHashMap<>();
        CommonResponse<List<OrgVO>> orgResponse= orgApi.findChildrenByParentIds(orgIdsList);
        if (orgResponse.isSuccess()){
            for (OrgVO vo:orgResponse.getData()){
                orgIds.add(vo.getId());
                innerCodeMap.put(vo.getId(),vo.getInnerCode());
            }
        }
        Map<String,Object> paramEfficiency = new HashMap<>();
        paramEfficiency.put("tenantId", InvocationInfoProxy.getTenantid());
        paramEfficiency.put("orgIds",orgIds);
        List<PortalVO> productionList = zyPortalMapper.getCompanyProjectInfo(paramEfficiency);

        for (PortalVO vo : productionList){
            if(innerCodeMap.containsKey(vo.getOrgId())){
                String innerCode =innerCodeMap.get(vo.getOrgId());
                for (Long orgId : numMap.keySet()) {
                    if(innerCode.contains(orgId+"")){
                        Integer m = numMap.get(orgId);
                        m += (vo.getNum()!=null?vo.getNum():0);
                        numMap.put(orgId, m);

                        BigDecimal money = moneyMap.get(orgId);
                        if(vo.getContractMny()!=null){
                            money = money.add(vo.getContractMny());
                        }
                        moneyMap.put(orgId, money);
                    }
                }
            }
        }

        JSONObject re = new JSONObject();
        LinkedList<String> legendData = new LinkedList<>();
        LinkedList<Integer> numData = new LinkedList<>();
        LinkedList<BigDecimal> contractMnyData = new LinkedList<>();
        for (Long orgId : numMap.keySet()) {
            legendData.add(orgMap.get(orgId).getName());
            numData.add(numMap.get(orgId));
            contractMnyData.add(moneyMap.get(orgId));
        }
        re.put("legendData", legendData);
        re.put("numData", numData);
        re.put("contractMnyData", contractMnyData);
        return re;
    }

    @Override
    public JSONObject getProjectMoneyInterval() {
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> orgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            orgIds.add(org.getId());
        });

        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("orgIds",orgIds);
        PortalVO vo = zyPortalMapper.getProjectMoneyInterval(params);

        LinkedList<String> legendData = new LinkedList<>();
        LinkedList<Integer> numData = new LinkedList<>();
        legendData.push("300万以下");
        numData.push(vo.getNum1()!=null?vo.getNum1():0);
        legendData.push("300-500万");
        numData.push(vo.getNum2()!=null?vo.getNum2():0);
        legendData.push("500-1000万");
        numData.push(vo.getNum3()!=null?vo.getNum3():0);
        legendData.push("1000万以上");
        numData.push(vo.getNum4()!=null?vo.getNum4():0);

        JSONObject re = new JSONObject();
        re.put("legendData", legendData);
        re.put("numData", numData);
        return re;
    }

    @Override
    public JSONObject getProjectProfitMarginInterval() {
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> orgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            orgIds.add(org.getId());
        });

        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("orgIds",orgIds);
        PortalVO vo = zyPortalMapper.getProjectProfitMarginInterval(params);

        LinkedList<String> legendData = new LinkedList<>();
        LinkedList<Integer> numData = new LinkedList<>();
        legendData.push("20%万以下");
        numData.push(vo.getNum1()!=null?vo.getNum1():0);
        legendData.push("20%-30%万");
        numData.push(vo.getNum2()!=null?vo.getNum2():0);
        legendData.push("30%-40%万");
        numData.push(vo.getNum3()!=null?vo.getNum3():0);
        legendData.push("40%万以上");
        numData.push(vo.getNum4()!=null?vo.getNum4():0);

        JSONObject re = new JSONObject();
        re.put("legendData", legendData);
        re.put("numData", numData);
        return re;
    }

    //项目进度分析
    @Override
    public JSONObject getProjectProcess() {
        /**
         * 正常项目：当前产值进度-工期进度≥-10
         * 滞后项目：-10>当前产值进度-工期进度≥-20
         * 严重滞后：当前产值进度-工期进度＜-20
         * 当前产值进度：产值上报中的 累计产值进度
         * 工期进度：统计项目状态为未开工、在建状态、待验收（当前日期-项目立项里项目开工日期+1）/（项目开工日期-项目竣工日期+1）
         * 完工状态：【项目完工考核】单据的创建日期-项目立项里项目开工日期+1）/（项目开工日期-项目竣工日期+1），如果没有创建项目完工考核则取当前日期
        **/
        List<Long> orgIds = new ArrayList<Long>();
        Map<Long,String> innerCodeMap = new LinkedHashMap<>();
        CommonResponse<List<OrgVO>> orgResponse= orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (orgResponse.isSuccess()){
            for (OrgVO vo:orgResponse.getData()){
                orgIds.add(vo.getId());
                innerCodeMap.put(vo.getId(),vo.getInnerCode());
            }
        }

        //获取当前产值进度数据
        Map<String,Object> outputValueProgressParams = new HashMap<>();
        outputValueProgressParams.put("tenantId", InvocationInfoProxy.getTenantid());
        outputValueProgressParams.put("orgIds",orgIds);
        List<ProductionEntity> productionList = zyPortalMapper.getOutputValueProgress(outputValueProgressParams);
        Map<Long, ProductionEntity> productionMap = new HashMap<>();
        if(productionList!=null && productionList.size()>0){
            for (ProductionEntity productionEntity : productionList) {
                productionMap.put(productionEntity.getProjectId(), productionEntity);
            }
        }

        Map<String,Object> projectParams = new HashMap<>();
        projectParams.put("tenantId", InvocationInfoProxy.getTenantid());
        projectParams.put("orgIds",orgIds);
        List<ProjectRegisterVO> projectList = zyPortalMapper.getProjectList(projectParams);

        Map<String,Object> completionAssessmentParams = new HashMap<>();
        completionAssessmentParams.put("tenantId", InvocationInfoProxy.getTenantid());
        completionAssessmentParams.put("orgIds",orgIds);
        List<PortalVO> completionAssessmentList = zyPortalMapper.getCompletionAssessment(completionAssessmentParams);
        Map<Long, PortalVO> completionAssessmentMap = new HashMap<>();
        if(completionAssessmentList!=null && completionAssessmentList.size()>0){
            for (PortalVO vo : completionAssessmentList) {
                completionAssessmentMap.put(vo.getId(), vo);
            }
        }

        //获取分子公司
        LinkedHashMap<Long, OrgVO> orgMap = this.getOrgMap(true);

        LinkedHashMap<Long, Integer> normalProject = new LinkedHashMap<>();//正常项目
        LinkedHashMap<Long, Integer> lagProject = new LinkedHashMap<>();//滞后项目
        LinkedHashMap<Long, Integer> seriouslyLagProject = new LinkedHashMap<>();//严重滞后

        LinkedList<Long> orgIdsList = new LinkedList<>();
        LinkedList<String> legendData = new LinkedList<>();//所属公司
        if(orgMap!=null && orgMap.size()>0){
            for (Long aLong : orgMap.keySet()) {
                orgIdsList.add(aLong);
                String orgName = orgMap.get(aLong).getName();
                legendData.add(orgName);
                normalProject.put(aLong, 0);
                lagProject.put(aLong, 0);
                seriouslyLagProject.put(aLong, 0);
            }
        }
        if(projectList!=null && projectList.size()>0){
            for (ProjectRegisterVO pvo : projectList) {
                /**
                * 未开工： 1
                 * 在建：2
                 * 完工：3
                 * 停工：4
                 * 待验收： 5
                * */
                BigDecimal durationProcess = new BigDecimal(0);//工期进度
//                统计项目状态为未开工、在建状态、待验收（当前日期-项目立项里项目开工日期+1）/（项目开工日期-项目竣工日期+1）
                if(StringUtils.isBlank(pvo.getStatus()) || "1".equals(pvo.getStatus()) || "2".equals(pvo.getStatus())
                        || "5".equals(pvo.getStatus()) || "4".equals(pvo.getStatus())){
                    if(pvo.getStartDate()!=null && pvo.getFinishDate()!=null){
                        Date date = new Date();
                        LocalDate newDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        LocalDate startDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        LocalDate finishDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

                        Long a = ChronoUnit.DAYS.between(startDate, newDate) + 1;
                        Long b = ChronoUnit.DAYS.between(startDate, finishDate) + 1;
                        durationProcess = BigDecimal.valueOf(a / b * 100, 4);
                    }
                }else if("3".equals(pvo.getStatus())){
                    if(pvo.getStartDate()!=null && pvo.getFinishDate()!=null){
                        Date date = new Date();
                        LocalDate newDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        LocalDate startDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        LocalDate finishDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        if(completionAssessmentMap.get(pvo.getId())!=null){
                            LocalDate createTime = completionAssessmentMap.get(pvo.getId()).getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                            Long a = ChronoUnit.DAYS.between(startDate, createTime) + 1;
                            Long b = ChronoUnit.DAYS.between(startDate, finishDate) + 1;
                            durationProcess = BigDecimal.valueOf(a / b * 100, 4);
                        }else{
                            Long a = ChronoUnit.DAYS.between(startDate, newDate) + 1;
                            Long b = ChronoUnit.DAYS.between(startDate, finishDate) + 1;
                            durationProcess = BigDecimal.valueOf(a / b * 100, 4);
                        }
                    }
                }
                //当前产值进度
                BigDecimal progressValue = new BigDecimal(0);
                if(productionMap.get(pvo.getId())!=null){
                    if(productionMap.get(pvo.getId()).getSumImageProgressHaveThis()!=null){
                        progressValue = productionMap.get(pvo.getId()).getSumImageProgressHaveThis();
                    }
                }
                BigDecimal re = progressValue.subtract(durationProcess);

                if(innerCodeMap.containsKey(pvo.getProjectDepartmentId())){
                    String innerCode =innerCodeMap.get(pvo.getProjectDepartmentId());
                    for (Long orgId : orgMap.keySet()) {
                        if(innerCode.contains(orgId+"")){
                            if(re.compareTo(new BigDecimal(-10))>=0){
                                //正常项目
                                Integer n = normalProject.get(orgId);
                                n++;
                                normalProject.put(orgId, n);
                            }else if(re.compareTo(new BigDecimal(-20))>=0){
                                //滞后项目
                                Integer n = lagProject.get(orgId);
                                n++;
                                lagProject.put(orgId, n);
                            }else{
                                //严重滞后
                                Integer n = seriouslyLagProject.get(orgId);
                                n++;
                                seriouslyLagProject.put(orgId, n);
                            }

                        }
                    }
                }
            }
        }

        JSONObject jsonObject = new JSONObject();
        JSONArray data = new JSONArray();

        JSONObject normalJson = new JSONObject();
        normalJson.put("name","正常项目");
        normalJson.put("data",normalProject.entrySet());
        data.add(normalJson);

        JSONObject lagJson = new JSONObject();
        lagJson.put("name","滞后项目");
        lagJson.put("data",lagProject.entrySet());
        data.add(lagJson);

        JSONObject seriouslyLagJson = new JSONObject();
        seriouslyLagJson.put("name","严重滞后");
        seriouslyLagJson.put("data",seriouslyLagProject.entrySet());
        data.add(seriouslyLagJson);
        jsonObject.put("ladyList",data);
        jsonObject.put("legendData",legendData);
        return jsonObject;
    }

    @Override
    public JSONObject getCostStructure() {
        /**
        * 取项目目标成本里： 按照成本科目对应费用类别进行统计，统计目标成本中，子表科目金额；
         * 字段显示对照   人工费:直接人工费   材料费:材料费支出  设备费：设备使用费 外协费用;外协费用  其他直接费：其他直接费
        * */

        List<Long> orgIds = new ArrayList<Long>();
        Map<Long,String> innerCodeMap = new LinkedHashMap<>();
        CommonResponse<List<OrgVO>> orgResponse= orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (orgResponse.isSuccess()){
            for (OrgVO vo:orgResponse.getData()){
                orgIds.add(vo.getId());
                innerCodeMap.put(vo.getId(),vo.getInnerCode());
            }
        }

        //获取当前产值进度数据
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("orgIds",orgIds);
        List<PortalVO> costStructureList = zyPortalMapper.getCostStructure(params);
        Map<String, BigDecimal> map = new HashMap<>();
        if(costStructureList!=null && costStructureList.size()>0){
            for (PortalVO portalVO : costStructureList) {
                map.put(portalVO.getName(), portalVO.getContractMny());
            }
        }
        JSONObject re = new JSONObject();
        JSONArray list = new JSONArray();

        JSONObject rgf = new JSONObject();
        rgf.put("name", "人工费");
        rgf.put("value", map.get("rgf")!=null?map.get("rgf"):0);
        list.add(rgf);
        JSONObject clf = new JSONObject();
        clf.put("name", "材料费");
        clf.put("value", map.get("clf")!=null?map.get("clf"):0);
        list.add(clf);
        JSONObject sbf = new JSONObject();
        sbf.put("name", "设备费");
        sbf.put("value", map.get("sbf")!=null?map.get("sbf"):0);
        list.add(sbf);
        JSONObject qtzjfy = new JSONObject();
        qtzjfy.put("name", "其他直接费");
        qtzjfy.put("value", map.get("qtzjfy")!=null?map.get("qtzjfy"):0);
        list.add(qtzjfy);
        JSONObject wxfy = new JSONObject();
        wxfy.put("name", "外协费用");
        wxfy.put("value", map.get("wxfy")!=null?map.get("wxfy"):0);
        list.add(wxfy);
        re.put("data", re);
        return re;
    }

    @Override
    public JSONObject getProcessCost() {
        /**
        * 项目金额：项目立项里的 合同额 字段
         * 造价成本：合同造价表里的 造价金额 字段
         * 实际成本：取 已生效的结算管理结算单金额，其中劳务合同如果有完工结算取完工结算，没有完工结算取过程结算。  其他成本待数据同步过来之后统计
         * 成本进度： 实际成本/造价成本  （波浪线）
         * 工期进度：（当前日期-项目立项里项目开工日期+1）/（项目开工日期-项目竣工日期+1）（波浪线）  取所有项目平均值
        * */
        //获取分子公司
        LinkedHashMap<Long, OrgVO> orgMap = this.getOrgMap(false);
        Map<Long, BigDecimal> moneyMap = new HashMap<>();//项目金额
        Map<Long, BigDecimal> constructionCostMap = new HashMap<>();//造价成本
        Map<Long, BigDecimal> actualCostMap = new HashMap<>();//实际成本
        Map<Long, BigDecimal> costProcessMap = new HashMap<>();//成本进度
        Map<Long, BigDecimal> durationMap = new HashMap<>();//工期进度
        Map<Long, Integer> pnumMap = new HashMap<>();//项目数量

        List<Long> orgIdsList = new ArrayList<>();
        if(orgMap!=null && orgMap.size()>0){
            for (Long aLong : orgMap.keySet()) {
                orgIdsList.add(aLong);
                moneyMap.put(aLong, new BigDecimal(0));
                constructionCostMap.put(aLong, new BigDecimal(0));
                actualCostMap.put(aLong, new BigDecimal(0));
                costProcessMap.put(aLong, new BigDecimal(0));
                durationMap.put(aLong, new BigDecimal(0));
                pnumMap.put(aLong, 0);
            }
        }
        List<Long> orgIds = new ArrayList<Long>();
        Map<Long,String> innerCodeMap = new LinkedHashMap<>();
        CommonResponse<List<OrgVO>> orgResponse= orgApi.findChildrenByParentIds(orgIdsList);
        if (orgResponse.isSuccess()){
            for (OrgVO vo:orgResponse.getData()){
                orgIds.add(vo.getId());
                innerCodeMap.put(vo.getId(),vo.getInnerCode());
            }
        }
        //项目金额
        Map<String,Object> projectMoneyParams = new HashMap<>();
        projectMoneyParams.put("tenantId", InvocationInfoProxy.getTenantid());
        projectMoneyParams.put("orgIds",orgIds);
        List<PortalVO> projectMoneyList = zyPortalMapper.getCompanyProjectInfo(projectMoneyParams);
        for (PortalVO vo : projectMoneyList){
            if(innerCodeMap.containsKey(vo.getOrgId())){
                String innerCode =innerCodeMap.get(vo.getOrgId());
                for (Long orgId : moneyMap.keySet()) {
                    if(innerCode.contains(orgId+"")){
                        BigDecimal money = moneyMap.get(orgId);
                        if(vo.getContractMny()!=null){
                            money = money.add(vo.getContractMny());
                        }
                        moneyMap.put(orgId, money);
                    }
                }
            }
        }

        //造价成本
        Map<String,Object> constructionCostParams = new HashMap<>();
        constructionCostParams.put("tenantId", InvocationInfoProxy.getTenantid());
        constructionCostParams.put("orgIds",orgIds);
        List<PortalVO> constructionCostList = zyPortalMapper.getConstructionCost(constructionCostParams);
        for (PortalVO vo : constructionCostList){
            if(innerCodeMap.containsKey(vo.getOrgId())){
                String innerCode =innerCodeMap.get(vo.getOrgId());
                for (Long orgId : constructionCostMap.keySet()) {
                    if(innerCode.contains(orgId+"")){
                        BigDecimal money = constructionCostMap.get(orgId);
                        if(vo.getContractMny()!=null){
                            money = money.add(vo.getContractMny());
                        }
                        constructionCostMap.put(orgId, money);
                    }
                }
            }
        }
        //实际成本
        /**
        * 取 已生效的结算管理(物资采购合同结算、其他支出合同结算、劳务过程结算、劳务完工结算)结算单金额，
         * 按合同维度，取所有的累计的
         * 其中劳务合同如果有完工结算取完工结算，没有完工结算取过程结算。  其他成本待数据同步过来之后统计
        * */
        //物资采购合同结算
        Map<String,Object> materialParams = new HashMap<>();
        materialParams.put("tenantId", InvocationInfoProxy.getTenantid());
        materialParams.put("orgIds",orgIds);
        List<PortalVO> materialList = zyPortalMapper.getMaterialMoney(materialParams);
        for (PortalVO vo : materialList){
            if(innerCodeMap.containsKey(vo.getOrgId())){
                String innerCode =innerCodeMap.get(vo.getOrgId());
                for (Long orgId : actualCostMap.keySet()) {
                    if(innerCode.contains(orgId+"")){
                        BigDecimal money = actualCostMap.get(orgId);
                        if(vo.getContractMny()!=null){
                            money = money.add(vo.getContractMny());
                        }
                        actualCostMap.put(orgId, money);
                    }
                }
            }
        }
        //其他支出合同结算
        Map<String,Object> otherParams = new HashMap<>();
        otherParams.put("tenantId", InvocationInfoProxy.getTenantid());
        otherParams.put("orgIds",orgIds);
        List<PortalVO> otherList = zyPortalMapper.getOtherMoney(otherParams);
        for (PortalVO vo : otherList){
            if(innerCodeMap.containsKey(vo.getOrgId())){
                String innerCode =innerCodeMap.get(vo.getOrgId());
                for (Long orgId : actualCostMap.keySet()) {
                    if(innerCode.contains(orgId+"")){
                        BigDecimal money = actualCostMap.get(orgId);
                        if(vo.getContractMny()!=null){
                            money = money.add(vo.getContractMny());
                        }
                        actualCostMap.put(orgId, money);
                    }
                }
            }
        }
        //劳务过程结算
        Map<String,Object> laborProcessParams = new HashMap<>();
        laborProcessParams.put("tenantId", InvocationInfoProxy.getTenantid());
        laborProcessParams.put("orgIds",orgIds);
        List<PortalVO> laborProcessList = zyPortalMapper.getLaborProcessMoney(laborProcessParams);
        //劳务完工结算
        Map<String,Object> laborFinishParams = new HashMap<>();
        laborFinishParams.put("tenantId", InvocationInfoProxy.getTenantid());
        laborFinishParams.put("orgIds",orgIds);
        List<PortalVO> laborFinishList = zyPortalMapper.getLaborFinishMoney(laborFinishParams);
        Map<Long, PortalVO> laborFinishMap = new HashMap<>();
        if(laborFinishList!=null && laborFinishList.size()>0){
            for (PortalVO portalVO : laborFinishList) {
                laborFinishMap.put(portalVO.getId(), portalVO);
            }
        }
        List<PortalVO> laborList = new ArrayList<>();
        if(laborProcessList!=null && laborProcessList.size()>0){
            for (PortalVO portalVO : laborProcessList) {
                if(laborFinishMap.get(portalVO.getId())!=null){
                    laborList.add(laborFinishMap.get(portalVO.getId()));
                }else{
                    laborList.add(portalVO);
                }
            }
        }
        for (PortalVO vo : laborList){
            if(innerCodeMap.containsKey(vo.getOrgId())){
                String innerCode =innerCodeMap.get(vo.getOrgId());
                for (Long orgId : actualCostMap.keySet()) {
                    if(innerCode.contains(orgId+"")){
                        BigDecimal money = actualCostMap.get(orgId);
                        if(vo.getContractMny()!=null){
                            money = money.add(vo.getContractMny());
                        }
                        actualCostMap.put(orgId, money);
                    }
                }
            }
        }

        MathContext mc = new MathContext(4, RoundingMode.HALF_UP);
        //成本进度--实际成本/造价成本
        for (Long orgId : constructionCostMap.keySet()) {
            BigDecimal constructionCost = constructionCostMap.get(orgId);
            BigDecimal actualCost = actualCostMap.get(orgId);
            if(constructionCost!=null && actualCost!=null){
                BigDecimal r = actualCost.divide(constructionCost,mc).multiply(new BigDecimal(100));
                costProcessMap.put(orgId, r);
            }
        }

        //工期进度
        Map<String,Object> projectParams = new HashMap<>();
        projectParams.put("tenantId", InvocationInfoProxy.getTenantid());
        projectParams.put("orgIds",orgIds);
        List<ProjectRegisterVO> projectList = zyPortalMapper.getProjectList(projectParams);

        Map<String,Object> completionAssessmentParams = new HashMap<>();
        completionAssessmentParams.put("tenantId", InvocationInfoProxy.getTenantid());
        completionAssessmentParams.put("orgIds",orgIds);
        List<PortalVO> completionAssessmentList = zyPortalMapper.getCompletionAssessment(completionAssessmentParams);
        Map<Long, PortalVO> completionAssessmentMap = new HashMap<>();
        if(completionAssessmentList!=null && completionAssessmentList.size()>0){
            for (PortalVO vo : completionAssessmentList) {
                completionAssessmentMap.put(vo.getId(), vo);
            }
        }

        if(projectList!=null && projectList.size()>0){
            for (ProjectRegisterVO pvo : projectList) {
                BigDecimal durationProcess = new BigDecimal(0);//工期进度
//                统计项目状态为未开工、在建状态、待验收（当前日期-项目立项里项目开工日期+1）/（项目开工日期-项目竣工日期+1）
                if(StringUtils.isBlank(pvo.getStatus()) || "1".equals(pvo.getStatus()) || "2".equals(pvo.getStatus())
                        || "5".equals(pvo.getStatus()) || "4".equals(pvo.getStatus())){
                    if(pvo.getStartDate()!=null && pvo.getFinishDate()!=null){
                        Date date = new Date();
                        LocalDate newDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        LocalDate startDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        LocalDate finishDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

                        Long a = ChronoUnit.DAYS.between(startDate, newDate) + 1;
                        Long b = ChronoUnit.DAYS.between(startDate, finishDate) + 1;
                        durationProcess = BigDecimal.valueOf(a / b * 100, 4);
                    }
                }else if("3".equals(pvo.getStatus())){
                    if(pvo.getStartDate()!=null && pvo.getFinishDate()!=null){
                        Date date = new Date();
                        LocalDate newDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        LocalDate startDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        LocalDate finishDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        if(completionAssessmentMap.get(pvo.getId())!=null){
                            LocalDate createTime = completionAssessmentMap.get(pvo.getId()).getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                            Long a = ChronoUnit.DAYS.between(startDate, createTime) + 1;
                            Long b = ChronoUnit.DAYS.between(startDate, finishDate) + 1;
                            durationProcess = BigDecimal.valueOf(a / b * 100, 4);
                        }else{
                            Long a = ChronoUnit.DAYS.between(startDate, newDate) + 1;
                            Long b = ChronoUnit.DAYS.between(startDate, finishDate) + 1;
                            durationProcess = BigDecimal.valueOf(a / b * 100, 4);
                        }
                    }
                }

                if(innerCodeMap.containsKey(pvo.getProjectDepartmentId())){
                    String innerCode =innerCodeMap.get(pvo.getProjectDepartmentId());
                    for (Long orgId : orgMap.keySet()) {
                        if(innerCode.contains(orgId+"")){
                            BigDecimal duration = durationMap.get(orgId);
                            if(durationProcess!=null){
                                duration = duration.add(durationProcess);
                            }
                            durationMap.put(orgId, duration);

                            Integer n = pnumMap.get(orgId);
                            n++;
                            pnumMap.put(orgId, n);
                        }
                    }
                }
            }
        }

        for (Long orgId : durationMap.keySet()) {
            BigDecimal duration = durationMap.get(orgId);
            Integer num = pnumMap.get(orgId);
            if(duration!=null && num!=null && num!=0){
                BigDecimal r = duration.divide(BigDecimal.valueOf(num),mc).multiply(new BigDecimal(100));
                durationMap.put(orgId, r);
            }
        }

        JSONObject re = new JSONObject();
        LinkedList<String> legendData = new LinkedList<>();
        LinkedList<BigDecimal> contractMnyData = new LinkedList<>();
        LinkedList<BigDecimal> constructionCostData = new LinkedList<>();
        LinkedList<BigDecimal> actualCostData = new LinkedList<>();
        LinkedList<BigDecimal> costProcessData = new LinkedList<>();
        LinkedList<BigDecimal> durationData = new LinkedList<>();
        for (Long orgId : moneyMap.keySet()) {
            legendData.add(orgMap.get(orgId).getName());
            contractMnyData.add(moneyMap.get(orgId));
            constructionCostData.add(constructionCostMap.get(orgId));
            actualCostData.add(actualCostMap.get(orgId));
            costProcessData.add(costProcessMap.get(orgId));
            durationData.add(durationMap.get(orgId));
        }
        re.put("legendData", legendData);
        re.put("contractMnyData", contractMnyData);
        re.put("constructionCostData", constructionCostData);
        re.put("actualCostData", actualCostData);
        re.put("costProcessData", costProcessData);
        re.put("durationData", durationData);
        return re;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    private void getBusinessSegmentDefdoc(Map<Long, List<Long>> defMap, Map<Long, DefdocDetailVO> defDetailMap, Map<Long, Long> childParentMap){
        CommonResponse<List<DefdocDetailVO>> defResponse = defdocApi.getDefDocByDefCode("zydx-businessSector");
        if(defResponse.isSuccess()){
            List<DefdocDetailVO> list = defResponse.getData();
            for (DefdocDetailVO defdocDetailVO : list) {
                defDetailMap.put(defdocDetailVO.getId(), defdocDetailVO);
                if(defdocDetailVO.getParentId()!=null){
                    childParentMap.put(defdocDetailVO.getId(), defdocDetailVO.getParentId());
                    //二级板块
                    if(defMap.get(defdocDetailVO.getParentId())!=null){
                        List<Long> second = defMap.get(defdocDetailVO.getParentId());
                        second.add(defdocDetailVO.getId());
                        defMap.put(defdocDetailVO.getParentId(), second);
                    }else{
                        List<Long> second = new ArrayList<>();
                        second.add(defdocDetailVO.getId());
                        defMap.put(defdocDetailVO.getParentId(), second);
                    }
                }
            }
        }
    }

    private LinkedHashMap<Long, OrgVO> getOrgMap(Boolean continueRoot){
        LinkedHashMap<Long, OrgVO> orgMap = new LinkedHashMap<>();
        List<Integer> typeList = new ArrayList<>();
        typeList.add(1);
        OrgVO rootOrg = null;
        CommonResponse<List<OrgVO>> rootRe = orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), typeList, null);
        if(rootRe.isSuccess() && rootRe.getData()!=null && rootRe.getData().size()>0){
            rootOrg = rootRe.getData().get(0);
        }else{
            throw new BusinessException("获取集团组织失败");
        }
        if(continueRoot){
            orgMap.put(rootOrg.getId(), rootOrg);
        }

        CommonResponse<List<OrgVO>> orgListRe = orgApi.getDirectChildrenByPid(rootOrg.getId(), null);
        if(orgListRe.isSuccess() && orgListRe.getData()!=null && orgListRe.getData().size()>0){
            List<OrgVO> orgList = orgListRe.getData();
            for (OrgVO orgVO : orgList) {
                if(orgVO.getOrgType() == 2){
                    //分子公司
                    orgMap.put(orgVO.getId(), orgVO);
                }
            }
        }
        return orgMap;
    }

    public static void main(String[] args) {
        LocalDate today = LocalDate.now();
        List<String> monthList = new ArrayList<>();
        List<String> monthSqlList = new ArrayList<>();
        String beginTime = "";
        String endTime = "";
        for (int i = 6; i > 0; i--) {
            LocalDate month = today.minusMonths(i);
            monthList.add(month.format(DateTimeFormatter.ofPattern("MM")));
            monthSqlList.add(month.format(DateTimeFormatter.ofPattern("yyyy-MM")));
        }
        int dayOfMonth = today.getDayOfMonth();
        if (dayOfMonth >= 10) {
            //当前日期大于25号
            monthList.remove(0);
            String currentMonthStr = today.format(DateTimeFormatter.ofPattern("MM"));
            monthList.add(currentMonthStr);

            monthSqlList.remove(0);
            String currentMonthStr1 = today.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            monthSqlList.add(currentMonthStr1);

            LocalDate nextMonth = today.minusMonths(-1);
            String nextMonthStr = nextMonth.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            endTime = nextMonthStr + "-01 00:00:00";
        }else{
            String currentMonthStr1 = today.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            endTime = currentMonthStr1 + "-01 00:00:00";
        }
        beginTime = monthSqlList.get(0) + "-01 00:00:00";

        System.out.println("beginTime："+beginTime+",endTime："+endTime);
        for (String lastSixMonth : monthSqlList) {
            System.out.println(lastSixMonth+",");
        }
    }
}
