package com.ejianc.business.cost.controller;

import com.ejianc.business.cost.bean.ProjectTargetcostRecordEntity;
import com.ejianc.business.cost.service.IProjectTargetcostRecordService;
import com.ejianc.business.cost.vo.ProjectTargetcostRecordDetailVO;
import com.ejianc.business.cost.vo.ProjectTargetcostRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.*;

/**
 * 项目目标成本
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectTargetcostRecord")
public class ProjectTargetcostRecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectTargetcostRecordService service;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectTargetcostRecordVO> queryDetail(Long id) {
    	ProjectTargetcostRecordEntity entity = service.selectById(id);
        ProjectTargetcostRecordVO vo = BeanMapper.map(entity, ProjectTargetcostRecordVO.class);

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectTargetcostRecordDetailList())) {
            sortIntMethod(vo.getProjectTargetcostRecordDetailList());
            List<ProjectTargetcostRecordDetailVO> detailVOS = createTreeData(vo.getProjectTargetcostRecordDetailList());
            vo.setProjectTargetcostRecordDetailList(detailVOS);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    private static void sortIntMethod(List<ProjectTargetcostRecordDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                ProjectTargetcostRecordDetailVO o1Detail = objectMapper.convertValue(o1, ProjectTargetcostRecordDetailVO.class);
                ProjectTargetcostRecordDetailVO o2Detail = objectMapper.convertValue(o2, ProjectTargetcostRecordDetailVO.class);
                String[] strs1 = o1Detail.getCode().split("\\.");
                String[] strs2 = o2Detail.getCode().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }

    public static List<ProjectTargetcostRecordDetailVO> createTreeData(List<ProjectTargetcostRecordDetailVO> list) {
        List<ProjectTargetcostRecordDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ProjectTargetcostRecordDetailVO> listMap = new HashMap<>();
        for(ProjectTargetcostRecordDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ProjectTargetcostRecordDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            ProjectTargetcostRecordDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ProjectTargetcostRecordDetailVO> child = (List<ProjectTargetcostRecordDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ProjectTargetcostRecordDetailVO> children = new ArrayList<ProjectTargetcostRecordDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

}
