package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.PreBidCostCalcMapper;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.service.IPreBidCostCalcService;

import java.util.ArrayList;
import java.util.List;

/**
 * 标前测算
 * 
 * @author generator
 * 
 */
@Service("preBidCostCalcService")
public class PreBidCostCalcServiceImpl extends BaseServiceImpl<PreBidCostCalcMapper, PreBidCostCalcEntity> implements IPreBidCostCalcService{

    @Autowired
    private IProjectApi projectApi;

    //根据项目id或子项目id获取标前测算数据
    @Override
    public PreBidCostCalcEntity queryDataByProjectId(Long projectId) {
        Long proId = projectId;
        List<Long> pIds = new ArrayList<>();
        pIds.add(projectId);
        CommonResponse<List<ProjectRegisterVO>> pvos = projectApi.queryProjectByIds(pIds);
        List<Long> projectIds = new ArrayList<>();
        if(pvos.isSuccess() && pvos.getData()!=null && pvos.getData().size()>0) {
            ProjectRegisterVO pvo = pvos.getData().get(0);
            if (pvo.getParentId()!=null){
                proId = pvo.getParentId();
            }
        }

        QueryWrapper<PreBidCostCalcEntity> wrapperPreBidCostCalc = new QueryWrapper<>();
        wrapperPreBidCostCalc.eq("project_id", proId);
        PreBidCostCalcEntity preBidCostCalcEntity = this.getOne(wrapperPreBidCostCalc);
        return preBidCostCalcEntity;
    }
}
