package com.ejianc.business.asset.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.asset.bean.AssetAmortizeDetailEntity;
import com.ejianc.business.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.asset.bean.AssetAmortizeEntity;
import com.ejianc.business.asset.service.IAssetAmortizeService;
import com.ejianc.business.asset.vo.AssetAmortizeVO;

/**
 * 固定资产摊销
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("assetAmortize")
public class AssetAmortizeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZY_ASSET_AMORTIZE";//此处需要根据实际修改

    @Autowired
    private IAssetAmortizeService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> saveOrUpdate(@RequestBody AssetAmortizeVO saveOrUpdateVO) {

        //组织、项目重复校验
        QueryWrapper<AssetAmortizeEntity> query = new QueryWrapper();
        if (null != saveOrUpdateVO.getDependOnProject() && 1 == saveOrUpdateVO.getDependOnProject()){
            query.eq("project_id", saveOrUpdateVO.getProjectId());
        }else {
            query.eq("org_id", saveOrUpdateVO.getOrgId());
        }
        if(null != saveOrUpdateVO.getId()) {
            query.ne("id", saveOrUpdateVO.getId());
        }
        query.eq("bill_state", 0);
        List<AssetAmortizeEntity> billCodeEntityList = service.list(query);
        if(CollectionUtils.isNotEmpty(billCodeEntityList)) {
            return CommonResponse.error("保存失败，该" + (saveOrUpdateVO.getDependOnProject() == 1 ? "项目" : "组织") +"已有未生效的单据！");
        }

    	AssetAmortizeEntity entity = BeanMapper.map(saveOrUpdateVO, AssetAmortizeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	AssetAmortizeVO vo = BeanMapper.map(entity, AssetAmortizeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> queryDetail(Long id) {
    	AssetAmortizeEntity entity = service.selectById(id);
    	AssetAmortizeVO vo = BeanMapper.map(entity, AssetAmortizeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetAmortizeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (AssetAmortizeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AssetAmortizeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<AssetAmortizeEntity> page = service.queryPage(param,false);
        IPage<AssetAmortizeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AssetAmortizeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AssetAmortizeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<AssetAmortizeVO> voList = BeanMapper.mapList(list, AssetAmortizeVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            e.setDependOnProjectName(0 == e.getDependOnProject() ? "否" : "是");
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("AssetAmortize-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAssetAmortizeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeVO>> refAssetAmortizeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AssetAmortizeEntity> page = service.queryPage(param,false);
        IPage<AssetAmortizeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AssetAmortizeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @RequestMapping(value = "getAssetAmortizeByProjectOrOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> getAssetAmortizeByProjectOrOrg(Integer dependOnProject, @RequestParam(required=false) Long orgId, @RequestParam(required=false) Long projectId,  Long assetAmortizeId) {
        AssetAmortizeVO assetAmortizeVO = new AssetAmortizeVO();
        QueryWrapper<AssetAmortizeEntity> query = new QueryWrapper();
        if (1 == dependOnProject){
            query.eq("project_id", projectId);
        }else {
            query.eq("org_id", orgId);
        }
        if(null != assetAmortizeId) {
            query.ne("id", assetAmortizeId);
        }
        query.orderByDesc("make_date");
        List<AssetAmortizeEntity> billCodeEntityList = service.list(query);
        if(CollectionUtils.isNotEmpty(billCodeEntityList)){
            if (0 == billCodeEntityList.get(0).getBillState()) {
                return CommonResponse.error("查询失败，该" + (dependOnProject == 1 ? "项目" : "组织") +"已有未生效的单据！");
            }
            AssetAmortizeEntity amortizeEntity = service.selectById(billCodeEntityList.get(0).getId());
            for (AssetAmortizeDetailEntity detailEntity : amortizeEntity.getDetailList()) {
                detailEntity.setTotalDetailMny(ComputeUtil.safeAdd(detailEntity.getDetailMny(), detailEntity.getTotalDetailMny()));
                detailEntity.setDetailMny(BigDecimal.ZERO);
                detailEntity.setRowState("add");
                detailEntity.setAssetAmortizeId(null);
            }
            assetAmortizeVO.setDetailList(BeanMapper.mapList(amortizeEntity.getDetailList(), AssetAmortizeDetailVO.class));
            assetAmortizeVO.setTotalAmortizeMny(ComputeUtil.safeAdd(amortizeEntity.getAmortizeMny(), amortizeEntity.getTotalAmortizeMny()));
        }
        return CommonResponse.success("查询累计数据成功！", assetAmortizeVO);
    }
}
