package com.ejianc.business.income.utils;


import java.math.BigDecimal;

public class BigDecimalUtils {
    public static final int DEFAULT_SCALE = 8;
    public static final int DEFAULT_ROUND_HALF = 4;

    public BigDecimalUtils() {
    }

    public static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal decimal2) {
        return decimal1 != null && decimal2 != null && decimal2.compareTo(BigDecimal.ZERO) != 0 ? decimal1.divide(decimal2, 8, 4) : new BigDecimal(0);
    }

    public static BigDecimal safeAdd(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            return decimal2;
        } else {
            return decimal2 == null ? decimal1 : decimal1.add(decimal2);
        }
    }

    public static BigDecimal safeMultiply(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }

        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }

        return decimal1.multiply(decimal2).setScale(8, 4);
    }

    public static BigDecimal safeSub(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }

        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }

        return decimal1.subtract(decimal2);
    }

    public static BigDecimal roundTwoPre(BigDecimal src) {
        return src == null ? src : src.setScale(2, 4);
    }

    public static Boolean isEmpty(BigDecimal num) {
        return null == num || BigDecimal.ZERO.compareTo(num) == 0;
    }

    public static Boolean isNotEmpty(BigDecimal num) {
        return !isEmpty(num);
    }
}
