package com.ejianc.business.labprice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.othprice.vo.OtherQuoteDetailVO;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 劳务询价-询价清单
 * 
 * @author generator
 * 
 */
public class LaborInquiryDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long inquiryId; // 询价id
    private String detailCode; // 编码
    private String detailName; // 名称
    private String spec; // 规格型号/特征
    private String unit; // 计量单位
    private BigDecimal num; // 数量
    private BigDecimal referPrice; // 参考价
    private BigDecimal mny; // 金额
    private String memo; // 备注
    private Date planUseDate; // 计划使用日期
    private Long sourceId; // 来源id
    private Integer sourceType; // 物资来源类型：1-新增，2-导入
    //报价最小值
    private BigDecimal  minBidPrice;

    //报价最大值
    private BigDecimal  maxBidPrice;

    // 针对于这个材料各个供应商报价数据
    List<LaborQuoteDetailVO> laborQuoteDetailVOList;


    public List<LaborQuoteDetailVO> getLaborQuoteDetailVOList() {
        return laborQuoteDetailVOList;
    }

    public void setLaborQuoteDetailVOList(List<LaborQuoteDetailVO> laborQuoteDetailVOList) {
        this.laborQuoteDetailVOList = laborQuoteDetailVOList;
    }

    public BigDecimal getMinBidPrice() {
        return minBidPrice;
    }

    public void setMinBidPrice(BigDecimal minBidPrice) {
        this.minBidPrice = minBidPrice;
    }

    public BigDecimal getMaxBidPrice() {
        return maxBidPrice;
    }

    public void setMaxBidPrice(BigDecimal maxBidPrice) {
        this.maxBidPrice = maxBidPrice;
    }

    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }
    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getReferPrice() {
        return referPrice;
    }

    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getPlanUseDate() {
        return planUseDate;
    }

    public void setPlanUseDate(Date planUseDate) {
        this.planUseDate = planUseDate;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    
}
