package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;

/**
 * 仓库盘点实体类
 *
 * @author CJ
 * @Description: 仓库盘点实体类
 * @date 2021/3/12 15:57
 */
@TableName(value = "ejc_zypms_material_store_check")
public class StoreCheckEntity extends BaseEntity {

    private static final long serialVersionUID = -2500754335479290983L;

    /**
     * 盘点编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 盘点仓库Id
     */
    @TableField(value = "store_id")
    private Long storeId;

    /**
     * 盘点仓库名称
     */
    @TableField(value = "store_name")
    private String storeName;

    /**
     * 所属组织Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 盘点日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value = "check_date")
    private Date checkDate;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "effective_date")
    private Date effectiveDate;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "commit_date")
    private Date commitDate;

    /**
     * 提交人名称
     */
    @TableField(value = "commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField(value = "commit_user_code")
    private String commitUserCode;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 修改人名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 盘点物资明细
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "storeCheckSubService", pidName = "storeCheckId")
    private List<StoreCheckSubEntity> materialSubList;

    /**
     * 盘点单对应入库单据Id
     */
    @TableField(value = "relation_in_store_id")
    private Long relationInStoreId;

    /**
     * 盘点单对应出库单据Id
     */
    @TableField(value = "relation_out_store_id")
    private Long relationOutStoreId;

    public Long getRelationInStoreId() {
        return relationInStoreId;
    }

    public void setRelationInStoreId(Long relationInStoreId) {
        this.relationInStoreId = relationInStoreId;
    }

    public Long getRelationOutStoreId() {
        return relationOutStoreId;
    }

    public void setRelationOutStoreId(Long relationOutStoreId) {
        this.relationOutStoreId = relationOutStoreId;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public List<StoreCheckSubEntity> getMaterialSubList() {
        return materialSubList;
    }

    public void setMaterialSubList(List<StoreCheckSubEntity> materialSubList) {
        this.materialSubList = materialSubList;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
