package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.PickRegisterEntity;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.business.material.vo.PickRegisterVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 领料登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("pickRegister")
public class PickRegisterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;

    private static final String BILL_CODE = "PICK-REGISTER";//此处需要根据实际修改

    @Autowired
    private IPickRegisterService pickRegisterService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PickRegisterVO> saveOrUpdate(@RequestBody PickRegisterVO saveOrUpdateVO) {
    	PickRegisterEntity entity = BeanMapper.map(saveOrUpdateVO, PickRegisterEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
    	    //校验项目+供应商是否可以保存
            List<PickRegisterEntity> list = pickRegisterService.queryByProjectAndSupplier(saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getSupplierId(),saveOrUpdateVO.getId());
            if(CollectionUtils.isNotEmpty(list)) {
                return CommonResponse.error("保存失败，本项目+领料单位已存在限领数量单据，请更换项目或领料单位！");
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	pickRegisterService.saveOrUpdate(entity, false);
    	PickRegisterVO vo = BeanMapper.map(entity, PickRegisterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PickRegisterVO> queryDetail(Long id) {
    	PickRegisterEntity entity = pickRegisterService.selectById(id);
    	PickRegisterVO vo = BeanMapper.map(entity, PickRegisterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PickRegisterVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PickRegisterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        pickRegisterService.removeByIds(vos.stream().map(PickRegisterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PickRegisterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PickRegisterEntity> page = pickRegisterService.queryPage(param,false);
        IPage<PickRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PickRegisterVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 校验项目+供应商是否存在单据
     * @param projectId
     * @return
     */
    @GetMapping(value = "projectSupplierCheck")
    @ResponseBody
    public CommonResponse<String> projectSupplierCheck(@RequestParam(value = "projectId") Long projectId,
                                                   @RequestParam(value = "supplierId") Long supplierId,
                                                   @RequestParam(value = "billId", required = false) Long billId) {
        QueryWrapper<PickRegisterEntity> query = new QueryWrapper<>();
        if(billId!=null){
            query.notIn("id", billId);
        }
        query.eq("project_id", projectId);
        query.eq("supplier_id", supplierId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<PickRegisterEntity> list = pickRegisterService.list(query);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("本项目+领料单位已存在限领数量单据，请更换项目或领料单位！");
        }
        return CommonResponse.success("该项目、供应商适用当前领料登记！");
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "pick-register-material-import.xlsx", "物料导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<PickRegisterDetailVO> successList = new ArrayList<>();
            List<PickRegisterDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 5) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                //筛选重复序号
                Map<Long,String> indexMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PickRegisterDetailVO registerDetailVO = new PickRegisterDetailVO();
                    if (StringUtils.isBlank(datas.get(0))) {
                        registerDetailVO.setErrorMessage("物资名称为必填项");
                    } else if (datas.get(0).length() > 20) {
                        registerDetailVO.setErrorMessage("物资名称填写长度为0~20字");
                    } else {
                        registerDetailVO.setMaterialName(datas.get(0));
                    }
                    if (StringUtils.isBlank(datas.get(1))) {
                        registerDetailVO.setErrorMessage("规格型号为必填项");
                    } else if (datas.get(1).length() > 200) {
                        registerDetailVO.setErrorMessage("规格型号填写长度为0~200字");
                    } else {
                        registerDetailVO.setMaterialSpec(datas.get(1));
                    }

                    registerDetailVO.setMaterialUnitName(datas.get(2));
                    if (StringUtils.isNotBlank(datas.get(4)) && datas.get(4).length() > 64) {
                        registerDetailVO.setErrorMessage("物料编码填写长度为0~64字");

                    } else {
                        registerDetailVO.setMaterialCode(datas.get(4));
                    }
                    if(StringUtils.isNotBlank(datas.get(4))){
                        registerDetailVO.setRestrictNum(ComputeUtil.toBigDecimal(com.ejianc.framework.core.util.ComputeUtil.scaleStripTrailingZeros(new BigDecimal(datas.get(4)),8)));
                    }

                    if (org.apache.commons.lang.StringUtils.isBlank(registerDetailVO.getErrorMessage())) {
                        //通过物料名称、规格、计量单位获取物料
                        MaterialVO vo = new MaterialVO();
                        vo.setName(registerDetailVO.getMaterialName());
                        vo.setSpec(registerDetailVO.getMaterialSpec());
                        vo.setUnitName(registerDetailVO.getMaterialUnitName());
                        CommonResponse<List<MaterialVO>> listCommonResponse = materialApi.queryMaterialList(vo);

                        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
                            MaterialVO materialVo = listCommonResponse.getData().get(0);
                            registerDetailVO.setMaterialCategoryId(materialVo.getCategoryId());
                            registerDetailVO.setMaterialCategoryName(materialVo.getCategoryName());
                            registerDetailVO.setMaterialId(materialVo.getId());
                            registerDetailVO.setMaterialCode(materialVo.getCode());
                            if(indexMap.containsKey(materialVo.getId())){
                                registerDetailVO.setErrorMessage("材料重复");
                                registerDetailVO.setId((long)i);
                                errorList.add(registerDetailVO);
                                continue;
                            }else{
                                indexMap.put(materialVo.getId(),materialVo.getName());
                            }
                            successList.add(registerDetailVO);
                            continue;
                        } else {
                            registerDetailVO.setErrorMessage("该物资不存在");
                        }
                        registerDetailVO.setId((long) i);
                        errorList.add(registerDetailVO);
                    } else {
                        registerDetailVO.setId((long)i);
                        errorList.add(registerDetailVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PickRegisterEntity> list = pickRegisterService.queryList(param);
        List<PickRegisterVO> vos = BeanMapper.mapList(list, PickRegisterVO.class);
        vos.forEach(item->{
            item.setCreateTimeStr(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", item.getCreateTime()));
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("pickRegisterListExport.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPickRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PickRegisterVO>> refPickRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PickRegisterEntity> page = pickRegisterService.queryPage(param,false);
        IPage<PickRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PickRegisterVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
