package com.ejianc.business.material.controller.api;

import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.InstoreAccountSumVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/materialInstore/")
public class MaterialInstoreApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IInstoreService instoreService;


    @Autowired
    IUseApplyService useApplyService;


    @RequestMapping(value = "instoreNumCount", method = RequestMethod.POST)
    CommonResponse<List<InstoreMaterialVO>> instoreNumCount(@RequestBody Map<String, Object> queryParam) {
        return CommonResponse.success("查询详情数据成功！", instoreService.instoreNumCount(queryParam));
    }

    @RequestMapping(value = "materialFinishCount", method = RequestMethod.POST)
    CommonResponse<List<UseApplyFinishVO>> materialFinishCount(@RequestBody Map<String, Object> queryParam) {
        return CommonResponse.success("查询详情数据成功！", useApplyService.materialFinishCount(queryParam));
    }

    @RequestMapping(value = "amountSum", method = RequestMethod.POST)
    CommonResponse<List<InstoreAccountSumVO>> amountSum(@RequestParam("projectIds") List<Long> projectIds) {
        List<InstoreAccountSumVO> instoreAccountSumVOS = instoreService.amountSum(projectIds);
        if(CollectionUtils.isNotEmpty(instoreAccountSumVOS)){
            instoreAccountSumVOS.forEach(t-> {
                BigDecimal surplusAmt = ComputeUtil.safeSub(t.getInAmount(), t.getOutAmount());
                t.setTotalAmount(ComputeUtil.isGreaterThan(surplusAmt, t.getSettleAmount()) ? surplusAmt : t.getSettleAmount());
            });
        }
        return CommonResponse.success("查询详情数据成功！", instoreAccountSumVOS);
    }
}
