package com.ejianc.business.material.mapper;

import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface OutStoreSubMapper extends BaseCrudMapper<OutStoreSubEntity> {

	Long countOutStoreMaterial(@Param("storeId") Long storeId,@Param("outDate") String outDate,@Param("storeType") String storeType,@Param("materialCategoryName") String materialCategoryName,@Param("materialName") String materialName,@Param("materialSpec") String materialSpec,@Param("searchText") String searchText,@Param("projectId")Long projectId);
	
	List<OutStoreSubVO> queryOutStoreMaterialList(@Param("startLine") Integer startLine,@Param("pageSize") Integer pageSize,@Param("storeId") Long storeId,@Param("outDate") String outDate,@Param("storeType") String storeType,@Param("materialCategoryName") String materialCategoryName,@Param("materialName") String materialName,@Param("materialSpec") String materialSpec,@Param("billCode") String billCode,@Param("outDateSearch") String outDateSearch,@Param("searchText") String searchText,@Param("projectId")Long projectId);

	List<OutStoreSubVO> queryMaterialCostTopN(@Param("topN") Integer topN,@Param("type") Integer type,@Param("startDate") String startDate,@Param("orgIds") List<Long> orgIds);
	
	//按物资分类查询
	List<OutStoreSubVO> queryMaterialCategoryCostTopN(@Param("topN") Integer topN,@Param("type") Integer type,@Param("startDate") String startDate,@Param("orgIds") List<Long> orgIds);

	List<OutStoreSubVO> queryMaterialCostTopNByProjectId(@Param("topN") Integer topN,@Param("projectId") Long projectId);

    List<OutStoreSubVO> queryReturnGoodsMaterialNum(Map<String, Object> param);

    List<MaterialPriceVO> queryMaterialOutstoreCount(Long projectId, List<Long> materialIds);
}
