/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.PrjcontractCostsEntity;
import com.ejianc.business.cost.service.IPrjcontractCostsService;
import com.ejianc.business.cost.vo.PrjcontractCostsDetailVO;
import com.ejianc.business.cost.vo.PrjcontractCostsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"prjcontractCosts"})
public class PrjcontractCostsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "zydxPrjcontractCosts";
    @Autowired
    private IPrjcontractCostsService service;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PrjcontractCostsVO> saveOrUpdate(@RequestBody PrjcontractCostsVO saveOrUpdateVO) {
        PrjcontractCostsEntity entity = (PrjcontractCostsEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), PrjcontractCostsEntity.class));
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            checkWrapper.ne((Object)"id", (Object)entity.getId());
        }
        List check = this.service.list((Wrapper)checkWrapper);
        if (check.size() > 0) {
            throw new BusinessException("\u9879\u76ee\u3010" + entity.getProjectName() + "\u3011\u4e0b\u5df2\u5b58\u5728\u5408\u540c\u9020\u4ef7\u8868");
        }
        if (entity.getPrjcontractCostsDetailList() != null && entity.getPrjcontractCostsDetailList().size() > 0) {
            HashMap map = new HashMap();
            entity.getPrjcontractCostsDetailList().forEach(item -> {
                if ("add".equals(item.getRowState())) {
                    item.setId(IdWorker.getId());
                    item.setCostsId(entity.getId());
                }
                if (!"del".equals(item.getRowState())) {
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getPrjcontractCostsDetailList().forEach(item -> {
                if ("add".equals(item.getRowState()) && item.getCode().indexOf(".") != -1) {
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid((Long)map.get(code));
                }
            });
        }
        this.service.saveOrUpdate((Object)entity, false);
        PrjcontractCostsVO vo = (PrjcontractCostsVO)((Object)BeanMapper.map((Object)((Object)entity), PrjcontractCostsVO.class));
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getPrjcontractCostsDetailList())) return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
        PrjcontractCostsController.sortIntMethod(vo.getPrjcontractCostsDetailList());
        List<PrjcontractCostsDetailVO> detailVOS = PrjcontractCostsController.createTreeData(vo.getPrjcontractCostsDetailList());
        vo.setPrjcontractCostsDetailList(detailVOS);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PrjcontractCostsVO> queryDetail(Long id) {
        PrjcontractCostsEntity entity = (PrjcontractCostsEntity)((Object)this.service.selectById(id));
        PrjcontractCostsVO vo = (PrjcontractCostsVO)((Object)BeanMapper.map((Object)((Object)entity), PrjcontractCostsVO.class));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getPrjcontractCostsDetailList())) {
            PrjcontractCostsController.sortIntMethod(vo.getPrjcontractCostsDetailList());
            List<PrjcontractCostsDetailVO> detailVOS = PrjcontractCostsController.createTreeData(vo.getPrjcontractCostsDetailList());
            vo.setPrjcontractCostsDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrjcontractCostsVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PrjcontractCostsVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> departmentIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PrjcontractCostsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("projectDepartmentId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PrjcontractCosts-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPrjcontractCostsData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PrjcontractCostsVO>> refPrjcontractCostsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PrjcontractCostsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private static void sortIntMethod(List<PrjcontractCostsDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                PrjcontractCostsDetailVO o1Detail = (PrjcontractCostsDetailVO)((Object)objectMapper.convertValue(o1, PrjcontractCostsDetailVO.class));
                PrjcontractCostsDetailVO o2Detail = (PrjcontractCostsDetailVO)((Object)objectMapper.convertValue(o2, PrjcontractCostsDetailVO.class));
                String[] strs1 = o1Detail.getCode().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getCode().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    public static List<PrjcontractCostsDetailVO> createTreeData(List<PrjcontractCostsDetailVO> list) {
        ArrayList<PrjcontractCostsDetailVO> resp = new ArrayList<PrjcontractCostsDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, PrjcontractCostsDetailVO> listMap = new HashMap<String, PrjcontractCostsDetailVO>();
        for (PrjcontractCostsDetailVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            PrjcontractCostsDetailVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            PrjcontractCostsDetailVO parent = (PrjcontractCostsDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<PrjcontractCostsDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<PrjcontractCostsDetailVO> children = new ArrayList<PrjcontractCostsDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((PrjcontractCostsDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }
}

