/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.EngdepartRespcostEntity;
import com.ejianc.business.cost.bean.ProjectImplProtocolEntity;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IProjectImplProtocolService;
import com.ejianc.business.cost.vo.ProjectImplProtocolDetailVO;
import com.ejianc.business.cost.vo.ProjectImplProtocolVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectImplProtocol"})
public class ProjectImplProtocolController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "zydxProjectImplProtocol";
    @Autowired
    private IProjectImplProtocolService service;
    @Autowired
    private IEngdepartRespcostService engdepartRespcostService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectImplProtocolVO> saveOrUpdate(@RequestBody ProjectImplProtocolVO saveOrUpdateVO) {
        ProjectImplProtocolEntity entity = (ProjectImplProtocolEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProjectImplProtocolEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getProjectImplProtocolDetailList() != null && entity.getProjectImplProtocolDetailList().size() > 0) {
            HashMap map = new HashMap();
            entity.getProjectImplProtocolDetailList().forEach(item -> {
                if ("add".equals(item.getRowState())) {
                    item.setId(IdWorker.getId());
                    item.setPrjimplProtocolId(entity.getId());
                }
                if (!"del".equals(item.getRowState())) {
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getProjectImplProtocolDetailList().forEach(item -> {
                if ("add".equals(item.getRowState()) && item.getCode().indexOf(".") != -1) {
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid((Long)map.get(code));
                }
            });
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectImplProtocolVO vo = (ProjectImplProtocolVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectImplProtocolVO.class));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectImplProtocolDetailList())) {
            ProjectImplProtocolController.sortIntMethod(vo.getProjectImplProtocolDetailList());
            List<ProjectImplProtocolDetailVO> detailVOS = ProjectImplProtocolController.createTreeData(vo.getProjectImplProtocolDetailList());
            vo.setProjectImplProtocolDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectImplProtocolVO> queryDetail(Long id) {
        ProjectImplProtocolEntity entity = (ProjectImplProtocolEntity)((Object)this.service.selectById(id));
        ProjectImplProtocolVO vo = (ProjectImplProtocolVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectImplProtocolVO.class));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectImplProtocolDetailList())) {
            ProjectImplProtocolController.sortIntMethod(vo.getProjectImplProtocolDetailList());
            List<ProjectImplProtocolDetailVO> detailVOS = ProjectImplProtocolController.createTreeData(vo.getProjectImplProtocolDetailList());
            vo.setProjectImplProtocolDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectImplProtocolVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectImplProtocolVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectImplProtocolVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectImplProtocol-export.xlsx", beans, response);
    }

    private static void sortIntMethod(List<ProjectImplProtocolDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                ProjectImplProtocolDetailVO o1Detail = (ProjectImplProtocolDetailVO)((Object)objectMapper.convertValue(o1, ProjectImplProtocolDetailVO.class));
                ProjectImplProtocolDetailVO o2Detail = (ProjectImplProtocolDetailVO)((Object)objectMapper.convertValue(o2, ProjectImplProtocolDetailVO.class));
                String[] strs1 = o1Detail.getCode().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getCode().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    public static List<ProjectImplProtocolDetailVO> createTreeData(List<ProjectImplProtocolDetailVO> list) {
        ArrayList<ProjectImplProtocolDetailVO> resp = new ArrayList<ProjectImplProtocolDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ProjectImplProtocolDetailVO> listMap = new HashMap<String, ProjectImplProtocolDetailVO>();
        for (ProjectImplProtocolDetailVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ProjectImplProtocolDetailVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            ProjectImplProtocolDetailVO parent = (ProjectImplProtocolDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ProjectImplProtocolDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ProjectImplProtocolDetailVO> children = new ArrayList<ProjectImplProtocolDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((ProjectImplProtocolDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/refProjectImplProtocolData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectImplProtocolVO>> refProjectImplProtocolData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectImplProtocolVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkBillParam"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONArray> checkBillParam(@RequestBody ProjectImplProtocolVO vo) {
        JSONObject item;
        JSONArray list = new JSONArray();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)vo.getProjectId());
        List engdepartList = this.engdepartRespcostService.list((Wrapper)wrapper);
        EngdepartRespcostEntity engdepartEntity = null;
        if (engdepartList == null || engdepartList.size() <= 0) {
            JSONObject item2 = new JSONObject();
            item2.put("type", (Object)"alert");
            item2.put("warnItem", (Object)(list.size() + 1 + ""));
            item2.put("warnName", (Object)"\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u63a7\u9879\u76ee\u5b9e\u65bd\u534f\u8bae");
            item2.put("content", (Object)"\u7f3a\u5c11\u5bf9\u5e94\u9879\u76ee\u7684\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c");
            list.add((Object)item2);
            return CommonResponse.success((Object)list);
        }
        engdepartEntity = (EngdepartRespcostEntity)((Object)engdepartList.get(0));
        if (vo.getWorkloadCost() == null) {
            vo.setWorkloadCost(new BigDecimal(0));
        }
        if (engdepartEntity.getRespcostTotal() == null) {
            engdepartEntity.setRespcostTotal(new BigDecimal(0));
        }
        if (vo.getWorkloadCost().compareTo(engdepartEntity.getRespcostTotal()) > 0) {
            item = new JSONObject();
            item.put("type", (Object)"P-6659420313");
            item.put("warnItem", (Object)(list.size() + 1 + ""));
            item.put("warnName", (Object)"\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u9879\u76ee\u6210\u672c\u91d1\u989d\u63a7\u9879\u76ee\u5b9e\u65bd\u534f\u8bae\u5de5\u4f5c\u91cf\u91d1\u989d");
            item.put("content", (Object)("\u3010\u9879\u76ee\u5b9e\u65bd\u534f\u8bae\u3011\u5de5\u4f5c\u91cf\u91d1\u989d\uff1e\u3010\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u3011\u9879\u76ee\u6210\u672c\u603b\u989d\uff0c\u3010\u9879\u76ee\u5b9e\u65bd\u534f\u8bae\u3011\u7684\u5de5\u4f5c\u91cf\u91d1\u989d\uff1a" + vo.getWorkloadCost().setScale(2) + "\u5143\uff0c\u5927\u4e8e\u3010\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u3011\u7684\u9879\u76ee\u6210\u672c\u603b\u989d\uff1a" + engdepartEntity.getRespcostTotal().setScale(2) + "\u5143"));
            list.add((Object)item);
        }
        if (vo.getPrjsaleCost() == null && engdepartEntity.getPrjsaleCost() != null) {
            item = new JSONObject();
            item.put("type", (Object)"P-Ql4TY90314");
            item.put("warnItem", (Object)(list.size() + 1 + ""));
            item.put("warnName", (Object)"\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u9500\u552e\u8d39\u7528\u63a7\u9879\u76ee\u5b9e\u65bd\u534f\u8bae\u9500\u552e\u8d39\u7528");
            item.put("content", (Object)("\u3010\u9879\u76ee\u5b9e\u65bd\u534f\u8bae\u3011\u9500\u552e\u8d39\u7528\uff1e\u3010\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u3011\u9500\u552e\u8d39\u7528\uff0c\u3010\u9879\u76ee\u5b9e\u65bd\u534f\u8bae\u3011\u7684\u9500\u552e\u8d39\u7528\uff1a0\u5143\uff0c\u5927\u4e8e\u3010\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u3011\u7684\u9500\u552e\u8d39\u7528\uff1a" + engdepartEntity.getPrjsaleCost().setScale(2) + "\u5143"));
            list.add((Object)item);
        } else if (vo.getPrjsaleCost() != null && engdepartEntity.getPrjsaleCost() != null && vo.getPrjsaleCost().compareTo(engdepartEntity.getPrjsaleCost()) > 0) {
            item = new JSONObject();
            item.put("type", (Object)"P-Ql4TY90314");
            item.put("warnItem", (Object)(list.size() + 1 + ""));
            item.put("warnName", (Object)"\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u9500\u552e\u8d39\u7528\u63a7\u9879\u76ee\u5b9e\u65bd\u534f\u8bae\u9500\u552e\u8d39\u7528");
            item.put("content", (Object)("\u3010\u9879\u76ee\u5b9e\u65bd\u534f\u8bae\u3011\u9500\u552e\u8d39\u7528\uff1e\u3010\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u3011\u9500\u552e\u8d39\u7528\uff0c\u3010\u9879\u76ee\u5b9e\u65bd\u534f\u8bae\u3011\u7684\u9500\u552e\u8d39\u7528\uff1a" + vo.getPrjsaleCost().setScale(2) + "\u5143\uff0c\u5927\u4e8e\u3010\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u3011\u7684\u9500\u552e\u8d39\u7528\uff1a" + engdepartEntity.getPrjsaleCost().setScale(2) + "\u5143"));
            list.add((Object)item);
        }
        return CommonResponse.success((Object)list);
    }
}

