package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.EngdepartRespcostEntity;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostEntity;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.service.IProjectTargetcostService;
import com.ejianc.business.cost.utils.ProjectUtils;
import com.ejianc.business.cost.vo.ProjectTargetcostVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.ProjectTargetcostChangeEntity;
import com.ejianc.business.cost.service.IProjectTargetcostChangeService;
import com.ejianc.business.cost.vo.ProjectTargetcostChangeVO;

/**
 * 项目目标成本变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectTargetcostChange")
public class ProjectTargetcostChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectTargetcostChangeService service;
    @Autowired
    private IProjectTargetcostService targetcostService;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private ProjectUtils projectUtils;
    @Autowired
    private IParamConfigApi paramConfigApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectTargetcostChangeVO> saveChange(@RequestBody ProjectTargetcostChangeVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectTargetcostChangeVO> queryDetail(Long id) {
        return service.queryDetail(id);
    }

    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/queryDetailByTargetcostId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectTargetcostChangeVO> queryDetailByTargetcostId(@RequestParam(value = "targetcostId") Long targetcostId) {
        return service.queryDetailByTargetcostId(targetcostId);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectTargetcostChangeVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectTargetcostChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        if(param.getParams().get("taskcostId")==null){
            throw new BusinessException("缺少项目目标成本id");
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ProjectTargetcostChangeEntity> page = service.queryPage(param,false);
        IPage<ProjectTargetcostChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectTargetcostChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/checkBillParam", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONArray> checkBillParam(@RequestBody ProjectTargetcostChangeVO vo) {
        MathContext mc = new MathContext(4, RoundingMode.HALF_UP);
        JSONArray list = new JSONArray();
        BigDecimal targetcostTotal = vo.getTargetcostTotal()!=null?vo.getTargetcostTotal():new BigDecimal(0);//【项目目标成本】目标成本总额

        ProjectTargetcostEntity targetcostEntity = targetcostService.selectById(vo.getTaskcostId());
        BigDecimal oldTargetcostTotal = targetcostEntity.getTargetcostTotal()!=null?targetcostEntity.getTargetcostTotal():new BigDecimal(0);//原先的【项目目标成本】目标成本总额
        if(oldTargetcostTotal.compareTo(targetcostTotal)>0){
            JSONObject item = new JSONObject();
            item.put("type", "P-L64oPo0311");
            item.put("warnItem", list.size()+1+"");
            item.put("warnName", "项目目标成本控项目目标成本变更");
            item.put("content", "【项目目标成本】的目标成本金额："+oldTargetcostTotal.setScale(2)+"元，大于【项目目标成本变更】的项目成本："+oldTargetcostTotal.setScale(2)+"元");
            list.add(item);
        }
        //项目目标成本变更金额<项目目标成本金额10%
        CommonResponse<BillParamVO> param = paramConfigApi.getBillParamByCode("P-L64oPo0311");
        if(param.isSuccess() && param.getData()!=null){
            BigDecimal roleValue = param.getData().getRoleValue();
            //(变更金额-原先金额)/原先金额
            BigDecimal va = (targetcostTotal.subtract(oldTargetcostTotal)).divide(oldTargetcostTotal,mc).multiply(new BigDecimal(100));
            if(roleValue.compareTo(va)>0){
                //小于配置值，提示
                JSONObject item = new JSONObject();
                item.put("type", "P-L64oPo0311");
                item.put("warnItem", list.size()+1+"");
                item.put("warnName", "项目目标成本控项目目标成本变更");
                item.put("content", "项目目标成本变更金额＞项目目标成本金额10%，"+"【项目目标成本】的目标成本金额："+oldTargetcostTotal.setScale(2)+"元，大于【项目目标成本变更】的项目成本："+oldTargetcostTotal.setScale(2)+"元");
                list.add(item);
            }
        }

        //项目目标成本金额（含子项目累计金额）不能超标前测算金额
        CommonResponse<BillParamVO> dataResponse = paramConfigApi.getBillParamByCode("P-m69ri60308");
        if(dataResponse.isSuccess()){
            BigDecimal roleValue = dataResponse.getData().getRoleValue();
            //获取标签测算金额
            PreBidCostCalcEntity preBidCostCalcEntity = preBidCostCalcService.queryDataByProjectId(vo.getProjectId());
            if(preBidCostCalcEntity==null){
                throw new BusinessException("未获取到该项目标前测算数据，请先完成标前测算");
            }
            BigDecimal costTaxTotal = preBidCostCalcEntity.getCostTaxTotal()!=null ? preBidCostCalcEntity.getCostTaxTotal() : new BigDecimal(0);

            if("子项目".equals(vo.getProjectProperty())){
                List<Long> projectIds = projectUtils.getProjectList(vo.getProjectId());
                if(projectIds!=null && projectIds.size()>0){
                    QueryWrapper<ProjectTargetcostEntity> wrappera = new QueryWrapper<>();
                    wrappera.in("project_id", projectIds);
                    List<ProjectTargetcostEntity> lsit = targetcostService.list(wrappera);
                    if(lsit!=null && lsit.size()>0){
                        BigDecimal amont = vo.getTargetcostTotal()!=null ? vo.getTargetcostTotal() : new BigDecimal(0);
                        for(ProjectTargetcostEntity pr : lsit){
                            BigDecimal targetcostTotalq = pr.getTargetcostTotal()!=null ? pr.getTargetcostTotal() : new BigDecimal(0);
                            amont = amont.add(targetcostTotalq);
                        }

                        BigDecimal absoluteValue = amont.subtract(costTaxTotal);
                        BigDecimal da = new BigDecimal(0);
                        if(costTaxTotal.compareTo(new BigDecimal(0)) != 0){
                            da = absoluteValue.divide(costTaxTotal,mc).multiply(new BigDecimal(100));
                        }
                        if(da.compareTo(roleValue)>0){
                            JSONObject item = new JSONObject();
                            item.put("type", "1");
                            item.put("warnItem", "1");
                            item.put("warnName", "标前测算控项目目标成本");
                            item.put("content", "【项目目标成本】的目标成本金额："+amont.setScale(2)+"元，大于【标前测算】的项目成本："+costTaxTotal.setScale(2)+"元");
                            list.add(item);
                        }
                    }
                }else{
                    BigDecimal absoluteValue = targetcostTotal.subtract(costTaxTotal);
                    BigDecimal da = new BigDecimal(0);
                    if(costTaxTotal.compareTo(new BigDecimal(0)) != 0){
                        da = absoluteValue.divide(costTaxTotal,mc).multiply(new BigDecimal(100));
                    }
                    if(da.compareTo(roleValue)>0){
                        JSONObject item = new JSONObject();
                        item.put("type", "1");
                        item.put("warnItem", "1");
                        item.put("warnName", "标前测算控项目目标成本");
                        item.put("content", "【项目目标成本】的目标成本金额："+targetcostTotal.setScale(2)+"元，大于【标前测算】的项目成本："+costTaxTotal.setScale(2)+"元");
                        list.add(item);
                    }
                }
            }else{
                BigDecimal absoluteValue = targetcostTotal.subtract(costTaxTotal);
                BigDecimal da = new BigDecimal(0);
                if(costTaxTotal.compareTo(new BigDecimal(0)) != 0){
                    da = absoluteValue.divide(costTaxTotal,mc).multiply(new BigDecimal(100));
                }
                if(da.compareTo(roleValue)>0){
                    JSONObject item = new JSONObject();
                    item.put("type", "1");
                    item.put("warnItem", "1");
                    item.put("warnName", "标前测算控项目目标成本");
                    item.put("content", "【项目目标成本】的目标成本金额："+targetcostTotal.setScale(2)+"元，大于【标前测算】的项目成本："+costTaxTotal.setScale(2)+"元");
                    list.add(item);
                }
            }
        }
        return CommonResponse.success(list);
    }
}
