package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.EngdepartRespcostEntity;
import com.ejianc.business.cost.bean.PrjcontractCostsEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostChangeEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostEntity;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IPrjcontractCostsService;
import com.ejianc.business.cost.service.IProjectTargetcostChangeService;
import com.ejianc.business.cost.service.IProjectTargetcostService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("projectTargetcost") 
public class ProjectTargetcostBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IProjectTargetcostService projectTargetcostService;
	@Autowired
	private IPrjcontractCostsService prjcontractCostsService;
	@Autowired
	private IEngdepartRespcostService engdepartRespcostService;
	@Autowired
	private IProjectTargetcostChangeService projectTargetcostChangeService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ProjectTargetcostEntity entity = projectTargetcostService.selectById(billId);
		//推送生成工程部责任成本
		engdepartRespcostService.generate(entity);
		//推送生成项目合同造价表
		prjcontractCostsService.generate(entity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		if(!resp.isSuccess()){
			return CommonResponse.error("操作失败！"+resp.getMsg());
		}
		//判断是否有变更单，有变更单不允许撤回
		QueryWrapper<ProjectTargetcostChangeEntity> changeWrapper = new QueryWrapper<>();
		changeWrapper.eq("taskcost_id", billId);
		List<ProjectTargetcostChangeEntity> list = projectTargetcostChangeService.list(changeWrapper);
		if(list!=null && list.size()>0){
			return CommonResponse.error("该单据存在变更单，不允许弃审");
		}
		//判断是否有工程部责任成本，有则不允许撤回
		QueryWrapper<EngdepartRespcostEntity> engdepartWrapper = new QueryWrapper<>();
		engdepartWrapper.eq("prjcontract_targetcost_id", billId);
		List<EngdepartRespcostEntity> engdepart = engdepartRespcostService.list(engdepartWrapper);
		if(engdepart!=null && engdepart.size()>0){
			if(engdepart.get(0).getBillState()!=0){
				return CommonResponse.error("该单据生成的工程部责任成本且已提交，不允许弃审");
			}
		}
		//判断是否有合同造价表，有则不允许撤回
		QueryWrapper<PrjcontractCostsEntity> prjcontractWrapper = new QueryWrapper<>();
		prjcontractWrapper.like("prjcontract_targetcost_ids", billId);
		List<PrjcontractCostsEntity> prjcontract = prjcontractCostsService.list(prjcontractWrapper);
		if(prjcontract!=null && prjcontract.size()>0){
			if(prjcontract.get(0).getBillState()!=0) {
				return CommonResponse.error("该单据生成的合同造价表且已提交，不允许弃审");
			}
		}

		ProjectTargetcostEntity entity = projectTargetcostService.selectById(billId);
		//撤回工程部责任成本
		engdepartRespcostService.backData(entity);
		//推送生成项目合同造价表
		prjcontractCostsService.backData(entity);

		//撤回合同造价表
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
