package com.ejianc.business.labprice.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.labprice.bean.LaborPicketageDetailEntity;
import com.ejianc.business.labprice.bean.LaborPicketageQuoteEntity;
import com.ejianc.business.labprice.bean.LaborPicketageQuoteDetailEntity;
/**
 * 定标
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_labprice_labor_picketage")
public class LaborPicketageEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 询比价单号
    @TableField(value="inquiry_id")
    private Long inquiryId; // 询价id
    @TableField(value="name")
    private String name; // 采购主题
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式 1、项目自采；2、公司集采；
    @TableField(value="project_id")
    private Long projectId; // 项目名称参照
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织参照
    @TableField(value="pricing_type")
    private Integer pricingType; // 计价方式 1：采购 2:租赁


    @TableField(value="quotation_authority")
    private Integer quotationAuthority; // 报价权限 1、候选供应商；2、所有供应商；
    @TableField(value="inquiry_mny")
    private BigDecimal inquiryMny; // 询价金额
    @TableField(value="bid_winner_id")
    private String bidWinnerId; // 中标单位id
    @TableField(value="bid_winner_name")
    private String bidWinnerName; // 中标单位名称
    @TableField(value="bid_win_mny")
    private BigDecimal bidWinMny; // 中标金额
    @TableField(value="bid_win_mny_no_tax")
    private BigDecimal bidWinMnyNoTax; // 中标金额(无税)
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="handle_date")
    private Date handleDate; // 办理日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="self_flag")
    private Integer selfFlag; // 是否自制 1:是 0:否
    @TableField(value="contract_sign")
    private Integer contractSign; // 合同签订
    @TableField(value="contract_sign_mny")
    private BigDecimal contractSignMny; // 已签合同金额
    @TableField(value="bid_win_mny_str")
    private String bidWinMnyStr; // 中标金额(多个供应商使用这个)
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="laborPicketageDetailService",pidName = "picketageId")
    private List<LaborPicketageDetailEntity> detailList = new ArrayList<>(); // 定标自制-清单
    @TableField(exist=false)
    @SubEntity(serviceName="laborPicketageQuoteService",pidName = "picketageId")
    private List<LaborPicketageQuoteEntity> quoteList = new ArrayList<>(); //  定标参照-报价记录
    @TableField(exist=false)
    @SubEntity(serviceName="laborPicketageQuoteDetailService",pidName = "picketageId")
    private List<LaborPicketageQuoteDetailEntity> quoteDetailList = new ArrayList<>(); // 定标参照-报价记录-清单
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Integer getPricingType() {
        return pricingType;
    }

    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }
    public Integer getQuotationAuthority() {
        return quotationAuthority;
    }

    public void setQuotationAuthority(Integer quotationAuthority) {
        this.quotationAuthority = quotationAuthority;
    }
    public BigDecimal getInquiryMny() {
        return inquiryMny;
    }

    public void setInquiryMny(BigDecimal inquiryMny) {
        this.inquiryMny = inquiryMny;
    }
    public String getBidWinnerId() {
        return bidWinnerId;
    }

    public void setBidWinnerId(String bidWinnerId) {
        this.bidWinnerId = bidWinnerId;
    }
    public String getBidWinnerName() {
        return bidWinnerName;
    }

    public void setBidWinnerName(String bidWinnerName) {
        this.bidWinnerName = bidWinnerName;
    }
    public BigDecimal getBidWinMny() {
        return bidWinMny;
    }

    public void setBidWinMny(BigDecimal bidWinMny) {
        this.bidWinMny = bidWinMny;
    }
    public BigDecimal getBidWinMnyNoTax() {
        return bidWinMnyNoTax;
    }

    public void setBidWinMnyNoTax(BigDecimal bidWinMnyNoTax) {
        this.bidWinMnyNoTax = bidWinMnyNoTax;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSelfFlag() {
        return selfFlag;
    }

    public void setSelfFlag(Integer selfFlag) {
        this.selfFlag = selfFlag;
    }
    public Integer getContractSign() {
        return contractSign;
    }

    public void setContractSign(Integer contractSign) {
        this.contractSign = contractSign;
    }
    public BigDecimal getContractSignMny() {
        return contractSignMny;
    }

    public void setContractSignMny(BigDecimal contractSignMny) {
        this.contractSignMny = contractSignMny;
    }
    public String getBidWinMnyStr() {
        return bidWinMnyStr;
    }

    public void setBidWinMnyStr(String bidWinMnyStr) {
        this.bidWinMnyStr = bidWinMnyStr;
    }


    public List<LaborPicketageDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<LaborPicketageDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<LaborPicketageQuoteEntity> getQuoteList() {
        return quoteList;
    }

    public void setQuoteList(List<LaborPicketageQuoteEntity> quoteList) {
        this.quoteList = quoteList;
    }

    public List<LaborPicketageQuoteDetailEntity> getQuoteDetailList() {
        return quoteDetailList;
    }

    public void setQuoteDetailList(List<LaborPicketageQuoteDetailEntity> quoteDetailList) {
        this.quoteDetailList = quoteDetailList;
    }
}
