package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractChangeEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.mapper.OtherContractMapper;
import com.ejianc.business.other.service.IOtherContractChangeService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherContractDetailVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.SqlParam;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.*;

/**
 * 其他支出合同实体
 *
 * @author generator
 */
@Service("otherContractService")
public class OtherContractServiceImpl extends BaseServiceImpl<OtherContractMapper, OtherContractEntity> implements IOtherContractService {
    private static final String BILL_CODE = "OTHER_CONTRACT_CODE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOtherSettleService settleService;
    private static final String PARAM_TOTAL_MNY = "P-6zD11147"; // 【预算间接费总金额】控 【实际间接费总金额】
    @Autowired
    private IParamConfigApi paramConfigApi;


    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IOtherContractChangeService changeService;

    @Autowired
    private IAttachmentApi attachmentApi;


    @Override
    public CommonResponse<OtherContractVO> saveOrUpdate(OtherContractVO contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = null;
        if (StringUtils.isBlank(contractVo.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                contractVo.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) { //修改
            entity = BeanMapper.map(contractVo, OtherContractEntity.class);
        } else {
            //新增设置 竣工结算标志
            contractVo.setIsFinish(0);
            entity = BeanMapper.map(contractVo, OtherContractEntity.class);
            entity.setIsSupplement("0");
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.ne(OtherContractEntity::getId, contractVo.getId());
            List<OtherContractEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.eq(OtherContractEntity::getBillCode, contractVo.getBillCode());
            List<OtherContractEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());//初始版本金额(含税)
        entity.setBaseMoney(entity.getContractMny());//初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());//变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny());//变更前金额(不含税)
        boolean b = super.saveOrUpdate(entity, false);
        if (b) {
            this.countContractNumAndMnyByEnquiry(entity.getEnquiryPriceBillId());
        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public OtherContractVO queryDetail(Long id) {
        OtherContractEntity entity = super.selectById(id);
        OtherContractVO vo = BeanMapper.map(entity, OtherContractVO.class);
        List<OtherContractDetailVO> detailVos = vo.getDetailVos();
        List<OtherContractDetailVO> detail = new ArrayList<>();
        if (detailVos != null && detailVos.size() > 0) {
            for (OtherContractDetailVO dvo : detailVos) {
                if (dvo.getChangeType() == null || dvo.getChangeType() != 5) {
                    detail.add(dvo);
                }
            }
        }
        vo.setDetailVos(detail);
        return vo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
        return resp;
    }

    @Override
    public List<OtherProjectReportVo> getMonthOtherMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthOtherMny(projectId, lastDay);
    }

    @Override
    public OtherProjectReportVo getOtherContract(Long projectId) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);

        // 合同数量 金额
        LambdaQueryWrapper<OtherContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OtherContractEntity::getProjectId, projectId);
        wrapper.eq(OtherContractEntity::getDr, 0);
        wrapper.eq(OtherContractEntity::getSupplementFlag, 0);
        wrapper.in(OtherContractEntity::getBillState, billStatus);
        List<OtherContractEntity> otherContractEntityList = super.list(wrapper);
        BigDecimal mny = otherContractEntityList.stream().filter(entity -> entity.getContractTaxMny() != null).map(OtherContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 结算金额
        LambdaQueryWrapper<OtherSettleEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(OtherSettleEntity::getProjectId, projectId);
        wrapper2.eq(OtherSettleEntity::getDr, 0);
        wrapper2.in(OtherSettleEntity::getBillState, billStatus);
        List<OtherSettleEntity> settlementEntityList = settleService.list(wrapper2);
        BigDecimal settleMny = settlementEntityList.stream().filter(entity -> entity.getSettleTaxMny() != null).map(OtherSettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        OtherProjectReportVo vo = new OtherProjectReportVo();
        vo.setMny(mny);
        vo.setNum(otherContractEntityList.size());
        vo.setSettleMny(settleMny);

        return vo;
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPrePayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryTaxWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.querySettleWarnContract(sqlParamList);
    }




    @Override
    public BigDecimal totalContractMny(OtherContractVO vo){
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper<OtherContractEntity> contractQuery = new QueryWrapper<>();
        contractQuery.eq("project_Id", vo.getProjectId());
        contractQuery.ne("change_status",2);
        if (vo.getId()!=null){
            contractQuery.ne("id",vo.getId());
        }
        if (vo.getContractTaxMny()!=null){
            contractTaxMny =contractTaxMny.add(vo.getContractTaxMny());
        }
        contractQuery.select("sum(contract_tax_mny) as contractTaxMny");
        OtherContractEntity contractEntity = super.getOne(contractQuery);
        if(contractEntity!=null &&null != contractEntity.getContractTaxMny()&&!"0".equals(contractEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(contractEntity.getContractTaxMny());
        }
        //统计变更中的金额
        QueryWrapper<OtherContractChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select("sum(contract_tax_mny) as contractTaxMny");
        OtherContractChangeEntity changeEntity = changeService.getOne(changeQuery);
        if (changeEntity != null && null != changeEntity.getContractTaxMny() && !"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return contractTaxMny;
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull(projectId, "项目id不能为空");
        return baseMapper.fetchSjzcje(projectId, null, null);
    }


    /**
     * @return {@link PicketageVO}
     *
     * @description: 根据定标单回写已签合同数量和金额
     * @author songlx
     * @date: 2023/11/8
     * @param enquiryPriceBillIds
     */
    @Override
    public PicketageVO countContractNumAndMnyByEnquiry(Long... enquiryPriceBillIds) {
        return null;
    }

}
