/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.mapper.PurchaseSettlementMapper;
import com.ejianc.business.material.mapper.PurchaseSettlementMaterialDetailMapper;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.MaterialContractDetailSubVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.PurchaseSettlementVO;
import com.ejianc.business.material.vo.SettleNumberVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseSettlementService
extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity>
implements IPurchaseSettlementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private PurchaseSettlementMaterialDetailMapper purchaseSettlementMaterialDetailMapper;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-41513I11";
    private static String PARAM_PLAN_PRICE = "P-u2AcaJ12";
    private static String PARAM_PRICE_AREA = "P-166rjs14";
    private static String PARAM_DETAIL_PRICE = "P-7PCBV283";
    private static String PARAM_PRICE_CONTRACT = "P-hSH85015";

    @Override
    public IPage<PurchaseSettlementVO> queryForList(QueryParam queryParam, boolean isEs) {
        boolean payApplyFlagHasFree = queryParam.getParams().containsKey("payApplyFlagHasFree");
        queryParam.getParams().remove("payApplyFlagHasFree");
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            List purchaseSettlementVOS = BeanMapper.mapList((Iterable)entityPage.getRecords(), PurchaseSettlementVO.class);
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(purchaseSettlementVOS);
        }
        return voPage;
    }

    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper query = PurchaseSettlementService.changeToQueryWrapper((QueryParam)queryParam);
        query.select(new String[]{"sum(current_settlement_amount_tax) as totalSettleAmount"});
        Map amount = super.getMap((Wrapper)query);
        return null != amount ? new BigDecimal(amount.get("totalSettleAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }

    @Override
    public BigDecimal calculateTotalSettlementNoTax(QueryParam queryParam) {
        QueryWrapper query = PurchaseSettlementService.changeToQueryWrapper((QueryParam)queryParam);
        query.select(new String[]{"sum(current_settlement_amount) as totalSettleAmountNoTax"});
        Map amount = super.getMap((Wrapper)query);
        return null != amount ? new BigDecimal(amount.get("totalSettleAmountNoTax").toString()) : BigDecimal.ZERO.setScale(8);
    }

    @Override
    public void processCost(PurchaseSettlementEntity entity) {
        String factor = "1";
        boolean canPush = true;
        entity.setRelationFlag(canPush ? "1" : "0");
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, BigDecimal settledAmount, BigDecimal currentSettlementAmount, BigDecimal contractAmount, String purchaseMethod, MaterialPriceVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        List<MaterialPriceVO> detailList = vo.getDetail();
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        if (CollectionUtils.isNotEmpty(detailList) && (int)detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            HashMap numMap = new HashMap();
            detailList.forEach(detail -> {
                MaterialPriceVO materialPriceVO = (MaterialPriceVO)((Object)((Object)numMap.get(detail.getMaterialId())));
                if (materialPriceVO != null) {
                    materialPriceVO.setNum(ComputeUtil.safeAdd(materialPriceVO.getNum(), detail.getNum()));
                    materialPriceVO.setPrice(ComputeUtil.isLessThan(detail.getPrice(), materialPriceVO.getPrice()) ? detail.getPrice() : materialPriceVO.getPrice());
                } else {
                    numMap.put(detail.getMaterialId(), detail);
                }
            });
            vo.setDetail(new ArrayList<MaterialPriceVO>(numMap.values()));
            List<MaterialPriceVO> detail2 = vo.getDetail();
            if (CollectionUtils.isNotEmpty(detail2)) {
                CommonResponse response;
                CommonResponse response1;
                StringBuffer stringBuffer;
                ParamsCheckDsVO paramsCheckDsVO;
                if (isJc == 0) {
                    CommonResponse response12;
                    CommonResponse response2 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_COUNT, curOrgId);
                    if (!response2.isSuccess()) {
                        throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u5236\u3010\u7269\u8d44\u5408\u540c\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response2.getMsg());
                    }
                    List billParamVOS = (List)response2.getData();
                    if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                        for (BillParamVO billParamVO : billParamVOS) {
                            if (0 == billParamVO.getControlType()) continue;
                            List materialIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                            List<MaterialPriceVO> vos = this.purchaseSettlementMaterialDetailMapper.purchaseSettlementMaterialDetailMapper(vo.getProjectId(), materialIds);
                            Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                            for (MaterialPriceVO d : detail2) {
                                BigDecimal num = d.getNum();
                                BigDecimal planNum = d.getPlanNum();
                                BigDecimal _planNum = planNum.multiply(divide);
                                BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                                BigDecimal allNum = hasNum.add(num);
                                if (allNum.compareTo(_planNum) <= 0) continue;
                                ParamsCheckDsVO paramsCheckDsVO2 = new ParamsCheckDsVO();
                                paramsCheckDsVO2.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO2.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                paramsCheckDsVO2.setWarnName("\u7269\u8d44\u7ed3\u7b97\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u91cf");
                                StringBuffer stringBuffer2 = new StringBuffer();
                                stringBuffer2.append("\u672c\u6b21\u7ed3\u7b97\u6570\u91cf\uff1a").append(num.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\uff0c\u5df2\u7ed3\u7b97\u6570\u91cf\uff1a").append(hasNum.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue.setScale(8, 4).stripTrailingZeros().toPlainString()).append("%:").append(_planNum.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(_planNum).setScale(4, 4).stripTrailingZeros().toPlainString());
                                paramsCheckDsVO2.setContent(stringBuffer2.toString());
                                PurchaseSettlementService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO2);
                            }
                        }
                    }
                    if (!(response12 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_PRICE, curOrgId)).isSuccess()) {
                        throw new BusinessException("\u603b\u8ba1\u5212\u4ef7\u683c\u3010\u603b\u8ba1\u5212\u4ef7\u3011\u63a7\u5236\u3010\u7269\u8d44\u7ed3\u7b97\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response12.getMsg());
                    }
                    List billParamVOS1 = (List)response12.getData();
                    if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                        for (BillParamVO billParamVO : billParamVOS1) {
                            if (0 == billParamVO.getControlType()) continue;
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                            for (MaterialPriceVO d : detail2) {
                                BigDecimal planPrice;
                                BigDecimal price = d.getPrice();
                                if (price.compareTo(planPrice = d.getPlanPrice()) <= 0) continue;
                                BigDecimal _planPrice = planPrice.multiply(divide);
                                paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u5355\u4ef7\u5927\u4e8e\u603b\u8ba1\u5212\u5355\u4ef7");
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u5355\u4ef7\uff1a").append(price.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\uff0c\u603b\u8ba1\u5212\u5355\u4ef7*").append(roleValue.setScale(8, 4).stripTrailingZeros().toPlainString()).append("%: ").append(_planPrice.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(price.subtract(_planPrice).setScale(4, 4).stripTrailingZeros().toPlainString());
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                PurchaseSettlementService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        }
                    }
                }
                if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PRICE_AREA, curOrgId)).isSuccess()) {
                    throw new BusinessException("\u7ed3\u7b97\u5386\u53f2\u4ef7\u683c\u533a\u95f4\u3010\u5386\u53f2\u4ef7\u3011\u63a7\u5236\u3010\u7269\u8d44\u7ed3\u7b97\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response1.getMsg());
                }
                List billParamVOS1 = (List)response1.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                    for (BillParamVO billParamVO : billParamVOS1) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO d : detail2) {
                            BigDecimal price = d.getPrice();
                            BigDecimal maxPrice = d.getMaxPrice() == null ? BigDecimal.ZERO : d.getMaxPrice();
                            BigDecimal minPrice = d.getMinPrice();
                            if (price.compareTo(maxPrice) <= 0 || maxPrice.compareTo(BigDecimal.ZERO) <= 0) continue;
                            BigDecimal _maxPrice = maxPrice.multiply(divide);
                            BigDecimal _minPrice = minPrice.multiply(divide);
                            paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u5355\u4ef7\u5927\u4e8e\u7269\u8d44\u5386\u53f2\u4ef7");
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u5355\u4ef7\uff1a").append(price.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\uff0c\u7269\u8d44\u5386\u53f2\u4ef7*").append(roleValue.setScale(8, 4).stripTrailingZeros().toPlainString()).append("%: ").append(_minPrice.setScale(4, 4).stripTrailingZeros().toPlainString()).append("~").append(_maxPrice.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\u3002\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(price.subtract(_maxPrice).setScale(4, 4).stripTrailingZeros().toPlainString());
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            PurchaseSettlementService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
                if (!(response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_DETAIL_PRICE, curOrgId)).isSuccess()) {
                    throw new BusinessException("\u3010\u6750\u6599\u5408\u540c\u4ef7\u3011\u63a7\u5236\u3010\u6750\u6599\u7ed3\u7b97\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                }
                List billParamVOS = (List)response.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                    MaterialContractEntity materialContractEntity = (MaterialContractEntity)((Object)this.materialContractService.selectById(contractId));
                    MaterialContractVO contractVO = (MaterialContractVO)((Object)BeanMapper.map((Object)((Object)materialContractEntity), MaterialContractVO.class));
                    List<MaterialContractDetailSubVO> materialDetailList = contractVO.getMaterialDetailList();
                    Map<Object, Object> conMap = new HashMap();
                    if (CollectionUtils.isNotEmpty(materialDetailList)) {
                        conMap = materialDetailList.stream().collect(Collectors.toMap(MaterialContractDetailSubVO::getMaterialId, MaterialContractDetailSubVO::getUnitPrice, (v1, v2) -> v2));
                    }
                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO d : detail2) {
                            BigDecimal conPrice;
                            BigDecimal _conPrice;
                            BigDecimal price;
                            if (!conMap.keySet().contains(String.valueOf(d.getMaterialId())) || (price = d.getPrice()).compareTo(_conPrice = ComputeUtil.safeMultiply(conPrice = ComputeUtil.nullToZero((BigDecimal)conMap.get(String.valueOf(d.getMaterialId()))), divide)) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO3 = new ParamsCheckDsVO();
                            paramsCheckDsVO3.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO3.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO3.setWarnName("\u6750\u6599\u7ed3\u7b97\u5355\u4ef7\u5927\u4e8e\u91c7\u8d2d\u5408\u540c\u4ef7");
                            StringBuffer stringBuffer3 = new StringBuffer();
                            stringBuffer3.append("\u672c\u6b21\u7ed3\u7b97\u5355\u4ef7\uff1a").append(price.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\uff0c\u91c7\u8d2d\u5408\u540c\u5355\u4ef7*").append(roleValue.setScale(8, 4).stripTrailingZeros().toPlainString()).append("%: ").append(_conPrice.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub(price, _conPrice).setScale(4, 4).stripTrailingZeros().toPlainString());
                            paramsCheckDsVO3.setContent(stringBuffer3.toString());
                            PurchaseSettlementService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO3);
                        }
                    }
                }
            }
        }
        if (isJc == 0) {
            CommonResponse response2 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PRICE_CONTRACT, curOrgId);
            if (!response2.isSuccess()) {
                throw new BusinessException("\u3010\u5408\u540c\u91d1\u989d\u3011\u63a7\u5236\u3010\u7ed3\u7b97\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response2.getMsg());
            }
            List billParamVOS2 = (List)response2.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS2)) {
                for (BillParamVO billParamVO : billParamVOS2) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = contractAmount.multiply(roleValue.divide(BigDecimal.valueOf(100L)));
                    BigDecimal sumPayWithThisMny = settledAmount.add(currentSettlementAmount);
                    if (sumPayWithThisMny.compareTo(comMny) <= 0) continue;
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                    paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(currentSettlementAmount.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue.setScale(8, 4).stripTrailingZeros().toPlainString()).append("%: ").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(sumPayWithThisMny.subtract(comMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    PurchaseSettlementService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public JSONObject querySettleNum(SettleNumberVO settleNumberVO) {
        JSONObject result = new JSONObject();
        Long projectId = settleNumberVO.getProjectId();
        Long contractId = settleNumberVO.getContractId();
        List<Long> materialIds = settleNumberVO.getMaterialIds();
        List<SettleNumberVO> list = this.purchaseSettlementMaterialDetailMapper.querySettleNum(projectId, contractId, materialIds);
        Map<Long, BigDecimal> settleNumMap = list.stream().collect(Collectors.toMap(SettleNumberVO::getMaterialId, SettleNumberVO::getSettleNumber));
        result.put("projectId", (Object)projectId);
        result.put("contractId", (Object)contractId);
        result.put("settleNumMap", settleNumMap);
        return result;
    }

    @Override
    public List<Map<String, Object>> querySettlePayWarn(List<SqlParam> sqlParamList) {
        return ((PurchaseSettlementMapper)this.baseMapper).querySettlePayWarn(sqlParamList);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(current_settlement_amount_tax) as sumSettlementAmountTax, sum(current_apply_amount) as sumApplyAmount, sum(current_paid_amount) as sumPaidAmount"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("sumSettlementAmountTax", 0);
            resp.put("sumApplyAmount", 0);
            resp.put("sumPaidAmount", 0);
        }
        return resp;
    }
}

